/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.rap.basic.table;

import org.eclipse.scout.commons.holders.IntegerHolder;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Widget;

public abstract class AbstractAvoidWrongDoubleClickListener
implements Listener {
    private static final long serialVersionUID = 1L;
    private final IntegerHolder mouseUpIndex = new IntegerHolder();
    private final IntegerHolder mouseDoubleClickIndex = new IntegerHolder();

    public final void handleEvent(Event event) {
        switch (event.type) {
            case 8: {
                int dcIndex = this.getElementIndex(event);
                if (dcIndex > 0) {
                    if (this.mouseUpIndex.getValue() != null && (Integer)this.mouseUpIndex.getValue() != dcIndex) break;
                    this.mouseDoubleClickIndex.setValue((Object)dcIndex);
                }
                this.handleEventInternal(event);
                break;
            }
            case 4: {
                if (this.mouseDoubleClickIndex.getValue() != null) {
                    this.mouseDoubleClickIndex.setValue(null);
                    break;
                }
                int index = this.getElementIndex(event);
                if (index >= 0) {
                    this.mouseUpIndex.setValue((Object)index);
                } else {
                    this.mouseUpIndex.setValue(null);
                }
                this.handleEventInternal(event);
                break;
            }
            default: {
                this.handleEventInternal(event);
            }
        }
    }

    public abstract void handleEventInternal(Event var1);

    protected int getElementIndex(Event event) {
        Point eventPosition = new Point(event.x, event.y);
        Widget widget = event.widget;
        if (widget instanceof List) {
            return this.getItemIndex(eventPosition, (List)widget);
        }
        if (widget instanceof Table) {
            return this.getItemIndex(eventPosition, (Table)widget);
        }
        return -1;
    }

    protected int getItemIndex(Point point, List list) {
        return this.getItemIndex(point, list.getClientArea(), list.getItemHeight(), list.getTopIndex());
    }

    protected int getItemIndex(Point point, Table table) {
        return this.getItemIndex(point, table.getClientArea(), table.getItemHeight(), table.getTopIndex());
    }

    private int getItemIndex(Point point, Rectangle itemsArea, int itemHeight, int topIndex) {
        if (itemsArea.contains(point)) {
            int index = point.y / itemHeight - 1;
            if (point.y % itemHeight != 0) {
                ++index;
            }
            return index += topIndex;
        }
        return -1;
    }
}

