/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.rap.basic.table;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.scout.commons.CollectionUtility;
import org.eclipse.scout.commons.HTMLUtility;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.client.ui.basic.cell.ICell;
import org.eclipse.scout.rt.client.ui.basic.table.ITable;
import org.eclipse.scout.rt.client.ui.basic.table.ITableRow;
import org.eclipse.scout.rt.client.ui.basic.table.columns.IColumn;
import org.eclipse.scout.rt.client.ui.basic.table.columns.IProposalColumn;
import org.eclipse.scout.rt.client.ui.basic.table.columns.IStringColumn;
import org.eclipse.scout.rt.ui.rap.basic.table.RwtScoutTable;
import org.eclipse.scout.rt.ui.rap.basic.table.RwtScoutTableEvent;
import org.eclipse.scout.rt.ui.rap.basic.table.TableColumnManager;
import org.eclipse.scout.rt.ui.rap.extension.UiDecorationExtensionPoint;
import org.eclipse.scout.rt.ui.rap.util.HtmlTextUtility;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;

public class RwtScoutColumnModel
extends ColumnLabelProvider {
    public static final String EDITABLE_VARIANT_PREFIX = "EDITABLE_CELL_VARIANT_";
    public static final String EDITABLE_VARIANT_CELL_MARKER = "EDITABLE";
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(RwtScoutColumnModel.class);
    private static final long serialVersionUID = 1L;
    private final ITable m_scoutTable;
    private final RwtScoutTable m_uiTable;
    private final TableColumnManager m_columnManager;
    private final Image m_imgCheckboxFalse;
    private final Image m_imgCheckboxTrue;
    private final Color m_disabledForegroundColor;
    private Map<ITableRow, Map<IColumn<?>, P_CachedCell>> m_cachedCells;

    public RwtScoutColumnModel(ITable scoutTable, RwtScoutTable uiTable, TableColumnManager columnManager) {
        this.m_scoutTable = scoutTable;
        this.m_uiTable = uiTable;
        this.m_columnManager = columnManager;
        this.m_imgCheckboxTrue = this.getUiTable().getUiEnvironment().getIcon("checkbox_yes");
        this.m_imgCheckboxFalse = this.getUiTable().getUiEnvironment().getIcon("checkbox_no");
        this.m_disabledForegroundColor = this.getUiTable().getUiEnvironment().getColor(UiDecorationExtensionPoint.getLookAndFeel().getColorForegroundDisabled());
        this.rebuildCache();
    }

    protected ITable getScoutTable() {
        return this.m_scoutTable;
    }

    public RwtScoutTable getUiTable() {
        return this.m_uiTable;
    }

    public void update(ViewerCell cell) {
        ITableRow row = (ITableRow)cell.getElement();
        int columnIndex = cell.getColumnIndex();
        cell.setText(this.getColumnText(row, columnIndex));
        cell.setImage(this.getColumnImage(row, columnIndex));
        cell.setBackground(this.getBackground(row, columnIndex));
        cell.setForeground(this.getForeground(row, columnIndex));
        cell.setFont(this.getFont(row, columnIndex));
        if (cell.getColumnIndex() == 1) {
            cell.getItem().setData("org.eclipse.rap.rwt.customVariant", (Object)this.createTableRowVariant(row));
        }
    }

    public String getColumnText(ITableRow element, int columnIndex) {
        ICell cell = this.getCell(element, columnIndex);
        if (cell == null) {
            return "";
        }
        String text = cell.getText();
        if (text == null) {
            text = "";
        } else if (HtmlTextUtility.isTextWithHtmlMarkup(text)) {
            text = this.getUiTable().getUiEnvironment().adaptHtmlCell(this.getUiTable(), text);
            text = this.getUiTable().getUiEnvironment().convertLinksInHtmlCell(this.getUiTable(), text);
        } else {
            boolean multiline = this.isMultiline(text);
            if (!multiline) {
                text = this.replaceLineBreaksInMultilineText(text);
            }
            boolean isMultilineTable = this.getScoutTable().isMultilineText();
            boolean markupEnabled = Boolean.TRUE.equals(this.getUiTable().getUiField().getData("org.eclipse.rap.rwt.markupEnabled"));
            if (markupEnabled || multiline) {
                boolean replaceBreakableChars = true;
                IColumn<?> column = this.m_columnManager.getColumnByModelIndex(columnIndex - 1);
                if (column instanceof IStringColumn && isMultilineTable) {
                    IStringColumn stringColumn = (IStringColumn)column;
                    replaceBreakableChars = !stringColumn.isTextWrap();
                }
                text = HtmlTextUtility.transformPlainTextToHtml(text, replaceBreakableChars);
            }
        }
        return text;
    }

    private boolean isMultiline(String text) {
        return this.isMultilineText(text) && this.getScoutTable().isMultilineText();
    }

    private boolean isMultilineText(String text) {
        return text.indexOf("\n") >= 0;
    }

    private String replaceLineBreaksInMultilineText(String text) {
        if (this.isMultilineText(text)) {
            text = StringUtility.replaceNewLines((String)text, (String)" ");
        }
        return text;
    }

    public Image getColumnImage(ITableRow element, int columnIndex) {
        int[] columnOrder = this.getUiTable().getUiField().getColumnOrder();
        if (columnOrder.length <= 1) {
            return null;
        }
        IColumn<?> col = this.m_columnManager.getColumnByModelIndex(columnIndex - 1);
        ICell cell = this.getCell(element, columnIndex);
        Image checkBoxImage = null;
        if (columnOrder[1] == columnIndex && this.getUiTable().getScoutObject() != null && ((ITable)this.getUiTable().getScoutObject()).isCheckable()) {
            checkBoxImage = element.isChecked() ? this.m_imgCheckboxTrue : this.m_imgCheckboxFalse;
        } else if (!(col == null || cell == null || col.getDataType() != Boolean.class || col instanceof IProposalColumn && ((IProposalColumn)col).getLookupCall() != null)) {
            Boolean b = (Boolean)cell.getValue();
            checkBoxImage = b != null && b != false ? this.m_imgCheckboxTrue : this.m_imgCheckboxFalse;
        }
        String iconId = null;
        if (cell != null && cell.getErrorStatus() != null && cell.getErrorStatus().getSeverity() == 4) {
            iconId = "status_error";
        } else if (cell != null && cell.getIconId() != null) {
            iconId = cell.getIconId();
        } else if (columnOrder[1] == columnIndex) {
            iconId = element.getIconId();
        }
        Image decoImage = this.getUiTable().getUiEnvironment().getIcon(iconId);
        if (checkBoxImage != null && decoImage != null) {
            return checkBoxImage;
        }
        if (checkBoxImage != null) {
            return checkBoxImage;
        }
        if (decoImage != null) {
            return decoImage;
        }
        return null;
    }

    public Color getBackground(ITableRow element, int columnIndex) {
        ICell cell;
        if (columnIndex > 0 && (cell = this.getCell(element, columnIndex)) != null) {
            return this.getUiTable().getUiEnvironment().getColor(cell.getBackgroundColor());
        }
        return null;
    }

    public Color getForeground(ITableRow element, int columnIndex) {
        ICell cell;
        if (columnIndex > 0 && (cell = this.getCell(element, columnIndex)) != null) {
            Color col = this.getUiTable().getUiEnvironment().getColor(cell.getForegroundColor());
            if (!(col != null || element.isEnabled() && cell.isEnabled())) {
                col = this.m_disabledForegroundColor;
            }
            return col;
        }
        return null;
    }

    public Font getFont(ITableRow element, int columnIndex) {
        ICell cell;
        if (columnIndex > 0 && (cell = this.getCell(element, columnIndex)) != null) {
            return this.getUiTable().getUiEnvironment().getFont(cell.getFont(), this.getUiTable().getUiField().getFont());
        }
        return null;
    }

    public String getToolTipText(Object element) {
        Display display = this.getUiTable().getUiEnvironment().getDisplay();
        Point cursorOnTable = display.map(null, (Control)this.getUiTable().getUiField(), display.getCursorLocation());
        ViewerCell uiCell = this.getUiTable().getUiTableViewer().getCell(cursorOnTable);
        String text = "";
        if (uiCell != null) {
            int columnIndex = uiCell.getColumnIndex();
            ICell cell = this.getCell(element, columnIndex);
            if (cell != null && (text = cell.getTooltipText()) == null) {
                text = cell.getText();
                if (HtmlTextUtility.isTextWithHtmlMarkup(text)) {
                    text = HTMLUtility.getPlainText((String)text);
                }
                if (text == null || text.indexOf("\n") <= 0) {
                    text = "";
                }
            }
            text = StringUtility.wrapWord((String)text, (int)80);
        }
        return text;
    }

    public void consumeColumnModelEvent(RwtScoutTableEvent uiTableEvent) {
        this.rebuildCache();
    }

    protected ICell getCell(Object row, int colIndex) {
        IColumn<?> column = this.m_columnManager.getColumnByModelIndex(colIndex - 1);
        if (column != null) {
            P_CachedCell cachedCell;
            if (this.m_cachedCells == null || this.m_cachedCells.get(row) == null) {
                this.rebuildCache();
            }
            if ((cachedCell = this.m_cachedCells.get(row).get(column)) != null) {
                return cachedCell.m_cell;
            }
        }
        return null;
    }

    protected String createTableRowVariant(ITableRow row) {
        StringBuilder builder = new StringBuilder();
        Map<IColumn<?>, P_CachedCell> cachedRow = this.m_cachedCells.get(row);
        int[] visibleColumnIndexes = this.getScoutTable().getColumnSet().getVisibleColumnIndexes();
        boolean isEditable = false;
        int i = 0;
        while (i < visibleColumnIndexes.length) {
            P_CachedCell cachedCell;
            IColumn col;
            if (i > 0) {
                builder.append('_');
            }
            if ((col = this.getScoutTable().getColumnSet().getColumn(visibleColumnIndexes[i])) != null && cachedRow != null && (cachedCell = cachedRow.get(col)) != null && cachedCell.m_isEditable) {
                builder.append(EDITABLE_VARIANT_CELL_MARKER);
                isEditable = true;
            }
            ++i;
        }
        if (isEditable) {
            builder.insert(0, EDITABLE_VARIANT_PREFIX);
            return builder.toString();
        }
        return null;
    }

    protected boolean isEditableIconNeededInScoutThread(ITableRow row, IColumn<?> column) {
        if (column == null || row == null) {
            return false;
        }
        if (column.getDataType().isAssignableFrom(Boolean.class)) {
            return false;
        }
        ITable scoutTable = this.getScoutTable();
        if (scoutTable == null) {
            return false;
        }
        return scoutTable.isCellEditable(row, column);
    }

    private void rebuildCache() {
        if (this.getScoutTable() == null) {
            this.m_cachedCells = CollectionUtility.emptyHashMap();
            return;
        }
        Runnable r = new Runnable(){

            @Override
            public void run() {
                List rows = RwtScoutColumnModel.this.getScoutTable().getRows();
                HashMap tmp = new HashMap(rows.size());
                for (ITableRow scoutRow : rows) {
                    List visibleColumns = RwtScoutColumnModel.this.getScoutTable().getColumnSet().getVisibleColumns();
                    HashMap<IColumn, P_CachedCell> cells = new HashMap<IColumn, P_CachedCell>(visibleColumns.size());
                    for (IColumn col : visibleColumns) {
                        ICell cell = RwtScoutColumnModel.this.getScoutTable().getCell(scoutRow, col);
                        boolean isCellEditable = RwtScoutColumnModel.this.isEditableIconNeededInScoutThread(scoutRow, col);
                        cells.put(col, new P_CachedCell(cell, isCellEditable));
                    }
                    tmp.put(scoutRow, cells);
                }
                RwtScoutColumnModel.this.m_cachedCells = tmp;
            }
        };
        try {
            this.getUiTable().getUiEnvironment().invokeScoutLater(r, 2345L).join(2345L);
        }
        catch (InterruptedException e) {
            LOG.warn("Interrupted while waiting for the model.", (Throwable)e);
        }
    }

    private static final class P_CachedCell {
        private final ICell m_cell;
        private final boolean m_isEditable;

        private P_CachedCell(ICell cell, boolean isEditable) {
            this.m_cell = cell;
            this.m_isEditable = isEditable;
        }
    }
}

