/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.rap.form.fields.browserfield;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.scout.commons.IOUtility;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.commons.exception.ProcessingException;
import org.eclipse.scout.commons.job.JobEx;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.client.ui.form.fields.IFormField;
import org.eclipse.scout.rt.client.ui.form.fields.browserfield.IBrowserField;
import org.eclipse.scout.rt.shared.services.common.file.RemoteFile;
import org.eclipse.scout.rt.ui.rap.LogicalGridLayout;
import org.eclipse.scout.rt.ui.rap.ext.StatusLabelEx;
import org.eclipse.scout.rt.ui.rap.ext.browser.BrowserExtension;
import org.eclipse.scout.rt.ui.rap.ext.browser.IHyperlinkCallback;
import org.eclipse.scout.rt.ui.rap.form.fields.RwtScoutValueFieldComposite;
import org.eclipse.scout.rt.ui.rap.form.fields.browserfield.IRwtScoutBrowserField;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.LocationAdapter;
import org.eclipse.swt.browser.LocationEvent;
import org.eclipse.swt.browser.LocationListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public class RwtScoutBrowserField
extends RwtScoutValueFieldComposite<IBrowserField>
implements IRwtScoutBrowserField {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(RwtScoutBrowserField.class);
    private BrowserExtension m_browserExtension;

    @Override
    protected void attachScout() {
        super.attachScout();
        if (((IBrowserField)this.getScoutObject()).getLocation() != null) {
            this.setLocationFromScout();
        }
    }

    @Override
    protected void initializeUi(Composite parent) {
        Composite container = this.getUiEnvironment().getFormToolkit().createComposite(parent);
        StatusLabelEx label = this.getUiEnvironment().getFormToolkit().createStatusLabel(container, (IFormField)this.getScoutObject());
        Browser browser = this.getUiEnvironment().getFormToolkit().createBrowser(container, 0);
        this.setUiField((Control)browser);
        browser.addLocationListener((LocationListener)new LocationAdapter(){
            private static final long serialVersionUID = 1L;

            public void changing(LocationEvent event) {
                boolean changeAccepted;
                event.doit = changeAccepted = RwtScoutBrowserField.this.fireBeforeLocationChangedFromUi(event.location);
            }

            public void changed(LocationEvent event) {
                if (RwtScoutBrowserField.this.m_browserExtension != null && RwtScoutBrowserField.this.isExternalUrl(event.location)) {
                    RwtScoutBrowserField.this.detachBrowserExtension();
                }
                RwtScoutBrowserField.this.fireAfterLocationChangedFromUi(event.location);
            }
        });
        this.setUiContainer(container);
        this.setUiLabel(label);
        this.getUiContainer().setLayout((Layout)new LogicalGridLayout(1, 0));
    }

    protected boolean isExternalUrl(String location) {
        boolean externalUrl = false;
        try {
            String host = new URL(location).getHost();
            externalUrl = StringUtility.hasText((CharSequence)host) && StringUtility.notEqualsIgnoreCase((String)"local", (String)host);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return externalUrl;
    }

    protected void attachBrowserExtension(Browser browser) {
        this.detachBrowserExtension();
        BrowserExtension browserExtension = new BrowserExtension(browser, this.getUiEnvironment(), new IHyperlinkCallback(){

            @Override
            public void execute(String url) {
                RwtScoutBrowserField.this.setLocationInternal(url);
            }
        });
        browserExtension.attach();
        browser.addDisposeListener(new DisposeListener(){
            private static final long serialVersionUID = 1L;

            public void widgetDisposed(DisposeEvent e) {
                RwtScoutBrowserField.this.detachBrowserExtension();
            }
        });
        this.adaptBrowserExtension(browserExtension);
        this.m_browserExtension = browserExtension;
    }

    protected void adaptBrowserExtension(BrowserExtension browserExtension) {
    }

    protected void detachBrowserExtension() {
        if (this.m_browserExtension != null) {
            this.m_browserExtension.detach();
            this.m_browserExtension = null;
        }
    }

    public Browser getUiField() {
        return (Browser)super.getUiField();
    }

    @Override
    protected void handleScoutPropertyChange(String name, Object newValue) {
        super.handleScoutPropertyChange(name, newValue);
        if ("location".equals(name)) {
            this.setLocationFromScout();
        }
    }

    protected void setLocationFromScout() {
        this.setLocationInternal(((IBrowserField)this.getScoutObject()).getLocation());
    }

    @Override
    protected void setValueFromScout() {
        RemoteFile remoteFile = (RemoteFile)((IBrowserField)this.getScoutObject()).getValue();
        String location = null;
        if (remoteFile != null && remoteFile.exists()) {
            if (this.m_browserExtension != null) {
                this.m_browserExtension.clearResourceCache();
                this.m_browserExtension.clearLocalHyperlinkCache();
            } else {
                this.attachBrowserExtension(this.getUiField());
            }
            try {
                if (remoteFile.getName().matches(".*\\.(zip|jar)")) {
                    location = this.registerResourcesInZip(this.m_browserExtension, remoteFile);
                } else {
                    String content = IOUtility.getContent((Reader)remoteFile.getDecompressedReader());
                    content = this.m_browserExtension.adaptHyperlinks(content);
                    location = this.m_browserExtension.addResource(remoteFile.getName(), new ByteArrayInputStream(content.getBytes("UTF-8")));
                }
                if (location != null) {
                    location = String.valueOf(location) + "?nocache=" + System.currentTimeMillis();
                }
            }
            catch (Throwable t) {
                LOG.error("preparing html content for " + remoteFile, t);
            }
        }
        this.setLocationInternal(location);
    }

    private String registerResourcesInZip(BrowserExtension browserExtension, RemoteFile zipFile) throws ProcessingException, IOException, UnsupportedEncodingException, FileNotFoundException {
        String location = null;
        File tempDir = IOUtility.createTempDirectory((String)"browser");
        try {
            zipFile.writeZipContentToDirectory(tempDir);
            String simpleName = zipFile.getName().replaceAll("\\.(zip|jar)", ".htm");
            int prefixLen = tempDir.getAbsolutePath().length() + 1;
            File[] fileArray = IOUtility.listFilesInSubtree((File)tempDir, null);
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File f = fileArray[n2];
                if (f.isFile()) {
                    String content;
                    String path = f.getAbsolutePath().substring(prefixLen);
                    if (path.toLowerCase().matches(".*\\.(htm|html)")) {
                        content = IOUtility.getContent((Reader)new InputStreamReader((InputStream)new FileInputStream(f), "UTF-8"));
                        content = browserExtension.adaptHyperlinks(content);
                        if (location == null && path.startsWith(simpleName)) {
                            location = browserExtension.addResource(simpleName, new ByteArrayInputStream(content.getBytes("UTF-8")));
                        } else {
                            browserExtension.addResource(path, new ByteArrayInputStream(content.getBytes("UTF-8")));
                        }
                    } else if (path.toLowerCase().matches(".*\\.(svg)")) {
                        content = IOUtility.getContent((Reader)new InputStreamReader(new FileInputStream(f)));
                        content = browserExtension.adaptHyperlinks(content);
                        browserExtension.addResource(path, new ByteArrayInputStream(content.getBytes("UTF-8")));
                    } else {
                        browserExtension.addResource(path, new FileInputStream(f));
                    }
                }
                ++n2;
            }
        }
        finally {
            if (tempDir != null) {
                IOUtility.deleteDirectory((File)tempDir);
            }
        }
        return location;
    }

    protected void setLocationInternal(String location) {
        if (StringUtility.hasText((CharSequence)location)) {
            this.getUiField().setUrl(location);
        } else {
            this.getUiField().setText("");
        }
    }

    @Override
    protected void setEnabledFromScout(boolean b) {
    }

    protected boolean fireBeforeLocationChangedFromUi(final String location) {
        final AtomicReference accept = new AtomicReference();
        Runnable t = new Runnable(){

            @Override
            public void run() {
                accept.set(((IBrowserField)RwtScoutBrowserField.this.getScoutObject()).getUIFacade().fireBeforeLocationChangedFromUI(location));
            }
        };
        JobEx job = this.getUiEnvironment().invokeScoutLater(t, 0L);
        try {
            job.join(10000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return accept.get() != null ? (Boolean)accept.get() : false;
    }

    protected void fireAfterLocationChangedFromUi(final String location) {
        Runnable t = new Runnable(){

            @Override
            public void run() {
                ((IBrowserField)RwtScoutBrowserField.this.getScoutObject()).getUIFacade().fireAfterLocationChangedFromUI(location);
            }
        };
        this.getUiEnvironment().invokeScoutLater(t, 0L);
    }
}

