/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.action;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.scout.rt.client.ui.action.IAction;
import org.eclipse.scout.rt.client.ui.action.tree.IActionNode;

public class ActionFinder {
    public <T extends IAction> T findAction(List<? extends IAction> actionTree, Class<T> searchType) {
        List<T> filteredActions = this.findActions(actionTree, searchType, true, true);
        if (filteredActions.size() > 0) {
            return (T)((IAction)filteredActions.get(0));
        }
        return null;
    }

    public <T extends IAction> List<T> findActions(List<? extends IAction> actionTree, Class<T> searchType, boolean recursive) {
        return this.findActions(actionTree, searchType, recursive, false);
    }

    private <T extends IAction> List<T> findActions(List<? extends IAction> actionTree, Class<T> searchType, boolean recursive, boolean oneMatchSearch) {
        ArrayList<IAction> list = new ArrayList<IAction>();
        for (IAction iAction : actionTree) {
            if (searchType.isAssignableFrom(iAction.getClass())) {
                list.add(iAction);
                if (oneMatchSearch) {
                    return list;
                }
            }
            if (!recursive || !(iAction instanceof IActionNode)) continue;
            List childActions = ((IActionNode)iAction).getChildActions();
            List<T> filteredChildActions = this.findActions(childActions, searchType, true, oneMatchSearch);
            list.addAll(filteredChildActions);
        }
        return list;
    }
}

