/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.server.commons.cache;

import java.io.IOException;
import java.util.concurrent.atomic.AtomicLong;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.commons.exception.ProcessingException;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.commons.serialization.IObjectSerializer;
import org.eclipse.scout.commons.serialization.SerializationUtility;
import org.eclipse.scout.rt.server.commons.cache.IHttpSessionCacheService;
import org.eclipse.scout.service.AbstractService;

public abstract class AbstractHttpSessionCacheService
extends AbstractService
implements IHttpSessionCacheService {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(AbstractHttpSessionCacheService.class);
    private final IObjectSerializer m_objs;
    private AtomicLong m_defaultExpirationTime = new AtomicLong(3600000L);

    protected AbstractHttpSessionCacheService() {
        this.m_objs = SerializationUtility.createObjectSerializer();
    }

    public void setExpiration(Long expiration) {
        this.m_defaultExpirationTime.set(expiration);
    }

    @Override
    public Long getExpiration() {
        return this.m_defaultExpirationTime.get();
    }

    @Override
    public void put(String key, Object value, HttpServletRequest req, HttpServletResponse res) {
        this.put(key, value, req, res, this.getExpiration());
    }

    @Override
    public Object getAndTouch(String key, HttpServletRequest req, HttpServletResponse res) {
        return this.getAndTouch(key, req, res, this.getExpiration());
    }

    @Override
    public void touch(String key, HttpServletRequest req, HttpServletResponse res) {
        this.touch(key, req, res, this.getExpiration());
    }

    @Override
    public Object getAndTouch(String key, HttpServletRequest req, HttpServletResponse res, Long expiration) {
        Object v = this.get(key, req, res);
        this.touch(key, req, res, expiration);
        return v;
    }

    protected String serializedString(Object e) throws ProcessingException {
        try {
            byte[] bytes = this.m_objs.serialize(e);
            return StringUtility.bytesToHex((byte[])bytes);
        }
        catch (IOException ex) {
            throw new ProcessingException("Error during Serialization ", (Throwable)ex);
        }
    }

    protected Object deserialize(String s) {
        if (s == null) {
            return null;
        }
        try {
            byte[] bytes = StringUtility.hexToBytes((String)s);
            if (bytes != null) {
                return this.m_objs.deserialize(bytes, Object.class);
            }
        }
        catch (ClassNotFoundException e) {
            LOG.error("ClassNotFoundException error during deserializization ", (Throwable)e);
        }
        catch (IOException e) {
            LOG.error("Error during deserializization ", (Throwable)e);
        }
        return null;
    }
}

