/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.server.services.common.jdbc.style;

import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.server.ThreadContext;
import org.eclipse.scout.rt.server.services.common.jdbc.SqlBind;
import org.eclipse.scout.rt.server.services.common.jdbc.style.AbstractSqlStyle;
import org.eclipse.scout.rt.server.transaction.ITransaction;
import org.eclipse.scout.rt.server.transaction.ITransactionMember;

public class OracleSqlStyle
extends AbstractSqlStyle {
    private static final long serialVersionUID = 1L;
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(OracleSqlStyle.class);

    @Override
    public String getConcatOp() {
        return "||";
    }

    @Override
    public String getLikeWildcard() {
        return "%";
    }

    @Override
    protected int getMaxListSize() {
        return 1000;
    }

    @Override
    public boolean isLargeString(String s) {
        return s.length() > 4000;
    }

    @Override
    public boolean isBlobEnabled() {
        return true;
    }

    @Override
    public boolean isClobEnabled() {
        return true;
    }

    @Override
    public void testConnection(Connection conn) throws SQLException {
        Statement testStatement = null;
        try {
            testStatement = conn.createStatement();
            testStatement.execute("SELECT 1 FROM DUAL");
        }
        finally {
            if (testStatement != null) {
                try {
                    testStatement.close();
                }
                catch (Throwable throwable) {}
            }
        }
    }

    @Override
    public void writeBind(PreparedStatement ps, int jdbcBindIndex, SqlBind bind) throws SQLException {
        switch (bind.getSqlType()) {
            case 2005: {
                Clob clob;
                if (bind.getValue() instanceof Clob) {
                    super.writeBind(ps, jdbcBindIndex, bind);
                    break;
                }
                String s = (String)bind.getValue();
                try {
                    Class<?> clobClass = Class.forName("oracle.sql.CLOB", true, ps.getClass().getClassLoader());
                    clob = (Clob)clobClass.getMethod("createTemporary", Connection.class, Boolean.TYPE, Integer.TYPE).invoke(null, ps.getConnection(), false, clobClass.getField("DURATION_SESSION").get(null));
                    this.registerClob(clob);
                }
                catch (Throwable t) {
                    SQLException ex = new SQLException("bind clob on jdbcIndex " + jdbcBindIndex);
                    ex.initCause(t);
                    throw ex;
                }
                try {
                    clob.getClass().getMethod("putString", Long.TYPE, String.class).invoke((Object)clob, 1, s);
                }
                catch (Throwable t) {
                    clob.setString(1L, s);
                }
                ps.setClob(jdbcBindIndex, clob);
                break;
            }
            case 2004: {
                Blob blob;
                if (bind.getValue() instanceof Blob) {
                    super.writeBind(ps, jdbcBindIndex, bind);
                    break;
                }
                byte[] data = (byte[])bind.getValue();
                try {
                    Class<?> blobClass = Class.forName("oracle.sql.BLOB", true, ps.getClass().getClassLoader());
                    blob = (Blob)blobClass.getMethod("createTemporary", Connection.class, Boolean.TYPE, Integer.TYPE).invoke(null, ps.getConnection(), false, blobClass.getField("DURATION_SESSION").get(null));
                    this.registerBlob(blob);
                }
                catch (Throwable t) {
                    SQLException ex = new SQLException("bind blob on jdbcIndex " + jdbcBindIndex);
                    ex.initCause(t);
                    throw ex;
                }
                try {
                    blob.getClass().getMethod("putBytes", Long.TYPE, byte[].class).invoke((Object)blob, 1, data);
                }
                catch (Throwable t) {
                    blob.setBytes(1L, data);
                }
                ps.setBlob(jdbcBindIndex, blob);
                break;
            }
            default: {
                super.writeBind(ps, jdbcBindIndex, bind);
            }
        }
    }

    protected void registerBlob(Blob blob) {
        if (blob == null) {
            return;
        }
        OracleLobTransactionMember txnMember = this.getOrCreateLobTransactionMember(true);
        if (txnMember != null) {
            txnMember.registerBlob(blob);
        }
    }

    protected void registerClob(Clob clob) {
        if (clob == null) {
            return;
        }
        OracleLobTransactionMember txnMember = this.getOrCreateLobTransactionMember(true);
        if (txnMember != null) {
            txnMember.registerClob(clob);
        }
    }

    private OracleLobTransactionMember getOrCreateLobTransactionMember(boolean autoCreate) {
        ITransaction reg = ThreadContext.getTransaction();
        if (reg == null) {
            LOG.warn("no ITransaction available, use ServerJob to run truncactions");
            return null;
        }
        OracleLobTransactionMember member = (OracleLobTransactionMember)reg.getMember(OracleLobTransactionMember.TRANSACTION_MEMBER_ID);
        if (member == null && autoCreate) {
            try {
                member = new OracleLobTransactionMember();
                reg.registerMember(member);
            }
            catch (Throwable t) {
                LOG.warn("Unexpected error while registering transaction member", t);
                return null;
            }
        }
        return member;
    }

    @Override
    public void commit() {
        OracleLobTransactionMember member = this.getOrCreateLobTransactionMember(false);
        if (member != null) {
            member.release();
        }
    }

    @Override
    public void rollback() {
        OracleLobTransactionMember member = this.getOrCreateLobTransactionMember(false);
        if (member != null) {
            member.release();
        }
    }

    private static class OracleLobTransactionMember
    implements ITransactionMember {
        private static final IScoutLogger LOG = ScoutLogManager.getLogger(OracleLobTransactionMember.class);
        public static final String TRANSACTION_MEMBER_ID = OracleLobTransactionMember.class.getName();
        private Set<Blob> m_temporaryBlobs;
        private Set<Clob> m_temporaryClobs;

        private OracleLobTransactionMember() {
        }

        public void registerBlob(Blob blob) {
            if (!"oracle.sql.BLOB".equals(blob.getClass().getName())) {
                return;
            }
            if (this.m_temporaryBlobs == null) {
                this.m_temporaryBlobs = new HashSet<Blob>();
            }
            this.m_temporaryBlobs.add(blob);
        }

        public void registerClob(Clob clob) {
            if (!"oracle.sql.CLOB".equals(clob.getClass().getName())) {
                return;
            }
            if (this.m_temporaryClobs == null) {
                this.m_temporaryClobs = new HashSet<Clob>();
            }
            this.m_temporaryClobs.add(clob);
        }

        private void releaseLobs(Set<?> lobs) {
            if (lobs == null || lobs.isEmpty()) {
                return;
            }
            for (Object lob : lobs) {
                try {
                    lob.getClass().getMethod("freeTemporary", new Class[0]).invoke(lob, new Object[0]);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            lobs.clear();
        }

        @Override
        public String getMemberId() {
            return TRANSACTION_MEMBER_ID;
        }

        @Override
        public boolean needsCommit() {
            return false;
        }

        @Override
        public boolean commitPhase1() {
            return true;
        }

        @Override
        public void commitPhase2() {
        }

        @Override
        public void rollback() {
        }

        @Override
        public void release() {
            this.releaseLobs(this.m_temporaryBlobs);
            this.releaseLobs(this.m_temporaryClobs);
        }

        @Override
        public void cancel() {
        }
    }
}

