/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.testing.server;

import javax.security.auth.Subject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.scout.commons.exception.ProcessingException;
import org.eclipse.scout.rt.server.IServerJobFactory;
import org.eclipse.scout.rt.server.IServerSession;
import org.eclipse.scout.rt.server.ITransactionRunnable;
import org.eclipse.scout.rt.server.services.common.session.ServerSessionRegistryService;
import org.eclipse.scout.rt.shared.ui.UserAgent;
import org.eclipse.scout.rt.testing.server.ITestServerSessionProvider;

public class DefaultTestServerSessionProvider
extends ServerSessionRegistryService
implements ITestServerSessionProvider {
    @Override
    public <T extends IServerSession> T createServerSession(Class<T> clazz, Subject subject) throws ProcessingException {
        IServerSession serverSession = this.createSessionInstance(clazz);
        serverSession.setUserAgent(UserAgent.createDefault());
        IServerJobFactory jobFactory = this.getBackendService().createJobFactory(serverSession, subject);
        this.runBeforeLoadJob(subject, serverSession, jobFactory);
        this.runLoadSessionJob(serverSession, jobFactory);
        this.runAfterLoadLob(subject, serverSession, jobFactory);
        return (T)serverSession;
    }

    private void runBeforeLoadJob(final Subject subject, final IServerSession serverSession, IServerJobFactory jobFactory) throws ProcessingException {
        jobFactory.runNow("before creating " + serverSession.getClass().getSimpleName(), new ITransactionRunnable(){

            public IStatus run(IProgressMonitor monitor) throws ProcessingException {
                DefaultTestServerSessionProvider.this.beforeStartSession(serverSession, subject);
                return Status.OK_STATUS;
            }
        });
    }

    private void runAfterLoadLob(final Subject subject, final IServerSession serverSession, IServerJobFactory jobFactory) throws ProcessingException {
        jobFactory.runNow("after creating " + serverSession.getClass().getSimpleName(), new ITransactionRunnable(){

            public IStatus run(IProgressMonitor monitor) throws ProcessingException {
                DefaultTestServerSessionProvider.this.afterStartSession(serverSession, subject);
                return Status.OK_STATUS;
            }
        });
    }

    @Override
    public Subject login(String runAs) {
        return this.getBackendService().createSubject(runAs);
    }

    protected void beforeStartSession(IServerSession serverSession, Subject subject) {
    }

    protected void afterStartSession(IServerSession serverSession, Subject subject) {
    }
}

