/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.ext.awt.image.codec.jpeg;

import com.sun.image.codec.jpeg.JPEGCodec;
import com.sun.image.codec.jpeg.JPEGEncodeParam;
import com.sun.image.codec.jpeg.JPEGImageEncoder;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.batik.ext.awt.image.GraphicsUtil;
import org.apache.batik.ext.awt.image.spi.ImageWriter;
import org.apache.batik.ext.awt.image.spi.ImageWriterParams;

public class JPEGImageWriter
implements ImageWriter {
    public void writeImage(RenderedImage image, OutputStream out) throws IOException {
        this.writeImage(image, out, null);
    }

    public void writeImage(RenderedImage image, OutputStream out, ImageWriterParams params) throws IOException {
        BufferedImage bi = image instanceof BufferedImage ? (BufferedImage)image : GraphicsUtil.makeLinearBufferedImage(image.getWidth(), image.getHeight(), false);
        JPEGImageEncoder encoder = JPEGCodec.createJPEGEncoder((OutputStream)out);
        if (params != null) {
            JPEGEncodeParam param = encoder.getDefaultJPEGEncodeParam(bi);
            if (params.getJPEGQuality() != null) {
                param.setQuality(params.getJPEGQuality().floatValue(), params.getJPEGForceBaseline().booleanValue());
            }
            encoder.encode(bi, param);
        } else {
            encoder.encode(bi);
        }
    }

    public String getMIMEType() {
        return "image/jpeg";
    }
}

