/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.commons;

import java.util.Map;
import java.util.Stack;
import java.util.TreeMap;
import java.util.TreeSet;
import org.eclipse.scout.commons.CompositeObject;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;

public final class TuningUtility {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(TuningUtility.class);
    private static Stack<Long> timerStack = new Stack();
    private static Object analysisMapLock = new Object();
    private static TreeMap<String, TreeSet<CompositeObject>> analysisMap = new TreeMap();

    private TuningUtility() {
    }

    public static void startTimer() {
        timerStack.push(System.nanoTime());
    }

    public static long stopTimer(String name) {
        return TuningUtility.stopTimer(name, true, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long stopTimer(String name, boolean print, boolean addToBatch) {
        long dtNanos = !timerStack.isEmpty() ? System.nanoTime() - timerStack.pop() : -1L;
        if (print && dtNanos != -1L) {
            TuningUtility.printSingle(name, dtNanos);
        }
        if (addToBatch) {
            Object object = analysisMapLock;
            synchronized (object) {
                TreeSet<CompositeObject> set = analysisMap.get(name);
                if (set == null) {
                    set = new TreeSet();
                    analysisMap.put(name, set);
                }
                set.add(new CompositeObject(dtNanos, set.size()));
            }
        }
        return dtNanos;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void finishAll(boolean clearTimers) {
        if (!timerStack.isEmpty()) {
            System.out.println("#TUNING: there are " + timerStack.size() + " non-finished timers (start/stop mismatch)");
        }
        while (clearTimers && !timerStack.isEmpty()) {
            timerStack.pop();
        }
        Object object = analysisMapLock;
        synchronized (object) {
            for (Map.Entry<String, TreeSet<CompositeObject>> e : analysisMap.entrySet()) {
                String name = e.getKey();
                TreeSet<CompositeObject> set = e.getValue();
                long[] seriesSorted = new long[set.size()];
                int index = 0;
                for (CompositeObject o : set) {
                    seriesSorted[index] = (Long)o.getComponent(0);
                    ++index;
                }
                TuningUtility.printMulti(name, seriesSorted);
            }
            analysisMap.clear();
        }
    }

    public static void finishAll() {
        TuningUtility.finishAll(false);
    }

    private static String formatTime(long dtNanos) {
        String x = "" + dtNanos;
        while (x.length() < 7) {
            x = "0" + x;
        }
        return String.valueOf(x.substring(0, x.length() - 6)) + "." + x.substring(x.length() - 6);
    }

    private static void printSingle(String label, long dtNanos) {
        int level = timerStack.size();
        StringBuilder b = new StringBuilder();
        b.append("#TUNING: ");
        int i = 0;
        while (i < level) {
            b.append("  ");
            ++i;
        }
        b.append(label);
        b.append(" took ");
        b.append(TuningUtility.formatTime(dtNanos));
        b.append("ms");
        System.out.println(b);
    }

    private static void printMulti(String name, long[] seriesSorted) {
        StringBuilder b = new StringBuilder();
        b.append("#TUNING: ");
        b.append(name);
        b.append("[" + seriesSorted.length + "]");
        if (seriesSorted.length > 0) {
            double sum = 0.0;
            long[] lArray = seriesSorted;
            int n = seriesSorted.length;
            int n2 = 0;
            while (n2 < n) {
                long n3 = lArray[n2];
                sum += (double)n3;
                ++n2;
            }
            b.append(" sum=" + TuningUtility.formatTime((long)sum));
            long avg = (long)(sum / (double)seriesSorted.length);
            b.append("ms");
            b.append(" min=");
            b.append(TuningUtility.formatTime(seriesSorted[0]));
            b.append("ms");
            b.append(" avg=");
            b.append(TuningUtility.formatTime(avg));
            b.append("ms");
            b.append(" median=");
            b.append(TuningUtility.formatTime(seriesSorted[seriesSorted.length / 2]));
            b.append("ms");
            b.append(" max=");
            b.append(TuningUtility.formatTime(seriesSorted[seriesSorted.length - 1]));
            b.append("ms");
            int start = Math.max(1, seriesSorted.length / 100);
            int end = Math.min(seriesSorted.length - 2, seriesSorted.length - 1 - seriesSorted.length / 100);
            if (start < end) {
                b.append("  [without " + start + " smallest and " + (seriesSorted.length - 1 - end) + " largest: ");
                sum = 0.0;
                int i = start;
                while (i <= end) {
                    sum += (double)seriesSorted[i];
                    ++i;
                }
                b.append(" sum=" + TuningUtility.formatTime((long)sum));
                avg = (long)(sum / (double)(end - start));
                b.append(" min=");
                b.append(TuningUtility.formatTime(seriesSorted[start]));
                b.append("ms");
                b.append(" avg=");
                b.append(TuningUtility.formatTime(avg));
                b.append("ms");
                b.append(" median=");
                b.append(TuningUtility.formatTime(seriesSorted[seriesSorted.length / 2]));
                b.append("ms");
                b.append(" max=");
                b.append(TuningUtility.formatTime(seriesSorted[end]));
                b.append("ms");
                b.append("]");
            }
        }
        System.out.println(b);
    }
}

