/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.commons;

import java.lang.reflect.Array;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Collection;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.scout.commons.TriState;
import org.eclipse.scout.commons.UTCDate;
import org.eclipse.scout.commons.VerboseUtility;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;

public final class TypeCastUtility {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(TypeCastUtility.class);
    private static TypeCastUtility instance = new TypeCastUtility();
    private static final int CHARACTER = 1;
    private static final int BYTE = 2;
    private static final int BOOLEAN = 3;
    private static final int SHORT = 4;
    private static final int INTEGER = 5;
    private static final int LONG = 6;
    private static final int FLOAT = 7;
    private static final int DOUBLE = 8;
    private static final int STRING = 9;
    private static final int OBJECT = 10;
    private static final int BIGINTEGER = 11;
    private static final int BIGDECIMAL = 12;
    private static final int DATE = 13;
    private static final int CALENDAR = 14;
    private static final int SQLDATE = 15;
    private static final int SQLTIME = 16;
    private static final int SQLTIMESTAMP = 17;
    private static final int TRISTATE = 18;
    private static final int UTCDATE = 19;
    private static final int VOID = 9999;
    private static final String ZULU_DATE_TO_STRING_FORMAT = "dd.MM.yyyy'T'HH:mm:ss.sss'Z'";
    private final Map<Class, Class> m_wrapperTypeMap = new HashMap<Class, Class>();
    private final Map<Class, Integer> m_typeMap = new HashMap<Class, Integer>();
    private final Map<Class, Integer> m_primitiveTypeMap = new HashMap<Class, Integer>();
    private final Map<GPCKey, Class<?>> m_genericsParameterClassCache = new ConcurrentHashMap();

    public static <T> T castValue(Object o, Class<T> castType) {
        return (T)instance.castValueImpl(o, castType);
    }

    private TypeCastUtility() {
        this.m_wrapperTypeMap.put(Character.TYPE, Character.class);
        this.m_wrapperTypeMap.put(Byte.TYPE, Byte.class);
        this.m_wrapperTypeMap.put(Boolean.TYPE, Boolean.class);
        this.m_wrapperTypeMap.put(Short.TYPE, Short.class);
        this.m_wrapperTypeMap.put(Integer.TYPE, Integer.class);
        this.m_wrapperTypeMap.put(Long.TYPE, Long.class);
        this.m_wrapperTypeMap.put(Float.TYPE, Float.class);
        this.m_wrapperTypeMap.put(Double.TYPE, Double.class);
        this.m_wrapperTypeMap.put(Void.TYPE, Void.class);
        this.m_typeMap.put(Character.class, 1);
        this.m_typeMap.put(Byte.class, 2);
        this.m_typeMap.put(Boolean.class, 3);
        this.m_typeMap.put(TriState.class, 18);
        this.m_typeMap.put(Short.class, 4);
        this.m_typeMap.put(Integer.class, 5);
        this.m_typeMap.put(Long.class, 6);
        this.m_typeMap.put(Float.class, 7);
        this.m_typeMap.put(Double.class, 8);
        this.m_typeMap.put(String.class, 9);
        this.m_typeMap.put(Object.class, 10);
        this.m_typeMap.put(BigInteger.class, 11);
        this.m_typeMap.put(BigDecimal.class, 12);
        this.m_typeMap.put(UTCDate.class, 19);
        this.m_typeMap.put(java.util.Date.class, 13);
        this.m_typeMap.put(Calendar.class, 14);
        this.m_typeMap.put(GregorianCalendar.class, 14);
        this.m_typeMap.put(Date.class, 15);
        this.m_typeMap.put(Time.class, 16);
        this.m_typeMap.put(Timestamp.class, 17);
        this.m_typeMap.put(Void.class, 9999);
        this.m_primitiveTypeMap.put(Boolean.TYPE, 3);
        this.m_primitiveTypeMap.put(Byte.TYPE, 2);
        this.m_primitiveTypeMap.put(Character.TYPE, 1);
        this.m_primitiveTypeMap.put(Short.TYPE, 4);
        this.m_primitiveTypeMap.put(Integer.TYPE, 5);
        this.m_primitiveTypeMap.put(Long.TYPE, 6);
        this.m_primitiveTypeMap.put(Float.TYPE, 7);
        this.m_primitiveTypeMap.put(Double.TYPE, 8);
    }

    private Object castValueImpl(Object o, Class castType) {
        Class toType = castType;
        if (o == null) {
            if (toType.isPrimitive()) {
                return this.getPrimitiveNull(toType);
            }
            return null;
        }
        if (toType.isPrimitive()) {
            toType = this.getWrappedType(toType);
        }
        if (toType.isInstance(o)) {
            return o;
        }
        Class<?> fromType = o.getClass();
        if (toType.isArray()) {
            return this.castArrayValueImpl(o, fromType, toType);
        }
        return this.castBasicValueImpl(o, fromType, toType);
    }

    private int getTypeId(Class type) {
        Integer id = this.m_typeMap.get(type);
        if (id == null) {
            return 0;
        }
        return id;
    }

    private int getPrimitiveTypeId(Class type) {
        Integer id = this.m_primitiveTypeMap.get(type);
        if (id == null) {
            return 0;
        }
        return id;
    }

    private Class getWrappedType(Class primitiveType) {
        Class wrappedType = this.m_wrapperTypeMap.get(primitiveType);
        return wrappedType;
    }

    private <T> T getPrimitiveNull(Class<T> primitiveType) {
        int fromId = this.getPrimitiveTypeId(primitiveType);
        if (fromId == 0) {
            throw new IllegalArgumentException(primitiveType + " no primitive type");
        }
        switch (fromId) {
            case 3: {
                return (T)Boolean.FALSE;
            }
            case 2: {
                return (T)Byte.valueOf((byte)0);
            }
            case 1: {
                return (T)Character.valueOf('\u0000');
            }
            case 4: {
                return (T)Short.valueOf((short)0);
            }
            case 5: {
                return (T)Integer.valueOf(0);
            }
            case 6: {
                return (T)Long.valueOf(0L);
            }
            case 7: {
                return (T)Float.valueOf(0.0f);
            }
            case 8: {
                return (T)Double.valueOf(0.0);
            }
        }
        throw new IllegalArgumentException(primitiveType + " no primitive type");
    }

    private IllegalArgumentException createException(Object o, Class fromType, Class toType, int code, String msg) {
        return new IllegalArgumentException("converting " + VerboseUtility.dumpObject(o) + " from " + VerboseUtility.dumpType(fromType) + " to " + VerboseUtility.dumpType(toType) + " failed with code " + code + " (" + msg + ")");
    }

    private Object castArrayValueImpl(Object o, Class fromType, Class toType) {
        if (!fromType.isArray()) {
            if (o instanceof Collection) {
                o = ((Collection)o).toArray();
            } else if (o instanceof Map) {
                o = ((Map)o).values().toArray();
            } else {
                throw this.createException(o, fromType, toType, 1, "object is not an array");
            }
        }
        Class<?> toCompType = toType.getComponentType();
        int dim = 0;
        Class<?> t = toType;
        while (t.isArray()) {
            ++dim;
            t = t.getComponentType();
        }
        int[] dims = new int[dim];
        dim = 0;
        Object od = o;
        t = toType;
        while (t.isArray()) {
            dims[dim] = Array.getLength(od);
            t = t.getComponentType();
            if (dims[dim] == 0) break;
            od = Array.get(od, 0);
            ++dim;
        }
        Object newArray = Array.newInstance(t, dims);
        int i = 0;
        int ni = dims[0];
        while (i < ni) {
            Object castedElement = this.castValueImpl(Array.get(o, i), toCompType);
            Array.set(newArray, i, castedElement);
            ++i;
        }
        return newArray;
    }

    private Object castBasicValueImpl(Object o, Class fromType, Class toType) {
        if (o == null) {
            return null;
        }
        int fromId = this.getTypeId(fromType);
        if (fromId == 0) {
            throw this.createException(o, fromType, toType, 2, "no from-mapping");
        }
        int toId = this.getTypeId(toType);
        if (toId == 0) {
            throw this.createException(o, fromType, toType, 3, "no to-mapping");
        }
        switch (fromId) {
            case 1: {
                switch (toId) {
                    case 1: {
                        return o;
                    }
                    case 2: {
                        return this.txCharToByte(((Character)o).charValue());
                    }
                    case 3: {
                        return this.txCharToBoolean(((Character)o).charValue());
                    }
                    case 18: {
                        return this.txCharToTriState(((Character)o).charValue());
                    }
                    case 4: {
                        return this.txCharToShort(((Character)o).charValue());
                    }
                    case 5: {
                        return this.txCharToInt(((Character)o).charValue());
                    }
                    case 6: {
                        return this.txCharToLong(((Character)o).charValue());
                    }
                    case 7: {
                        return Float.valueOf(this.txCharToFloat(((Character)o).charValue()));
                    }
                    case 8: {
                        return this.txCharToDouble(((Character)o).charValue());
                    }
                    case 9: {
                        return this.txCharToString(((Character)o).charValue());
                    }
                    case 10: {
                        return o;
                    }
                    case 11: {
                        return this.txCharToBigInteger(((Character)o).charValue());
                    }
                    case 12: {
                        return this.txCharToBigDecimal(((Character)o).charValue());
                    }
                }
                break;
            }
            case 2: {
                switch (toId) {
                    case 1: {
                        return Character.valueOf(this.txByteToChar((Byte)o));
                    }
                    case 2: {
                        return o;
                    }
                    case 3: {
                        return this.txByteToBoolean((Byte)o);
                    }
                    case 18: {
                        return this.txByteToTriState((Byte)o);
                    }
                    case 4: {
                        return this.txByteToShort((Byte)o);
                    }
                    case 5: {
                        return this.txByteToInt((Byte)o);
                    }
                    case 6: {
                        return this.txByteToLong((Byte)o);
                    }
                    case 7: {
                        return Float.valueOf(this.txByteToFloat((Byte)o));
                    }
                    case 8: {
                        return this.txByteToDouble((Byte)o);
                    }
                    case 9: {
                        return this.txByteToString((Byte)o);
                    }
                    case 10: {
                        return o;
                    }
                    case 11: {
                        return this.txByteToBigInteger((Byte)o);
                    }
                    case 12: {
                        return this.txByteToBigDecimal((Byte)o);
                    }
                }
                break;
            }
            case 3: {
                switch (toId) {
                    case 1: {
                        return Character.valueOf(this.txBooleanToChar((Boolean)o));
                    }
                    case 2: {
                        return this.txBooleanToByte((Boolean)o);
                    }
                    case 3: {
                        return o;
                    }
                    case 18: {
                        return this.txBooleanToTriState((Boolean)o);
                    }
                    case 4: {
                        return this.txBooleanToShort((Boolean)o);
                    }
                    case 5: {
                        return this.txBooleanToInt((Boolean)o);
                    }
                    case 6: {
                        return this.txBooleanToLong((Boolean)o);
                    }
                    case 7: {
                        return Float.valueOf(this.txBooleanToFloat((Boolean)o));
                    }
                    case 8: {
                        return this.txBooleanToDouble((Boolean)o);
                    }
                    case 9: {
                        return this.txBooleanToString((Boolean)o);
                    }
                    case 10: {
                        return o;
                    }
                    case 11: {
                        return this.txBooleanToBigInteger((Boolean)o);
                    }
                    case 12: {
                        return this.txBooleanToBigDecimal((Boolean)o);
                    }
                }
                break;
            }
            case 18: {
                switch (toId) {
                    case 1: {
                        return Character.valueOf(this.txTriStateToChar((TriState)((Object)o)));
                    }
                    case 2: {
                        return this.txTriStateToByte((TriState)((Object)o));
                    }
                    case 3: {
                        return this.txTriStateToBoolean((TriState)((Object)o));
                    }
                    case 18: {
                        return o;
                    }
                    case 4: {
                        return this.txTriStateToShort((TriState)((Object)o));
                    }
                    case 5: {
                        return this.txTriStateToInt((TriState)((Object)o));
                    }
                    case 6: {
                        return this.txTriStateToLong((TriState)((Object)o));
                    }
                    case 7: {
                        return Float.valueOf(this.txTriStateToFloat((TriState)((Object)o)));
                    }
                    case 8: {
                        return this.txTriStateToDouble((TriState)((Object)o));
                    }
                    case 9: {
                        return this.txTriStateToString((TriState)((Object)o));
                    }
                    case 10: {
                        return o;
                    }
                    case 11: {
                        return this.txTriStateToBigInteger((TriState)((Object)o));
                    }
                    case 12: {
                        return this.txTriStateToBigDecimal((TriState)((Object)o));
                    }
                }
                break;
            }
            case 4: {
                switch (toId) {
                    case 1: {
                        return Character.valueOf(this.txShortToChar((Short)o));
                    }
                    case 2: {
                        return this.txShortToByte((Short)o);
                    }
                    case 3: {
                        return this.txShortToBoolean((Short)o);
                    }
                    case 18: {
                        return this.txShortToTriState((Short)o);
                    }
                    case 4: {
                        return o;
                    }
                    case 5: {
                        return this.txShortToInt((Short)o);
                    }
                    case 6: {
                        return this.txShortToLong((Short)o);
                    }
                    case 7: {
                        return Float.valueOf(this.txShortToFloat((Short)o));
                    }
                    case 8: {
                        return this.txShortToDouble((Short)o);
                    }
                    case 9: {
                        return this.txShortToString((Short)o);
                    }
                    case 10: {
                        return o;
                    }
                    case 11: {
                        return this.txShortToBigInteger((Short)o);
                    }
                    case 12: {
                        return this.txShortToBigDecimal((Short)o);
                    }
                }
                break;
            }
            case 5: {
                switch (toId) {
                    case 1: {
                        return Character.valueOf(this.txIntToChar((Integer)o));
                    }
                    case 2: {
                        return this.txIntToByte((Integer)o);
                    }
                    case 3: {
                        return this.txIntToBoolean((Integer)o);
                    }
                    case 18: {
                        return this.txIntToTriState((Integer)o);
                    }
                    case 4: {
                        return this.txIntToShort((Integer)o);
                    }
                    case 5: {
                        return o;
                    }
                    case 6: {
                        return this.txIntToLong((Integer)o);
                    }
                    case 7: {
                        return Float.valueOf(this.txIntToFloat((Integer)o));
                    }
                    case 8: {
                        return this.txIntToDouble((Integer)o);
                    }
                    case 9: {
                        return this.txIntToString((Integer)o);
                    }
                    case 10: {
                        return o;
                    }
                    case 11: {
                        return this.txIntToBigInteger((Integer)o);
                    }
                    case 12: {
                        return this.txIntToBigDecimal((Integer)o);
                    }
                }
                break;
            }
            case 6: {
                switch (toId) {
                    case 1: {
                        return Character.valueOf(this.txLongToChar((Long)o));
                    }
                    case 2: {
                        return this.txLongToByte((Long)o);
                    }
                    case 3: {
                        return this.txLongToBoolean((Long)o);
                    }
                    case 18: {
                        return this.txLongToTriState((Long)o);
                    }
                    case 4: {
                        return this.txLongToShort((Long)o);
                    }
                    case 5: {
                        return this.txLongToInt((Long)o);
                    }
                    case 6: {
                        return o;
                    }
                    case 7: {
                        return Float.valueOf(this.txLongToFloat((Long)o));
                    }
                    case 8: {
                        return this.txLongToDouble((Long)o);
                    }
                    case 9: {
                        return this.txLongToString((Long)o);
                    }
                    case 10: {
                        return o;
                    }
                    case 11: {
                        return this.txLongToBigInteger((Long)o);
                    }
                    case 12: {
                        return this.txLongToBigDecimal((Long)o);
                    }
                }
                break;
            }
            case 7: {
                switch (toId) {
                    case 1: {
                        return Character.valueOf(this.txFloatToChar(((Float)o).floatValue()));
                    }
                    case 2: {
                        return this.txFloatToByte(((Float)o).floatValue());
                    }
                    case 3: {
                        return this.txFloatToBoolean(((Float)o).floatValue());
                    }
                    case 18: {
                        return this.txFloatToTriState(((Float)o).floatValue());
                    }
                    case 4: {
                        return this.txFloatToShort(((Float)o).floatValue());
                    }
                    case 5: {
                        return this.txFloatToInt(((Float)o).floatValue());
                    }
                    case 6: {
                        return this.txFloatToLong(((Float)o).floatValue());
                    }
                    case 7: {
                        return o;
                    }
                    case 8: {
                        return this.txFloatToDouble(((Float)o).floatValue());
                    }
                    case 9: {
                        return this.txFloatToString(((Float)o).floatValue());
                    }
                    case 10: {
                        return o;
                    }
                    case 11: {
                        return this.txFloatToBigInteger(((Float)o).floatValue());
                    }
                    case 12: {
                        return this.txFloatToBigDecimal(((Float)o).floatValue());
                    }
                }
                break;
            }
            case 8: {
                switch (toId) {
                    case 1: {
                        return Character.valueOf(this.txDoubleToChar((Double)o));
                    }
                    case 2: {
                        return this.txDoubleToByte((Double)o);
                    }
                    case 3: {
                        return this.txDoubleToBoolean((Double)o);
                    }
                    case 18: {
                        return this.txDoubleToTriState((Double)o);
                    }
                    case 4: {
                        return this.txDoubleToShort((Double)o);
                    }
                    case 5: {
                        return this.txDoubleToInt((Double)o);
                    }
                    case 6: {
                        return this.txDoubleToLong((Double)o);
                    }
                    case 7: {
                        return Float.valueOf(this.txDoubleToFloat((Double)o));
                    }
                    case 8: {
                        return o;
                    }
                    case 9: {
                        return this.txDoubleToString((Double)o);
                    }
                    case 10: {
                        return o;
                    }
                    case 11: {
                        return this.txDoubleToBigInteger((Double)o);
                    }
                    case 12: {
                        return this.txDoubleToBigDecimal((Double)o);
                    }
                }
                break;
            }
            case 9: {
                if (((String)o).length() == 0) {
                    return null;
                }
                switch (toId) {
                    case 1: {
                        return Character.valueOf(this.txStringToChar((String)o));
                    }
                    case 2: {
                        return this.txStringToByte((String)o);
                    }
                    case 3: {
                        return this.txStringToBoolean((String)o);
                    }
                    case 18: {
                        return this.txStringToTriState((String)o);
                    }
                    case 4: {
                        return this.txStringToShort((String)o);
                    }
                    case 5: {
                        return this.txStringToInt((String)o);
                    }
                    case 6: {
                        return this.txStringToLong((String)o);
                    }
                    case 7: {
                        return Float.valueOf(this.txStringToFloat((String)o));
                    }
                    case 8: {
                        return this.txStringToDouble((String)o);
                    }
                    case 9: {
                        return o;
                    }
                    case 10: {
                        return o;
                    }
                    case 13: {
                        return this.txStringToDate((String)o);
                    }
                    case 19: {
                        return this.txStringToUTCDate((String)o);
                    }
                    case 14: {
                        return this.txStringToCalendar((String)o);
                    }
                    case 15: {
                        return this.txStringToSqlDate((String)o);
                    }
                    case 16: {
                        return this.txStringToSqlTime((String)o);
                    }
                    case 17: {
                        return this.txStringToSqlTimestamp((String)o);
                    }
                    case 11: {
                        return this.txStringToBigInteger((String)o);
                    }
                    case 12: {
                        return this.txStringToBigDecimal((String)o);
                    }
                }
                break;
            }
            case 10: {
                switch (toId) {
                    case 9: {
                        return this.txObjectToString(o);
                    }
                    case 10: {
                        return o;
                    }
                }
                break;
            }
            case 11: {
                switch (toId) {
                    case 1: {
                        return Character.valueOf(this.txBigIntegerToChar((BigInteger)o));
                    }
                    case 2: {
                        return this.txBigIntegerToByte((BigInteger)o);
                    }
                    case 3: {
                        return this.txBigIntegerToBoolean((BigInteger)o);
                    }
                    case 18: {
                        return this.txBigIntegerToTriState((BigInteger)o);
                    }
                    case 4: {
                        return this.txBigIntegerToShort((BigInteger)o);
                    }
                    case 5: {
                        return this.txBigIntegerToInt((BigInteger)o);
                    }
                    case 6: {
                        return this.txBigIntegerToLong((BigInteger)o);
                    }
                    case 7: {
                        return Float.valueOf(this.txBigIntegerToFloat((BigInteger)o));
                    }
                    case 8: {
                        return this.txBigIntegerToDouble((BigInteger)o);
                    }
                    case 9: {
                        return this.txBigIntegerToString((BigInteger)o);
                    }
                    case 10: {
                        return o;
                    }
                    case 11: {
                        return o;
                    }
                    case 12: {
                        return this.txBigIntegerToBigDecimal((BigInteger)o);
                    }
                }
                break;
            }
            case 12: {
                switch (toId) {
                    case 1: {
                        return Character.valueOf(this.txBigDecimalToChar((BigDecimal)o));
                    }
                    case 2: {
                        return this.txBigDecimalToByte((BigDecimal)o);
                    }
                    case 3: {
                        return this.txBigDecimalToBoolean((BigDecimal)o);
                    }
                    case 18: {
                        return this.txBigDecimalToTriState((BigDecimal)o);
                    }
                    case 4: {
                        return this.txBigDecimalToShort((BigDecimal)o);
                    }
                    case 5: {
                        return this.txBigDecimalToInt((BigDecimal)o);
                    }
                    case 6: {
                        return this.txBigDecimalToLong((BigDecimal)o);
                    }
                    case 7: {
                        return Float.valueOf(this.txBigDecimalToFloat((BigDecimal)o));
                    }
                    case 8: {
                        return this.txBigDecimalToDouble((BigDecimal)o);
                    }
                    case 9: {
                        return this.txBigDecimalToString((BigDecimal)o);
                    }
                    case 10: {
                        return o;
                    }
                    case 12: {
                        return o;
                    }
                    case 11: {
                        return this.txBigDecimalToBigInteger((BigDecimal)o);
                    }
                }
                break;
            }
            case 13: {
                switch (toId) {
                    case 13: {
                        return o;
                    }
                    case 19: {
                        return this.txDateToUTCDate((java.util.Date)o);
                    }
                    case 14: {
                        return this.txDateToCalendar((java.util.Date)o);
                    }
                    case 15: {
                        return this.txDateToSqlDate((java.util.Date)o);
                    }
                    case 16: {
                        return this.txDateToSqlTime((java.util.Date)o);
                    }
                    case 17: {
                        return this.txDateToSqlTimestamp((java.util.Date)o);
                    }
                    case 9: {
                        return this.txDateToString((java.util.Date)o);
                    }
                    case 10: {
                        return o;
                    }
                }
                break;
            }
            case 19: {
                switch (toId) {
                    case 19: {
                        return o;
                    }
                    case 13: {
                        return this.txUTCDateToDate((UTCDate)o);
                    }
                    case 14: {
                        return this.txUTCDateToCalendar((UTCDate)o);
                    }
                    case 15: {
                        return this.txUTCDateToSqlDate((UTCDate)o);
                    }
                    case 16: {
                        return this.txUTCDateToSqlTime((UTCDate)o);
                    }
                    case 17: {
                        return this.txUTCDateToSqlTimestamp((UTCDate)o);
                    }
                    case 9: {
                        return this.txUTCDateToString((UTCDate)o);
                    }
                    case 10: {
                        return o;
                    }
                }
                break;
            }
            case 14: {
                switch (toId) {
                    case 13: {
                        return this.txCalendarToDate((Calendar)o);
                    }
                    case 19: {
                        return this.txCalendarToUTCDate((Calendar)o);
                    }
                    case 14: {
                        return o;
                    }
                    case 15: {
                        return this.txCalendarToSqlDate((Calendar)o);
                    }
                    case 16: {
                        return this.txCalendarToSqlTime((Calendar)o);
                    }
                    case 17: {
                        return this.txCalendarToSqlTimestamp((Calendar)o);
                    }
                    case 9: {
                        return this.txCalendarToString((Calendar)o);
                    }
                    case 10: {
                        return o;
                    }
                }
                break;
            }
            case 15: {
                switch (toId) {
                    case 13: {
                        return o;
                    }
                    case 19: {
                        return this.txSqlDateToUTCDate((Date)o);
                    }
                    case 14: {
                        return this.txSqlDateToCalendar((Date)o);
                    }
                    case 15: {
                        return o;
                    }
                    case 16: {
                        return this.txSqlDateToSqlTime((Date)o);
                    }
                    case 17: {
                        return this.txSqlDateToSqlTimestamp((Date)o);
                    }
                    case 9: {
                        return this.txSqlDateToString((Date)o);
                    }
                    case 10: {
                        return o;
                    }
                }
                break;
            }
            case 16: {
                switch (toId) {
                    case 13: {
                        return o;
                    }
                    case 19: {
                        return this.txSqlTimeToUTCDate((Time)o);
                    }
                    case 14: {
                        return this.txSqlTimeToCalendar((Time)o);
                    }
                    case 15: {
                        return this.txSqlTimeToSqlDate((Time)o);
                    }
                    case 16: {
                        return o;
                    }
                    case 17: {
                        return this.txSqlTimeToSqlTimestamp((Time)o);
                    }
                    case 9: {
                        return this.txSqlTimeToString((Time)o);
                    }
                    case 10: {
                        return o;
                    }
                }
                break;
            }
            case 17: {
                switch (toId) {
                    case 13: {
                        return o;
                    }
                    case 19: {
                        return this.txSqlTimestampToUTCDate((Timestamp)o);
                    }
                    case 14: {
                        return this.txSqlTimestampToCalendar((Timestamp)o);
                    }
                    case 15: {
                        return this.txSqlTimestampToSqlDate((Timestamp)o);
                    }
                    case 16: {
                        return this.txSqlTimestampToSqlTime((Timestamp)o);
                    }
                    case 17: {
                        return o;
                    }
                    case 9: {
                        return this.txSqlTimestampToString((Timestamp)o);
                    }
                    case 10: {
                        return o;
                    }
                }
            }
        }
        throw this.createException(o, fromType, toType, 4, "not implementated");
    }

    private byte txBooleanToByte(boolean o) {
        return (byte)(o ? 1 : 0);
    }

    private char txBooleanToChar(boolean o) {
        return o ? (char)'X' : ' ';
    }

    private double txBooleanToDouble(boolean o) {
        return o ? 1 : 0;
    }

    private float txBooleanToFloat(boolean o) {
        return o ? 1 : 0;
    }

    private int txBooleanToInt(boolean o) {
        return o ? 1 : 0;
    }

    private long txBooleanToLong(boolean o) {
        return o ? 1 : 0;
    }

    private short txBooleanToShort(boolean o) {
        return (short)(o ? 1 : 0);
    }

    private String txBooleanToString(boolean o) {
        return String.valueOf(o);
    }

    private boolean txByteToBoolean(byte o) {
        return o == 1;
    }

    private char txByteToChar(byte o) {
        return (char)o;
    }

    private double txByteToDouble(byte o) {
        return o;
    }

    private float txByteToFloat(byte o) {
        return o;
    }

    private int txByteToInt(byte o) {
        return o;
    }

    private long txByteToLong(byte o) {
        return o;
    }

    private short txByteToShort(byte o) {
        return o;
    }

    private String txByteToString(byte o) {
        return String.valueOf((char)o);
    }

    private boolean txCharToBoolean(char o) {
        return o == 'X' || o == 'x' || o == '1';
    }

    private byte txCharToByte(char o) {
        return (byte)o;
    }

    private double txCharToDouble(char o) {
        return Double.parseDouble(String.valueOf(o));
    }

    private float txCharToFloat(char o) {
        return Float.parseFloat(String.valueOf(o));
    }

    private int txCharToInt(char o) {
        return Integer.parseInt(String.valueOf(o));
    }

    private long txCharToLong(char o) {
        return Long.parseLong(String.valueOf(o));
    }

    private short txCharToShort(char o) {
        return Short.parseShort(String.valueOf(o));
    }

    private String txCharToString(char o) {
        return String.valueOf(o);
    }

    private boolean txDoubleToBoolean(double o) {
        return o == 1.0;
    }

    private byte txDoubleToByte(double o) {
        return (byte)o;
    }

    private char txDoubleToChar(double o) {
        return (char)o;
    }

    private float txDoubleToFloat(double o) {
        return Float.parseFloat(String.valueOf(o));
    }

    private int txDoubleToInt(double o) {
        return (int)o;
    }

    private long txDoubleToLong(double o) {
        return (long)o;
    }

    private short txDoubleToShort(double o) {
        return (short)o;
    }

    private String txDoubleToString(double o) {
        return String.valueOf(o);
    }

    private boolean txFloatToBoolean(float o) {
        return o == 1.0f;
    }

    private byte txFloatToByte(float o) {
        return (byte)o;
    }

    private char txFloatToChar(float o) {
        return (char)o;
    }

    private double txFloatToDouble(float o) {
        return Double.parseDouble(String.valueOf(o));
    }

    private int txFloatToInt(float o) {
        return (int)o;
    }

    private long txFloatToLong(float o) {
        return (long)o;
    }

    private short txFloatToShort(float o) {
        return (short)o;
    }

    private String txFloatToString(float o) {
        return String.valueOf(o);
    }

    private boolean txIntToBoolean(int o) {
        return o == 1;
    }

    private byte txIntToByte(int o) {
        return (byte)o;
    }

    private char txIntToChar(int o) {
        return (char)o;
    }

    private double txIntToDouble(int o) {
        return o;
    }

    private float txIntToFloat(int o) {
        return o;
    }

    private long txIntToLong(int o) {
        return o;
    }

    private short txIntToShort(int o) {
        return (short)o;
    }

    private String txIntToString(int o) {
        return String.valueOf(o);
    }

    private boolean txLongToBoolean(long o) {
        return o == 1L;
    }

    private byte txLongToByte(long o) {
        return (byte)o;
    }

    private char txLongToChar(long o) {
        return (char)o;
    }

    private double txLongToDouble(long o) {
        return o;
    }

    private float txLongToFloat(long o) {
        return o;
    }

    private int txLongToInt(long o) {
        return (int)o;
    }

    private short txLongToShort(long o) {
        return (short)o;
    }

    private String txLongToString(long o) {
        return String.valueOf(o);
    }

    private String txObjectToString(Object o) {
        return o.toString();
    }

    private boolean txShortToBoolean(short o) {
        return o == 1;
    }

    private byte txShortToByte(short o) {
        return (byte)o;
    }

    private char txShortToChar(short o) {
        return (char)o;
    }

    private double txShortToDouble(short o) {
        return o;
    }

    private float txShortToFloat(short o) {
        return o;
    }

    private int txShortToInt(short o) {
        return o;
    }

    private long txShortToLong(short o) {
        return o;
    }

    private String txShortToString(short o) {
        return String.valueOf(o);
    }

    private boolean txStringToBoolean(String o) {
        if ("true".equals(o = o.toLowerCase())) {
            return true;
        }
        if (o.equals("1")) {
            return true;
        }
        if ("yes".equals(o)) {
            return true;
        }
        if ("x".equals(o)) {
            return true;
        }
        return "on".equals(o);
    }

    private byte txStringToByte(String o) {
        try {
            return Byte.parseByte(o);
        }
        catch (NumberFormatException nfe1) {
            return (byte)Float.parseFloat(o);
        }
    }

    private char txStringToChar(String o) {
        return o.charAt(0);
    }

    private double txStringToDouble(String o) {
        return Double.parseDouble(o);
    }

    private float txStringToFloat(String o) {
        return Float.parseFloat(o);
    }

    private int txStringToInt(String o) {
        try {
            return Integer.parseInt(o);
        }
        catch (NumberFormatException nfe1) {
            return (int)Float.parseFloat(o);
        }
    }

    private long txStringToLong(String o) {
        try {
            return Long.parseLong(o);
        }
        catch (NumberFormatException nfe1) {
            return (long)Double.parseDouble(o);
        }
    }

    private short txStringToShort(String o) {
        try {
            return Short.parseShort(o);
        }
        catch (NumberFormatException nfe1) {
            return (short)Float.parseFloat(o);
        }
    }

    private BigDecimal txBigIntegerToBigDecimal(BigInteger o) {
        return new BigDecimal(o);
    }

    private boolean txBigIntegerToBoolean(BigInteger o) {
        return o.equals(BigInteger.ONE);
    }

    private byte txBigIntegerToByte(BigInteger o) {
        return o.byteValue();
    }

    private char txBigIntegerToChar(BigInteger o) {
        return (char)o.intValue();
    }

    private double txBigIntegerToDouble(BigInteger o) {
        return o.doubleValue();
    }

    private float txBigIntegerToFloat(BigInteger o) {
        return o.floatValue();
    }

    private int txBigIntegerToInt(BigInteger o) {
        return o.intValue();
    }

    private long txBigIntegerToLong(BigInteger o) {
        return o.longValue();
    }

    private short txBigIntegerToShort(BigInteger o) {
        return o.shortValue();
    }

    private String txBigIntegerToString(BigInteger o) {
        return o.toString();
    }

    private BigInteger txBigDecimalToBigInteger(BigDecimal o) {
        return o.toBigInteger();
    }

    private boolean txBigDecimalToBoolean(BigDecimal o) {
        return BigInteger.ONE.equals(o.toBigInteger());
    }

    private byte txBigDecimalToByte(BigDecimal o) {
        return o.byteValue();
    }

    private char txBigDecimalToChar(BigDecimal o) {
        return (char)o.intValue();
    }

    private double txBigDecimalToDouble(BigDecimal o) {
        return o.doubleValue();
    }

    private float txBigDecimalToFloat(BigDecimal o) {
        return o.floatValue();
    }

    private int txBigDecimalToInt(BigDecimal o) {
        return o.intValue();
    }

    private long txBigDecimalToLong(BigDecimal o) {
        return o.longValue();
    }

    private short txBigDecimalToShort(BigDecimal o) {
        return o.shortValue();
    }

    private String txBigDecimalToString(BigDecimal o) {
        return o.toString();
    }

    private BigDecimal txBooleanToBigDecimal(boolean o) {
        return new BigDecimal(o ? BigInteger.ONE : BigInteger.ZERO);
    }

    private BigInteger txBooleanToBigInteger(boolean o) {
        return o ? BigInteger.ONE : BigInteger.ZERO;
    }

    private BigDecimal txByteToBigDecimal(byte o) {
        return BigDecimal.valueOf(o);
    }

    private BigInteger txByteToBigInteger(byte o) {
        return BigInteger.valueOf(o);
    }

    private java.util.Date txCalendarToDate(Calendar o) {
        return o.getTime();
    }

    private UTCDate txCalendarToUTCDate(Calendar o) {
        return new UTCDate(o.getTime().getTime());
    }

    private Date txCalendarToSqlDate(Calendar o) {
        return new Date(o.getTimeInMillis());
    }

    private Time txCalendarToSqlTime(Calendar o) {
        return new Time(o.getTimeInMillis());
    }

    private Timestamp txCalendarToSqlTimestamp(Calendar o) {
        return new Timestamp(o.getTimeInMillis());
    }

    private String txCalendarToString(Calendar o) {
        return new SimpleDateFormat(ZULU_DATE_TO_STRING_FORMAT).format(o.getTime());
    }

    private BigDecimal txCharToBigDecimal(char o) {
        return BigDecimal.valueOf(o);
    }

    private BigInteger txCharToBigInteger(char o) {
        return BigInteger.valueOf(o);
    }

    private Calendar txDateToCalendar(java.util.Date o) {
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(o);
        return cal;
    }

    private UTCDate txDateToUTCDate(java.util.Date o) {
        return new UTCDate(o.getTime());
    }

    private Date txDateToSqlDate(java.util.Date o) {
        return new Date(o.getTime());
    }

    private Time txDateToSqlTime(java.util.Date o) {
        return new Time(o.getTime());
    }

    private Timestamp txDateToSqlTimestamp(java.util.Date o) {
        return new Timestamp(o.getTime());
    }

    private String txDateToString(java.util.Date o) {
        return new SimpleDateFormat(ZULU_DATE_TO_STRING_FORMAT).format(o);
    }

    private java.util.Date txUTCDateToDate(UTCDate o) {
        return o;
    }

    private Calendar txUTCDateToCalendar(UTCDate o) {
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(o);
        return cal;
    }

    private Date txUTCDateToSqlDate(UTCDate o) {
        return new Date(o.getTime());
    }

    private Time txUTCDateToSqlTime(UTCDate o) {
        return new Time(o.getTime());
    }

    private Timestamp txUTCDateToSqlTimestamp(UTCDate o) {
        return new Timestamp(o.getTime());
    }

    private String txUTCDateToString(UTCDate o) {
        return new SimpleDateFormat(ZULU_DATE_TO_STRING_FORMAT).format(o);
    }

    private BigDecimal txDoubleToBigDecimal(double o) {
        return new BigDecimal(Double.toString(o));
    }

    private BigInteger txDoubleToBigInteger(double o) {
        return BigInteger.valueOf((long)o);
    }

    private BigDecimal txFloatToBigDecimal(float o) {
        return new BigDecimal(String.valueOf(o));
    }

    private BigInteger txFloatToBigInteger(float o) {
        return BigInteger.valueOf((long)o);
    }

    private BigDecimal txIntToBigDecimal(int o) {
        return BigDecimal.valueOf(o);
    }

    private BigInteger txIntToBigInteger(int o) {
        return BigInteger.valueOf(o);
    }

    private BigDecimal txLongToBigDecimal(long o) {
        return BigDecimal.valueOf(o);
    }

    private BigInteger txLongToBigInteger(long o) {
        return BigInteger.valueOf(o);
    }

    private BigDecimal txShortToBigDecimal(short o) {
        return BigDecimal.valueOf(o);
    }

    private BigInteger txShortToBigInteger(short o) {
        return BigInteger.valueOf(o);
    }

    private Calendar txSqlDateToCalendar(Date o) {
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(o);
        return cal;
    }

    private Time txSqlDateToSqlTime(Date o) {
        return new Time(o.getTime());
    }

    private Timestamp txSqlDateToSqlTimestamp(Date o) {
        return new Timestamp(o.getTime());
    }

    private UTCDate txSqlDateToUTCDate(Date o) {
        return new UTCDate(o.getTime());
    }

    private String txSqlDateToString(Date o) {
        return new SimpleDateFormat(ZULU_DATE_TO_STRING_FORMAT).format(o);
    }

    private Calendar txSqlTimestampToCalendar(Timestamp o) {
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(o);
        return cal;
    }

    private Date txSqlTimestampToSqlDate(Timestamp o) {
        return new Date(o.getTime());
    }

    private Time txSqlTimestampToSqlTime(Timestamp o) {
        return new Time(o.getTime());
    }

    private UTCDate txSqlTimestampToUTCDate(Timestamp o) {
        return new UTCDate(o.getTime());
    }

    private String txSqlTimestampToString(Timestamp o) {
        return new SimpleDateFormat(ZULU_DATE_TO_STRING_FORMAT).format(o);
    }

    private Calendar txSqlTimeToCalendar(Time o) {
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(o);
        return cal;
    }

    private Date txSqlTimeToSqlDate(Time o) {
        return new Date(o.getTime());
    }

    private Timestamp txSqlTimeToSqlTimestamp(Time o) {
        return new Timestamp(o.getTime());
    }

    private UTCDate txSqlTimeToUTCDate(Time o) {
        return new UTCDate(o.getTime());
    }

    private String txSqlTimeToString(Time o) {
        return new SimpleDateFormat(ZULU_DATE_TO_STRING_FORMAT).format(o);
    }

    private java.util.Date txStringToDate(String o) {
        try {
            return new SimpleDateFormat(ZULU_DATE_TO_STRING_FORMAT).parse(o);
        }
        catch (ParseException pe) {
            throw this.createException(o, String.class, java.util.Date.class, 5, pe.getMessage());
        }
    }

    private UTCDate txStringToUTCDate(String o) {
        try {
            java.util.Date d = new SimpleDateFormat(ZULU_DATE_TO_STRING_FORMAT).parse(o);
            return new UTCDate(d.getTime());
        }
        catch (ParseException pe) {
            throw this.createException(o, String.class, UTCDate.class, 5, pe.getMessage());
        }
    }

    private Calendar txStringToCalendar(String o) {
        try {
            Calendar cal = Calendar.getInstance();
            cal.setTime(new SimpleDateFormat(ZULU_DATE_TO_STRING_FORMAT).parse(o));
            return cal;
        }
        catch (ParseException pe) {
            throw this.createException(o, String.class, Calendar.class, 6, pe.getMessage());
        }
    }

    private Date txStringToSqlDate(String o) {
        try {
            return new Date(new SimpleDateFormat("dd.MM.yyyy").parse(o).getTime());
        }
        catch (ParseException pe) {
            throw this.createException(o, String.class, Date.class, 7, pe.getMessage());
        }
    }

    private Time txStringToSqlTime(String o) {
        try {
            return new Time(new SimpleDateFormat("HH:mm:ss.sss").parse(o).getTime());
        }
        catch (ParseException pe) {
            throw this.createException(o, String.class, Time.class, 8, pe.getMessage());
        }
    }

    private Timestamp txStringToSqlTimestamp(String o) {
        try {
            return new Timestamp(new SimpleDateFormat(ZULU_DATE_TO_STRING_FORMAT).parse(o).getTime());
        }
        catch (ParseException pe) {
            throw this.createException(o, String.class, Timestamp.class, 8, pe.getMessage());
        }
    }

    private BigDecimal txStringToBigDecimal(String o) {
        return new BigDecimal(o);
    }

    private BigInteger txStringToBigInteger(String o) {
        return new BigDecimal(o).toBigInteger();
    }

    private byte txTriStateToByte(TriState o) {
        return o.isUndefined() ? (byte)-1 : o.getIntegerValue().byteValue();
    }

    private char txTriStateToChar(TriState o) {
        return (char)(o.isUndefined() ? 63 : (o.getBooleanValue() != false ? 88 : 32));
    }

    private double txTriStateToDouble(TriState o) {
        return o.isUndefined() ? -1.0 : o.getIntegerValue().doubleValue();
    }

    private float txTriStateToFloat(TriState o) {
        return o.isUndefined() ? -1.0f : o.getIntegerValue().floatValue();
    }

    private int txTriStateToInt(TriState o) {
        return o.isUndefined() ? -1 : o.getIntegerValue();
    }

    private long txTriStateToLong(TriState o) {
        return o.isUndefined() ? -1L : o.getIntegerValue().longValue();
    }

    private short txTriStateToShort(TriState o) {
        return o.isUndefined() ? (short)-1 : o.getIntegerValue().shortValue();
    }

    private String txTriStateToString(TriState o) {
        return o.toString();
    }

    private TriState txByteToTriState(byte o) {
        return TriState.parse(o);
    }

    private TriState txCharToTriState(char o) {
        return TriState.parse(Character.valueOf(o));
    }

    private TriState txDoubleToTriState(double o) {
        return TriState.parse(o);
    }

    private TriState txFloatToTriState(float o) {
        return TriState.parse(Float.valueOf(o));
    }

    private TriState txIntToTriState(int o) {
        return TriState.parse(o);
    }

    private TriState txLongToTriState(long o) {
        return TriState.parse(o);
    }

    private TriState txShortToTriState(short o) {
        return TriState.parse(o);
    }

    private TriState txStringToTriState(String o) {
        return TriState.parse(o);
    }

    private TriState txBigIntegerToTriState(BigInteger o) {
        return TriState.parse(o);
    }

    private TriState txBigDecimalToTriState(BigDecimal o) {
        return TriState.parse(o);
    }

    private BigDecimal txTriStateToBigDecimal(TriState o) {
        if (o.isUndefined()) {
            return null;
        }
        if (o.getBooleanValue().booleanValue()) {
            return BigDecimal.ONE;
        }
        return BigDecimal.ZERO;
    }

    private BigInteger txTriStateToBigInteger(TriState o) {
        if (o.isUndefined()) {
            return null;
        }
        if (o.getBooleanValue().booleanValue()) {
            return BigInteger.ONE;
        }
        return BigInteger.ZERO;
    }

    private TriState txBooleanToTriState(boolean o) {
        return TriState.parse(o);
    }

    private boolean txTriStateToBoolean(TriState o) {
        return o.isUndefined() ? false : o.getBooleanValue();
    }

    public static Class getGenericsParameterClass(Class queryClass, Class genericsOwnerClass) {
        return instance.getGenericsParameterClassImpl(queryClass, genericsOwnerClass, 0);
    }

    public static Class getGenericsParameterClass(Class queryClass, Class genericsOwnerClass, int genericsParameterIndex) {
        return instance.getGenericsParameterClassImpl(queryClass, genericsOwnerClass, genericsParameterIndex);
    }

    private Class getGenericsParameterClassImpl(Class queryClass, Class genericsOwnerClass, int genericsParameterIndex) {
        GPCKey key = new GPCKey(queryClass, genericsOwnerClass, genericsParameterIndex);
        Class<?> result = this.m_genericsParameterClassCache.get(key);
        if (result != null) {
            return result;
        }
        boolean debugEnabled = LOG.isDebugEnabled();
        if (debugEnabled) {
            LOG.debug("queryClass=" + queryClass + ", genericsOwnerClass=" + genericsOwnerClass + ", genericsParameterIndex=" + genericsParameterIndex);
        }
        TypeDesc desc = new TypeDesc();
        HashSet<Type> loopDetector = new HashSet<Type>();
        this.visitGenericsHierarchy(queryClass, genericsOwnerClass, genericsParameterIndex, desc, loopDetector, debugEnabled);
        if (desc.resolvedClazz == null) {
            StringBuilder s = new StringBuilder(desc.typeVariable != null ? desc.typeVariable.getName() : "null");
            int i = 0;
            while (i < desc.arrayDim) {
                s.append("[]");
                ++i;
            }
            throw new IllegalArgumentException("cannot resolve " + s.toString() + " to a 'Class' type on " + queryClass);
        }
        result = desc.arrayDim > 0 ? Array.newInstance(desc.resolvedClazz, new int[desc.arrayDim]).getClass() : desc.resolvedClazz;
        this.m_genericsParameterClassCache.put(key, result);
        return result;
    }

    private boolean visitGenericsHierarchy(Type type, Class<?> stopType, int stopTypeGenericsParameterIndex, TypeDesc desc, Set<Type> loopDetector, boolean debugEnabled) {
        if (loopDetector.contains(type)) {
            return false;
        }
        if (type instanceof Class) {
            int i;
            Object a;
            Class c = (Class)type;
            if (c == stopType) {
                desc.parameterizedTypeIndex = stopTypeGenericsParameterIndex;
                if (debugEnabled) {
                    LOG.debug("foundStopClass " + c + ", using generics index " + desc.parameterizedTypeIndex);
                }
                return true;
            }
            boolean foundStopClass = false;
            if (!foundStopClass && !c.isInterface() && (a = c.getGenericSuperclass()) != null) {
                try {
                    loopDetector.add(type);
                    foundStopClass = this.visitGenericsHierarchy((Type)a, stopType, stopTypeGenericsParameterIndex, desc, loopDetector, debugEnabled);
                }
                finally {
                    loopDetector.remove(type);
                }
            }
            if (!foundStopClass && ((Type[])(a = c.getGenericInterfaces())).length > 0) {
                i = 0;
                while (i < ((Type[])a).length && !foundStopClass) {
                    try {
                        loopDetector.add(type);
                        foundStopClass = this.visitGenericsHierarchy(a[i], stopType, stopTypeGenericsParameterIndex, desc, loopDetector, debugEnabled);
                    }
                    finally {
                        loopDetector.remove(type);
                    }
                    ++i;
                }
            }
            if (foundStopClass) {
                if (debugEnabled) {
                    LOG.debug("visit " + VerboseUtility.dumpGenerics(c));
                }
                if (desc.resolvedClazz == null) {
                    desc.parameterizedTypeIndex = 0;
                    TypeVariable<Class<T>>[] vars = c.getTypeParameters();
                    i = 0;
                    while (i < vars.length) {
                        if (vars[i] == desc.typeVariable) {
                            if (debugEnabled) {
                                LOG.debug(desc.typeVariable + " has index " + i);
                            }
                            desc.parameterizedTypeIndex = i;
                            break;
                        }
                        ++i;
                    }
                }
                return true;
            }
            return false;
        }
        if (type instanceof ParameterizedType) {
            ParameterizedType pt = (ParameterizedType)type;
            Type rawType = pt.getRawType();
            try {
                loopDetector.add(pt);
                boolean b = this.visitGenericsHierarchy(rawType, stopType, stopTypeGenericsParameterIndex, desc, loopDetector, debugEnabled);
                if (!b) {
                    return false;
                }
            }
            finally {
                loopDetector.remove(pt);
            }
            if (debugEnabled) {
                LOG.debug("visit " + VerboseUtility.dumpGenerics(pt));
            }
            if (desc.resolvedClazz == null) {
                Type actualArg = pt.getActualTypeArguments()[desc.parameterizedTypeIndex];
                if (debugEnabled) {
                    LOG.debug("index " + desc.parameterizedTypeIndex + " matches to " + actualArg);
                }
                while (actualArg instanceof GenericArrayType) {
                    actualArg = ((GenericArrayType)actualArg).getGenericComponentType();
                    ++desc.arrayDim;
                }
                if (actualArg instanceof ParameterizedType) {
                    actualArg = ((ParameterizedType)actualArg).getRawType();
                }
                if (actualArg instanceof Class) {
                    desc.resolvedClazz = (Class)actualArg;
                } else if (actualArg instanceof TypeVariable) {
                    desc.typeVariable = (TypeVariable)actualArg;
                } else {
                    if (debugEnabled) {
                        LOG.debug("failed with " + actualArg);
                    }
                    throw new IllegalArgumentException("expected ParameterizedType with actual argument of type Class or TypeVariable when encountered " + VerboseUtility.dumpGenerics(type));
                }
            }
            return true;
        }
        return false;
    }

    private static class GPCKey {
        private final Class<?> m_queryClass;
        private final Class<?> m_genericsOwnerClass;
        private final int m_genericsParameterIndex;

        public GPCKey(Class queryClass, Class genericsOwnerClass, int genericsParameterIndex) {
            this.m_queryClass = queryClass;
            this.m_genericsOwnerClass = genericsOwnerClass;
            this.m_genericsParameterIndex = genericsParameterIndex;
        }

        public int hashCode() {
            return (this.m_queryClass != null ? this.m_queryClass.hashCode() : 0) ^ (this.m_genericsOwnerClass != null ? this.m_genericsOwnerClass.hashCode() : 0) ^ this.m_genericsParameterIndex;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof GPCKey)) {
                return false;
            }
            GPCKey o = (GPCKey)obj;
            return this.m_queryClass == o.m_queryClass && this.m_genericsOwnerClass == o.m_genericsOwnerClass && this.m_genericsParameterIndex == o.m_genericsParameterIndex;
        }
    }

    private static class TypeDesc {
        int parameterizedTypeIndex;
        TypeVariable<?> typeVariable;
        Class resolvedClazz;
        int arrayDim;

        private TypeDesc() {
        }
    }
}

