/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.commons.serialization;

import java.lang.reflect.Modifier;
import java.util.ArrayList;
import org.eclipse.core.runtime.IProduct;
import org.eclipse.core.runtime.Platform;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.commons.internal.Activator;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.commons.serialization.BasicObjectSerializerFactory;
import org.eclipse.scout.commons.serialization.BundleObjectSerializerFactory;
import org.eclipse.scout.commons.serialization.IObjectReplacer;
import org.eclipse.scout.commons.serialization.IObjectSerializer;
import org.eclipse.scout.commons.serialization.IObjectSerializerFactory;

public final class SerializationUtility {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(SerializationUtility.class);
    public static final String BUNDLE_ORDER_PREFIX_PROPERTY_NAME = "org.eclipse.scout.commons.serialization.bundleOrderPrefixes";
    public static final String ENABLE_RESOURCE_URL_CACHING_PROPERTY_NAME = "org.eclipse.scout.commons.serialization.enableResourceUrlCaching";
    public static final String ENABLE_USAGE_OF_BUNDLE_ORDER_PREFIX_LIST_AS_RESOURCE_FILTER_PROPERTY_NAME = "org.eclipse.scout.commons.serialization.enableUsageOfBundleOrderPrefixListAsResourceFilter";
    private static final IObjectSerializerFactory FACTORY = SerializationUtility.createObjectSerializerFactory();

    private SerializationUtility() {
    }

    private static IObjectSerializerFactory createObjectSerializerFactory() {
        IObjectSerializerFactory factory = null;
        if (Activator.getDefault() != null) {
            try {
                Class customSerializerFactory = Activator.getDefault().getBundle().loadClass("org.eclipse.scout.commons.serialization.CustomObjectSerializerFactory");
                LOG.info("loaded custom object serializer factory: [" + customSerializerFactory + "]");
                if (!IObjectSerializerFactory.class.isAssignableFrom(customSerializerFactory)) {
                    LOG.warn("custom object serializer factory is not implementing [" + IObjectSerializerFactory.class + "]");
                } else if (Modifier.isAbstract(customSerializerFactory.getModifiers())) {
                    LOG.warn("custom object serializer factory is an abstract class [" + customSerializerFactory + "]");
                } else {
                    factory = (IObjectSerializerFactory)customSerializerFactory.newInstance();
                }
            }
            catch (ClassNotFoundException customSerializerFactory) {
            }
            catch (Exception e) {
                LOG.warn("Unexpected problem while creating a new instance of custom object serializer factory", e);
            }
            if (factory == null) {
                factory = new BundleObjectSerializerFactory();
            }
        } else {
            factory = new BasicObjectSerializerFactory();
        }
        return factory;
    }

    public static String[] getBundleOrderPrefixes() {
        String rawBundlePrefixes = null;
        if (Activator.getDefault() != null) {
            rawBundlePrefixes = Activator.getDefault().getBundle().getBundleContext().getProperty(BUNDLE_ORDER_PREFIX_PROPERTY_NAME);
        }
        if (!StringUtility.hasText(rawBundlePrefixes)) {
            rawBundlePrefixes = System.getProperty(BUNDLE_ORDER_PREFIX_PROPERTY_NAME, null);
        }
        if (!StringUtility.hasText(rawBundlePrefixes)) {
            IProduct product;
            rawBundlePrefixes = "org.eclipse.scout";
            if (Activator.getDefault() != null && (product = Platform.getProduct()) != null && product.getDefiningBundle() != null && product.getDefiningBundle().getSymbolicName() != null) {
                String prefix = product.getDefiningBundle().getSymbolicName().replaceAll("^(.*\\.)(client|shared|server|ui)(\\.core)?.*$", "$1");
                rawBundlePrefixes = StringUtility.join(",", prefix, rawBundlePrefixes);
            }
            LOG.warn("bundle order prefixes are neither defined in config.ini nor as a system property. Using default value: org.eclipse.scout.commons.serialization.bundleOrderPrefixes=" + rawBundlePrefixes);
        }
        ArrayList<String> bundlePrefixes = new ArrayList<String>();
        String[] stringArray = StringUtility.split(rawBundlePrefixes, ",");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            if (StringUtility.hasText(s = StringUtility.trim(s))) {
                bundlePrefixes.add(s);
            }
            ++n2;
        }
        return bundlePrefixes.toArray(new String[bundlePrefixes.size()]);
    }

    public static boolean isResourceUrlCachingInBundleListClassLoaderEnabled() {
        String cacheEnabled = null;
        if (Activator.getDefault() != null) {
            cacheEnabled = Activator.getDefault().getBundle().getBundleContext().getProperty(ENABLE_RESOURCE_URL_CACHING_PROPERTY_NAME);
        }
        if (!StringUtility.hasText(cacheEnabled)) {
            cacheEnabled = System.getProperty(ENABLE_RESOURCE_URL_CACHING_PROPERTY_NAME, null);
        }
        return StringUtility.parseBoolean(cacheEnabled, false);
    }

    public static boolean isUseBundleOrderPrefixListAsResourceFilterEnabled() {
        String cacheEnabled = null;
        if (Activator.getDefault() != null) {
            cacheEnabled = Activator.getDefault().getBundle().getBundleContext().getProperty(ENABLE_USAGE_OF_BUNDLE_ORDER_PREFIX_LIST_AS_RESOURCE_FILTER_PROPERTY_NAME);
        }
        if (!StringUtility.hasText(cacheEnabled)) {
            cacheEnabled = System.getProperty(ENABLE_USAGE_OF_BUNDLE_ORDER_PREFIX_LIST_AS_RESOURCE_FILTER_PROPERTY_NAME, null);
        }
        return StringUtility.parseBoolean(cacheEnabled, false);
    }

    public static IObjectSerializer createObjectSerializer() {
        return SerializationUtility.createObjectSerializer(null);
    }

    public static IObjectSerializer createObjectSerializer(IObjectReplacer objectReplacer) {
        return FACTORY.createObjectSerializer(objectReplacer);
    }

    public static ClassLoader getClassLoader() {
        return FACTORY.getClassLoader();
    }
}

