/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.nls.sdk.internal.jdt;

import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.scout.nls.sdk.internal.NlsCore;
import org.eclipse.scout.sdk.util.type.TypeUtility;

public final class NlsJdtUtility {
    private NlsJdtUtility() {
    }

    public static List<IClasspathEntry> getSourceLocations(IJavaProject project) throws JavaModelException {
        IClasspathEntry[] clEntries;
        LinkedList<IClasspathEntry> sourceLocations = new LinkedList<IClasspathEntry>();
        IClasspathEntry[] iClasspathEntryArray = clEntries = project.getRawClasspath();
        int n = clEntries.length;
        int n2 = 0;
        while (n2 < n) {
            IClasspathEntry entry = iClasspathEntryArray[n2];
            if (entry.getEntryKind() == 3) {
                sourceLocations.add(entry);
            }
            ++n2;
        }
        return sourceLocations;
    }

    public static boolean createFolder(IContainer folder, boolean recursively, IProgressMonitor monitor) throws CoreException {
        if (!folder.exists()) {
            NlsJdtUtility.createFolder(folder.getParent(), recursively, monitor);
            if (folder instanceof IFolder) {
                ((IFolder)folder).create(true, false, monitor);
            }
        }
        return true;
    }

    public static IType getITypeForFile(IFile file) {
        try {
            IJavaElement create = JavaCore.create((IFile)file);
            if (TypeUtility.exists((IJavaElement)create)) {
                if (create.getElementType() == 5) {
                    ICompilationUnit icu = (ICompilationUnit)create;
                    IType[] types = icu.getTypes();
                    if (types.length > 0) {
                        return types[0];
                    }
                } else if (create.getElementType() == 7) {
                    return (IType)create;
                }
            }
        }
        catch (Exception e) {
            NlsCore.logWarning(e);
        }
        return null;
    }

    public static List<IPackageFragment> getPluginPackages(IProject project) {
        IJavaProject jp = JavaCore.create((IProject)project);
        return NlsJdtUtility.getPluginPackages(jp);
    }

    public static List<IPackageFragment> getPluginPackages(IJavaProject jProject) {
        LinkedList<IPackageFragment> proposals = new LinkedList<IPackageFragment>();
        try {
            IClasspathEntry[] iClasspathEntryArray = jProject.getRawClasspath();
            int n = iClasspathEntryArray.length;
            int n2 = 0;
            while (n2 < n) {
                IClasspathEntry entry = iClasspathEntryArray[n2];
                if (entry.getEntryKind() == 3) {
                    IPackageFragmentRoot[] iPackageFragmentRootArray = jProject.findPackageFragmentRoots(entry);
                    int n3 = iPackageFragmentRootArray.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        IPackageFragmentRoot fragRoot = iPackageFragmentRootArray[n4];
                        IJavaElement[] iJavaElementArray = fragRoot.getChildren();
                        int n5 = iJavaElementArray.length;
                        int n6 = 0;
                        while (n6 < n5) {
                            IJavaElement ele = iJavaElementArray[n6];
                            if (ele instanceof IPackageFragment) {
                                proposals.add((IPackageFragment)ele);
                            }
                            ++n6;
                        }
                        ++n4;
                    }
                }
                ++n2;
            }
            return proposals;
        }
        catch (JavaModelException e) {
            NlsCore.logWarning(e);
            return new LinkedList<IPackageFragment>();
        }
    }
}

