/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.action.print;

import java.io.File;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.scout.commons.CollectionUtility;
import org.eclipse.scout.commons.exception.ProcessingException;
import org.eclipse.scout.commons.exception.VetoException;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.commons.runtime.BundleBrowser;
import org.eclipse.scout.rt.client.ClientSyncJob;
import org.eclipse.scout.rt.client.ui.action.AbstractAction;
import org.eclipse.scout.rt.client.ui.form.AbstractForm;
import org.eclipse.scout.rt.client.ui.form.AbstractFormHandler;
import org.eclipse.scout.rt.client.ui.form.FormEvent;
import org.eclipse.scout.rt.client.ui.form.FormListener;
import org.eclipse.scout.rt.client.ui.form.IForm;
import org.eclipse.scout.rt.client.ui.form.IFormHandler;
import org.eclipse.scout.rt.client.ui.form.PrintDevice;
import org.eclipse.scout.rt.client.ui.form.fields.IFormField;
import org.eclipse.scout.rt.client.ui.form.fields.groupbox.IGroupBox;
import org.eclipse.scout.rt.client.ui.form.fields.tabbox.ITabBox;
import org.osgi.framework.Bundle;

public class PrintFormsAction
extends AbstractAction {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(PrintFormsAction.class);
    private List<Class<? extends IForm>> m_formTypes;
    private String m_contentType = "image/jpg";
    private File m_destinationFolder;
    private final List<File> m_printedFiles;
    private int m_formImageIndex;
    private int m_formCount;
    private int m_imageCount;
    private int m_errorCount;
    private final List<Runnable> m_runnables = Collections.synchronizedList(new ArrayList());

    public PrintFormsAction() {
        this.m_printedFiles = new ArrayList<File>();
    }

    public List<Class<? extends IForm>> getFormTypes() {
        return CollectionUtility.arrayList(this.m_formTypes);
    }

    public void setFormTypes(List<Class<? extends IForm>> formTypes) {
        this.m_formTypes = CollectionUtility.arrayListWithoutNullElements(formTypes);
    }

    public void setFormTypesByBundle(Bundle bundle) {
        BundleBrowser b = new BundleBrowser(bundle.getSymbolicName(), bundle.getSymbolicName());
        ArrayList<Class<? extends IForm>> list = new ArrayList<Class<? extends IForm>>();
        String[] stringArray = b.getClasses(false, true);
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String name = stringArray[n2];
            try {
                Class c = bundle.loadClass(name);
                if (IForm.class.isAssignableFrom(c)) {
                    list.add(c);
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
            ++n2;
        }
        this.m_formTypes = list;
    }

    public String getContentType() {
        return this.m_contentType;
    }

    public void setContentType(String s) {
        this.m_contentType = s;
    }

    public File getDestinationFolder() {
        return this.m_destinationFolder;
    }

    public void setDestinationFolder(File folder) {
        this.m_destinationFolder = folder;
    }

    public List<File> getPrintedFiles() {
        return CollectionUtility.arrayList(this.m_printedFiles);
    }

    @Override
    protected void execAction() throws ProcessingException {
        if (this.getFormTypes() == null) {
            throw new VetoException("formTypes array is null");
        }
        if (this.getDestinationFolder() == null) {
            throw new VetoException("destinationFolder is null");
        }
        this.m_printedFiles.clear();
        this.m_formCount = 0;
        this.m_imageCount = 0;
        this.m_errorCount = 0;
        for (Class<? extends IForm> c : this.getFormTypes()) {
            try {
                this.m_formImageIndex = 0;
                if (!IForm.class.isAssignableFrom(c)) continue;
                for (IForm f : this.createFormInstancesFor(c)) {
                    ++this.m_formCount;
                    this.processForm(f);
                }
            }
            catch (Throwable t) {
                ++this.m_errorCount;
                LOG.error(c.getName(), t);
            }
        }
    }

    protected List<IForm> createFormInstancesFor(Class<? extends IForm> formClass) throws Throwable {
        ArrayList<IForm> list = new ArrayList<IForm>();
        list.add(formClass.newInstance());
        return list;
    }

    protected void processForm(IForm f) throws Throwable {
        f.setModal(false);
        f.setAutoAddRemoveOnDesktop(true);
        f.setDisplayHint(0);
        f.setDisplayViewId(null);
        AbstractFormHandler handler = new AbstractFormHandler(){};
        Method m = AbstractForm.class.getDeclaredMethod("startInternal", IFormHandler.class);
        m.setAccessible(true);
        m.invoke((Object)f, handler);
        this.m_runnables.clear();
        P_FormListener listener = new P_FormListener();
        f.addFormListener(listener);
        f.waitFor();
    }

    protected int getFormImageIndex() {
        return this.m_formImageIndex;
    }

    protected void nextFormImageIndex() {
        ++this.m_formImageIndex;
    }

    public int getResultFormCount() {
        return this.m_formCount;
    }

    public int getResultImageCount() {
        return this.m_imageCount;
    }

    public int getResultErrorCount() {
        return this.m_errorCount;
    }

    protected void printForm(IForm f, String contextName) {
        String name = String.valueOf(f.getClass().getName()) + (this.getFormImageIndex() > 0 ? "_" + this.getFormImageIndex() : "");
        String ext = this.getContentType().substring(this.getContentType().lastIndexOf(47) + 1);
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("file", new File(this.getDestinationFolder(), String.valueOf(name) + (contextName != null ? contextName : "") + "." + ext));
        parameters.put("contentType", this.getContentType());
        f.printForm(PrintDevice.File, parameters);
        this.nextFormImageIndex();
        ++this.m_imageCount;
    }

    protected void printFormField(IForm form, IFormField f, String contextName) {
        String name = String.valueOf(form.getClass().getName()) + "_" + this.getFormImageIndex() + "_" + f.getClass().getSimpleName();
        String ext = this.getContentType().substring(this.getContentType().lastIndexOf(47) + 1);
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("file", new File(this.getDestinationFolder(), String.valueOf(name) + (contextName != null ? contextName : "") + "." + ext));
        parameters.put("contentType", this.getContentType());
        form.printField(f, PrintDevice.File, parameters);
        this.nextFormImageIndex();
        ++this.m_imageCount;
    }

    private class P_FormListener
    implements FormListener {
        private P_FormListener() {
        }

        @Override
        public void formChanged(FormEvent e) throws ProcessingException {
            if (e.getType() == 510) {
                this.schedulePrintJob(e.getForm());
            } else if (e.getType() == 4010) {
                PrintFormsAction.this.m_printedFiles.add(e.getPrintedFile());
                if (!PrintFormsAction.this.m_runnables.isEmpty()) {
                    Runnable r = (Runnable)PrintFormsAction.this.m_runnables.remove(0);
                    r.run();
                }
            }
        }

        private void schedulePrintJob(final IForm f) {
            new ClientSyncJob("print " + f.getClass().getSimpleName(), ClientSyncJob.getCurrentSession()){

                @Override
                protected void runVoid(IProgressMonitor monitor) {
                    PrintFormsAction.this.printForm(f, null);
                    for (IFormField field : f.getAllFields()) {
                        if (!(field instanceof ITabBox) || field.isVisible()) continue;
                        field.setVisible(true);
                    }
                    for (IFormField field : f.getAllFields()) {
                        if (!(field instanceof ITabBox) || !field.isVisible()) continue;
                        final ITabBox tabBox = (ITabBox)field;
                        IGroupBox selectedTab = null;
                        if (tabBox.isVisible()) {
                            selectedTab = tabBox.getSelectedTab();
                        }
                        if (!tabBox.isVisible()) continue;
                        for (final IGroupBox g : tabBox.getGroupBoxes()) {
                            if (g == selectedTab) continue;
                            PrintFormsAction.this.m_runnables.add(new Runnable(){

                                @Override
                                public void run() {
                                    tabBox.setSelectedTab(g);
                                    PrintFormsAction.this.printFormField(f, tabBox, "_" + g.getClass().getSimpleName());
                                }
                            });
                        }
                    }
                    PrintFormsAction.this.m_runnables.add(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                f.doClose();
                            }
                            catch (ProcessingException e) {
                                LOG.error("could not close form '" + f.getClass().getSimpleName() + "'", (Throwable)e);
                            }
                        }
                    });
                }
            }.schedule();
        }
    }
}

