/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.basic.activitymap;

import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.TreeMap;
import org.eclipse.scout.commons.CompositeObject;
import org.eclipse.scout.rt.client.ui.basic.activitymap.MajorTimeColumn;
import org.eclipse.scout.rt.client.ui.basic.activitymap.MinorTimeColumn;

public class TimeScale {
    private DateFormat m_dateFormat;
    private final List<MajorTimeColumn> m_childrenUnsorted = new ArrayList<MajorTimeColumn>(0);
    private MajorTimeColumn[] m_majorColumnsSorted;
    private MinorTimeColumn[] m_minorColumnsSorted;
    public static final int SMALL = 0;
    public static final int MEDIUM = 1;
    public static final int LARGE = 2;

    protected void addMajorColumnNotify(MajorTimeColumn majorCol) {
        this.m_childrenUnsorted.add(majorCol);
        this.m_majorColumnsSorted = null;
        this.m_minorColumnsSorted = null;
    }

    protected void addMinorColumnNotify(MajorTimeColumn majorCol, MinorTimeColumn minorCol) {
        this.m_majorColumnsSorted = null;
        this.m_minorColumnsSorted = null;
    }

    public MajorTimeColumn[] getMajorTimeColumns() {
        if (this.m_majorColumnsSorted == null) {
            TreeMap<CompositeObject, MajorTimeColumn> sortMap = new TreeMap<CompositeObject, MajorTimeColumn>();
            int index = 0;
            for (MajorTimeColumn c : this.m_childrenUnsorted) {
                MinorTimeColumn[] minorCols = c.getMinorTimeColumns();
                if (minorCols.length > 0) {
                    sortMap.put(new CompositeObject(new Object[]{minorCols[0].getBeginTime(), index}), c);
                } else {
                    sortMap.put(new CompositeObject(new Object[]{new Date(), index}), c);
                }
                ++index;
            }
            this.m_majorColumnsSorted = sortMap.values().toArray(new MajorTimeColumn[sortMap.size()]);
        }
        return this.m_majorColumnsSorted;
    }

    public MinorTimeColumn[] getMinorTimeColumns() {
        if (this.m_minorColumnsSorted == null) {
            TreeMap<Date, MinorTimeColumn> sortMap = new TreeMap<Date, MinorTimeColumn>();
            MajorTimeColumn[] majorTimeColumnArray = this.getMajorTimeColumns();
            int n = majorTimeColumnArray.length;
            int n2 = 0;
            while (n2 < n) {
                MajorTimeColumn c = majorTimeColumnArray[n2];
                MinorTimeColumn[] minorTimeColumnArray = c.getMinorTimeColumns();
                int n3 = minorTimeColumnArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    MinorTimeColumn minorCol = minorTimeColumnArray[n4];
                    sortMap.put(minorCol.getBeginTime(), minorCol);
                    ++n4;
                }
                ++n2;
            }
            this.m_minorColumnsSorted = sortMap.values().toArray(new MinorTimeColumn[sortMap.size()]);
        }
        return this.m_minorColumnsSorted;
    }

    public Date getBeginTime() {
        MinorTimeColumn[] cols = this.getMinorTimeColumns();
        if (cols.length > 0) {
            return cols[0].getBeginTime();
        }
        return new Date();
    }

    public Date getEndTime() {
        MinorTimeColumn[] cols = this.getMinorTimeColumns();
        if (cols.length > 0) {
            return cols[cols.length - 1].getEndTime();
        }
        return new Date();
    }

    public Calendar getBeginCalendar() {
        Calendar cal = Calendar.getInstance();
        cal.setTime(this.getBeginTime());
        return cal;
    }

    public DateFormat getDateFormat() {
        return this.m_dateFormat;
    }

    public void setDateFormat(DateFormat s) {
        this.m_dateFormat = s;
    }

    public double[] getRangeOf(Date beginTime, Date endTime) {
        Integer a = null;
        Integer b = null;
        a = this.getStartMinorColumnIndex(beginTime);
        if (a == null) {
            return null;
        }
        if (beginTime.equals(endTime)) {
            b = a;
        }
        if (b == null) {
            b = this.getEndMinorColumnIndex(endTime);
        }
        if (b == null) {
            return null;
        }
        return new double[]{this.indexToRange(a)[0], this.indexToRange(b)[1]};
    }

    protected Integer getStartMinorColumnIndex(Date startTime) {
        if (startTime == null) {
            return null;
        }
        if (startTime.before(this.getBeginTime())) {
            return 0;
        }
        if (startTime.after(this.getEndTime())) {
            return null;
        }
        MinorTimeColumn[] minCols = this.getMinorTimeColumns();
        int i = minCols.length - 1;
        while (i >= 0) {
            if (startTime.compareTo(minCols[i].getBeginTime()) >= 0) {
                if (startTime.compareTo(minCols[i].getEndTime()) > 0) {
                    return i < minCols.length - 1 ? Integer.valueOf(i + 1) : null;
                }
                return i;
            }
            --i;
        }
        return null;
    }

    protected Integer getEndMinorColumnIndex(Date endTime) {
        if (endTime == null) {
            return null;
        }
        if (endTime.before(this.getBeginTime())) {
            return null;
        }
        if (endTime.after(this.getEndTime())) {
            return this.getMinorTimeColumns().length - 1;
        }
        MinorTimeColumn[] minCols = this.getMinorTimeColumns();
        int i = 0;
        while (i < minCols.length) {
            if (endTime.compareTo(minCols[i].getEndTime()) <= 0) {
                if (endTime.compareTo(minCols[i].getBeginTime()) < 0) {
                    return i > 0 ? Integer.valueOf(i - 1) : null;
                }
                return i;
            }
            ++i;
        }
        return null;
    }

    public double[] getRangeOf(MajorTimeColumn column) {
        MinorTimeColumn[] minorCols = column.getMinorTimeColumns();
        if (minorCols.length > 0) {
            double[] r1 = this.getRangeOf(minorCols[0]);
            double[] r2 = this.getRangeOf(minorCols[minorCols.length - 1]);
            if (r1 != null && r1.length > 0 && r2 != null && r2.length > 1) {
                return new double[]{r1[0], r2[1]};
            }
        }
        return null;
    }

    public double[] getRangeOf(MinorTimeColumn column) {
        MinorTimeColumn[] minCols = this.getMinorTimeColumns();
        int count = minCols.length;
        int i = 0;
        while (i < count) {
            if (minCols[i] == column) {
                return this.indexToRange(i);
            }
            ++i;
        }
        return null;
    }

    private double[] indexToRange(int index) {
        int count = this.getMinorTimeColumns().length;
        return new double[]{1.0 * (double)index / (double)count, 1.0 * ((double)index + 1.0) / (double)count};
    }

    private int locationToIndex(double d) {
        int count = this.getMinorTimeColumns().length;
        if (count == 0) {
            return -1;
        }
        int i = (int)(d * (double)count);
        if (i >= count) {
            i = count - 1;
        } else if (i < 0) {
            i = 0;
        }
        return i;
    }

    public double[] snapRange(double normalizedLocation) {
        int i = this.locationToIndex(normalizedLocation);
        if (i >= 0) {
            return this.indexToRange(i);
        }
        return new double[]{0.0, 0.0};
    }

    public MinorTimeColumn getMinorTimeColumn(double normalizedLocation) {
        MinorTimeColumn[] minorCols = this.getMinorTimeColumns();
        int i = this.locationToIndex(normalizedLocation);
        if (i >= 0) {
            return minorCols[i];
        }
        return null;
    }

    public Date getTimeByLocation(double normalizedLocation) {
        int i = this.locationToIndex(normalizedLocation);
        if (i >= 0) {
            MinorTimeColumn minorCol = this.getMinorTimeColumns()[i];
            double[] a = this.indexToRange(i);
            if (normalizedLocation < a[0]) {
                return minorCol.getBeginTime();
            }
            if (normalizedLocation <= a[1]) {
                double r = (normalizedLocation - a[0]) / (a[1] - a[0]);
                return new Date((long)((1.0 - r) * (double)minorCol.getBeginTime().getTime() + r * (double)minorCol.getEndTime().getTime()));
            }
            return minorCol.getEndTime();
        }
        return null;
    }

    public String toString() {
        return this.toString(2);
    }

    public String toString(int size) {
        StringBuilder b = new StringBuilder();
        b.append(this.getClass().getSimpleName());
        b.append("[");
        MajorTimeColumn[] majorTimeColumnArray = this.getMajorTimeColumns();
        int n = majorTimeColumnArray.length;
        int n2 = 0;
        while (n2 < n) {
            MajorTimeColumn c = majorTimeColumnArray[n2];
            b.append(" ");
            b.append(c.toString(size));
            ++n2;
        }
        b.append(" ]");
        return b.toString();
    }
}

