/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.desktop.bookmark.menu;

import org.eclipse.scout.commons.annotations.ConfigOperation;
import org.eclipse.scout.commons.annotations.Order;
import org.eclipse.scout.commons.exception.ProcessingException;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.client.ClientSyncJob;
import org.eclipse.scout.rt.client.ui.action.menu.AbstractMenu;
import org.eclipse.scout.rt.shared.services.common.bookmark.Bookmark;

public class ActivateBookmarkMenu
extends AbstractMenu {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(ActivateBookmarkMenu.class);
    private final Bookmark m_bookmark;

    public ActivateBookmarkMenu(Bookmark b) {
        super(false);
        this.m_bookmark = b;
        this.callInitializer();
    }

    public Bookmark getBookmark() {
        return this.m_bookmark;
    }

    @Override
    @ConfigOperation
    @Order(value=10.0)
    protected void execInitAction() {
        if (this.m_bookmark != null) {
            this.setText(this.m_bookmark.getTitle());
            this.setIconId(this.m_bookmark.getIconId());
            this.setKeyStroke(this.m_bookmark.getKeyStroke());
        } else {
            this.setText("...");
        }
    }

    @Override
    protected void execAction() throws ProcessingException {
        if (this.m_bookmark != null) {
            try {
                ClientSyncJob.getCurrentSession().getDesktop().activateBookmark(this.m_bookmark);
            }
            catch (Throwable t) {
                LOG.error(null, t);
            }
        }
    }
}

