/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.form.fields.smartfield;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.scout.commons.CollectionUtility;
import org.eclipse.scout.commons.ConfigurationUtility;
import org.eclipse.scout.commons.EventListenerList;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.commons.TriState;
import org.eclipse.scout.commons.annotations.ConfigOperation;
import org.eclipse.scout.commons.annotations.ConfigProperty;
import org.eclipse.scout.commons.annotations.Order;
import org.eclipse.scout.commons.annotations.ScoutSdkIgnore;
import org.eclipse.scout.commons.exception.IProcessingStatus;
import org.eclipse.scout.commons.exception.ProcessingException;
import org.eclipse.scout.commons.exception.ProcessingStatus;
import org.eclipse.scout.commons.holders.Holder;
import org.eclipse.scout.commons.job.JobEx;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.client.ClientSyncJob;
import org.eclipse.scout.rt.client.IClientSession;
import org.eclipse.scout.rt.client.extension.ui.form.fields.IFormFieldExtension;
import org.eclipse.scout.rt.client.extension.ui.form.fields.smartfield.ContentAssistFieldChains;
import org.eclipse.scout.rt.client.extension.ui.form.fields.smartfield.IContentAssistFieldExtension;
import org.eclipse.scout.rt.client.services.lookup.FormFieldProvisioningContext;
import org.eclipse.scout.rt.client.services.lookup.ILookupCallProvisioningService;
import org.eclipse.scout.rt.client.ui.desktop.IDesktop;
import org.eclipse.scout.rt.client.ui.form.FormEvent;
import org.eclipse.scout.rt.client.ui.form.FormListener;
import org.eclipse.scout.rt.client.ui.form.fields.AbstractFormField;
import org.eclipse.scout.rt.client.ui.form.fields.AbstractValueField;
import org.eclipse.scout.rt.client.ui.form.fields.smartfield.ContentAssistFieldDataFetcher;
import org.eclipse.scout.rt.client.ui.form.fields.smartfield.ContentAssistFieldEvent;
import org.eclipse.scout.rt.client.ui.form.fields.smartfield.ContentAssistFieldListener;
import org.eclipse.scout.rt.client.ui.form.fields.smartfield.ContentAssistFieldTable;
import org.eclipse.scout.rt.client.ui.form.fields.smartfield.DefaultContentAssistFieldProposalFormProvider;
import org.eclipse.scout.rt.client.ui.form.fields.smartfield.HierachycalContentAssistDataFetcher;
import org.eclipse.scout.rt.client.ui.form.fields.smartfield.IContentAssistField;
import org.eclipse.scout.rt.client.ui.form.fields.smartfield.IContentAssistFieldDataFetchResult;
import org.eclipse.scout.rt.client.ui.form.fields.smartfield.IContentAssistFieldLookupRowFetcher;
import org.eclipse.scout.rt.client.ui.form.fields.smartfield.IContentAssistFieldProposalForm;
import org.eclipse.scout.rt.client.ui.form.fields.smartfield.IContentAssistFieldProposalFormProvider;
import org.eclipse.scout.rt.client.ui.form.fields.smartfield.IContentAssistFieldTable;
import org.eclipse.scout.rt.shared.ScoutTexts;
import org.eclipse.scout.rt.shared.data.basic.FontSpec;
import org.eclipse.scout.rt.shared.data.form.ValidationRule;
import org.eclipse.scout.rt.shared.services.common.code.CODES;
import org.eclipse.scout.rt.shared.services.common.code.ICodeType;
import org.eclipse.scout.rt.shared.services.common.exceptionhandler.IExceptionHandlerService;
import org.eclipse.scout.rt.shared.services.lookup.CodeLookupCall;
import org.eclipse.scout.rt.shared.services.lookup.ILookupCall;
import org.eclipse.scout.rt.shared.services.lookup.ILookupCallFetcher;
import org.eclipse.scout.rt.shared.services.lookup.ILookupRow;
import org.eclipse.scout.rt.shared.services.lookup.LookupRow;
import org.eclipse.scout.service.SERVICES;

@ScoutSdkIgnore
public abstract class AbstractContentAssistField<VALUE, LOOKUP_KEY>
extends AbstractValueField<VALUE>
implements IContentAssistField<VALUE, LOOKUP_KEY> {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(AbstractContentAssistField.class);
    public final ILookupRow<LOOKUP_KEY> EMPTY_LOOKUP_ROW = new LookupRow(null, "", null, null, null, null, null, true);
    private final EventListenerList m_listenerList = new EventListenerList();
    private Class<? extends ICodeType<?, LOOKUP_KEY>> m_codeTypeClass;
    private ILookupCall<LOOKUP_KEY> m_lookupCall;
    private P_ProposalFormListener m_proposalFormListener;
    private IContentAssistFieldProposalFormProvider<LOOKUP_KEY> m_proposalFormProvider;
    private P_LookupRowFetcherPropertyListener m_lookupRowFetcherPropertyListener;
    private IContentAssistFieldLookupRowFetcher<LOOKUP_KEY> m_lookupRowFetcher;
    private int m_maxRowCount;
    private String m_browseNewText;
    private boolean m_installingRowContext = false;
    private LookupRow m_decorationRow;
    private TriState m_activeFilter;
    private boolean m_activeFilterEnabled;
    private boolean m_browseAutoExpandAll;
    private boolean m_browseHierarchy;
    private boolean m_loadIncremental;
    private int m_proposalFormHeight;
    private ILookupRow<LOOKUP_KEY> m_currentLookupRow;
    private Class<? extends IContentAssistFieldTable<VALUE>> m_contentAssistTableClazz;

    public AbstractContentAssistField() {
        this(true);
    }

    public AbstractContentAssistField(boolean callInitializer) {
        super(callInitializer);
    }

    @ConfigProperty(value="ICON_ID")
    @Order(value=270.0)
    protected String getConfiguredBrowseIconId() {
        return null;
    }

    @ConfigProperty(value="ICON_ID")
    @Order(value=230.0)
    protected String getConfiguredIconId() {
        return "smartfield_browse";
    }

    @ConfigProperty(value="BOOLEAN")
    @Order(value=280.0)
    protected boolean getConfiguredBrowseAutoExpandAll() {
        return true;
    }

    @ConfigProperty(value="BOOLEAN")
    @Order(value=300.0)
    @ValidationRule(value="zeroNullEquality")
    protected boolean getConfiguredTreat0AsNull() {
        return true;
    }

    @ConfigProperty(value="BOOLEAN")
    @Order(value=240.0)
    protected boolean getConfiguredBrowseLoadIncremental() {
        return false;
    }

    @ConfigProperty(value="BOOLEAN")
    @Order(value=310.0)
    protected boolean getConfiguredBrowseHierarchy() {
        return false;
    }

    @ConfigProperty(value="STRING")
    @Order(value=315.0)
    protected String getConfiguredBrowseNewText() {
        return null;
    }

    @ConfigProperty(value="CODE_TYPE")
    @Order(value=260.0)
    @ValidationRule(value="codeType")
    protected Class<? extends ICodeType<?, LOOKUP_KEY>> getConfiguredCodeType() {
        return null;
    }

    @ConfigProperty(value="LOOKUP_CALL")
    @Order(value=250.0)
    @ValidationRule(value="lookupCall")
    protected Class<? extends ILookupCall<LOOKUP_KEY>> getConfiguredLookupCall() {
        return null;
    }

    @ConfigProperty(value="INTEGER")
    @Order(value=265.0)
    protected int getConfiguredBrowseMaxRowCount() {
        return 100;
    }

    @ConfigProperty(value="BOOLEAN")
    @Order(value=270.0)
    protected boolean getConfiguredActiveFilterEnabled() {
        return false;
    }

    @ConfigProperty(value="INTEGER")
    @Order(value=280.0)
    protected int getConfiguredProposalFormHeight() {
        return 280;
    }

    @Order(value=290.0)
    protected Class<? extends IContentAssistFieldTable<VALUE>> getConfiguredContentAssistTable() {
        return null;
    }

    @ConfigOperation
    @Order(value=225.0)
    protected ILookupRow<LOOKUP_KEY> execBrowseNew(String searchText) throws ProcessingException {
        return null;
    }

    @ConfigOperation
    @Order(value=230.0)
    protected void execPrepareLookup(ILookupCall<LOOKUP_KEY> call) throws ProcessingException {
    }

    @ConfigOperation
    @Order(value=240.0)
    protected void execPrepareKeyLookup(ILookupCall<LOOKUP_KEY> call, LOOKUP_KEY key) throws ProcessingException {
    }

    @ConfigOperation
    @Order(value=250.0)
    protected void execPrepareTextLookup(ILookupCall<LOOKUP_KEY> call, String text) throws ProcessingException {
    }

    @ConfigOperation
    @Order(value=260.0)
    protected void execPrepareBrowseLookup(ILookupCall<LOOKUP_KEY> call, String browseHint) throws ProcessingException {
    }

    @ConfigOperation
    @Order(value=270.0)
    protected void execPrepareRecLookup(ILookupCall<LOOKUP_KEY> call, LOOKUP_KEY parentKey) throws ProcessingException {
    }

    @ConfigOperation
    @Order(value=280.0)
    protected void execFilterLookupResult(ILookupCall<LOOKUP_KEY> call, List<ILookupRow<LOOKUP_KEY>> result) throws ProcessingException {
    }

    @ConfigOperation
    @Order(value=290.0)
    protected void execFilterKeyLookupResult(ILookupCall<LOOKUP_KEY> call, List<ILookupRow<LOOKUP_KEY>> result) throws ProcessingException {
    }

    @ConfigOperation
    @Order(value=300.0)
    protected void execFilterTextLookupResult(ILookupCall<LOOKUP_KEY> call, List<ILookupRow<LOOKUP_KEY>> result) throws ProcessingException {
    }

    @ConfigOperation
    @Order(value=310.0)
    protected void execFilterBrowseLookupResult(ILookupCall<LOOKUP_KEY> call, List<ILookupRow<LOOKUP_KEY>> result) throws ProcessingException {
    }

    @ConfigOperation
    @Order(value=320.0)
    protected void execFilterRecLookupResult(ILookupCall<LOOKUP_KEY> call, List<ILookupRow<LOOKUP_KEY>> result) throws ProcessingException {
    }

    @Override
    public boolean acceptBrowseHierarchySelection(LOOKUP_KEY value, int level, boolean leaf) {
        return true;
    }

    @Override
    protected final boolean getConfiguredAutoDisplayText() {
        return true;
    }

    @Override
    public void setTooltipText(String text) {
        super.setTooltipText(text);
        if (!this.m_installingRowContext) {
            this.m_decorationRow.setTooltipText(this.getTooltipText());
        }
    }

    @Override
    public void setBackgroundColor(String c) {
        super.setBackgroundColor(c);
        if (!this.m_installingRowContext) {
            this.m_decorationRow.setBackgroundColor(this.getBackgroundColor());
        }
    }

    @Override
    public void setForegroundColor(String c) {
        super.setForegroundColor(c);
        if (!this.m_installingRowContext) {
            this.m_decorationRow.setForegroundColor(this.getForegroundColor());
        }
    }

    @Override
    public void setFont(FontSpec f) {
        super.setFont(f);
        if (!this.m_installingRowContext) {
            this.m_decorationRow.setFont(this.getFont());
        }
    }

    @Override
    protected void initConfig() {
        Class<ILookupCall<LOOKUP_KEY>> lsCls;
        this.m_activeFilter = TriState.TRUE;
        this.m_decorationRow = new LookupRow(null, "", null, null, null, null, null, true);
        super.initConfig();
        this.setActiveFilterEnabled(this.getConfiguredActiveFilterEnabled());
        this.setBrowseHierarchy(this.getConfiguredBrowseHierarchy());
        this.setBrowseAutoExpandAll(this.getConfiguredBrowseAutoExpandAll());
        this.setBrowseIconId(this.getConfiguredBrowseIconId());
        this.setBrowseLoadIncremental(this.getConfiguredBrowseLoadIncremental());
        this.setIconId(this.getConfiguredIconId());
        this.setBrowseMaxRowCount(this.getConfiguredBrowseMaxRowCount());
        this.setBrowseNewText(this.getConfiguredBrowseNewText());
        this.setProposalFormProvider(this.createProposalFormProvider());
        this.setProposalFormHeight(this.getConfiguredProposalFormHeight());
        Class contentAssistTableClazz = this.getConfiguredContentAssistTable();
        if (contentAssistTableClazz == null) {
            Class[] dca = ConfigurationUtility.getDeclaredPublicClasses(this.getClass());
            contentAssistTableClazz = ConfigurationUtility.filterClass((Class[])dca, IContentAssistFieldTable.class);
        }
        if (contentAssistTableClazz == null) {
            contentAssistTableClazz = ContentAssistFieldTable.class;
        }
        this.setContentAssistTableClass(contentAssistTableClazz);
        IContentAssistFieldLookupRowFetcher<LOOKUP_KEY> lookupRowFetcher = this.createLookupRowFetcher();
        lookupRowFetcher.addPropertyChangeListener(new P_LookupRowFetcherPropertyListener());
        this.setLookupRowFetcher(lookupRowFetcher);
        if (this.getConfiguredCodeType() != null) {
            this.setCodeTypeClass(this.getConfiguredCodeType());
        }
        if ((lsCls = this.getConfiguredLookupCall()) != null) {
            try {
                ILookupCall<LOOKUP_KEY> call = lsCls.newInstance();
                this.setLookupCall(call);
            }
            catch (Exception e) {
                ((IExceptionHandlerService)SERVICES.getService(IExceptionHandlerService.class)).handleException(new ProcessingException("error creating instance of class '" + lsCls.getName() + "'.", (Throwable)e));
            }
        }
    }

    @Override
    public void addSmartFieldListener(ContentAssistFieldListener listener) {
        this.m_listenerList.add(ContentAssistFieldListener.class, (EventListener)listener);
    }

    @Override
    public void removeSmartFieldListener(ContentAssistFieldListener listener) {
        this.m_listenerList.remove(ContentAssistFieldListener.class, (EventListener)listener);
    }

    private void fireSmartFieldEvent(ContentAssistFieldEvent e) {
        EventListener[] listeners = this.m_listenerList.getListeners(ContentAssistFieldListener.class);
        if (listeners != null && listeners.length > 0) {
            int i = 0;
            while (i < listeners.length) {
                ((ContentAssistFieldListener)listeners[i]).fieldChanged(e);
                ++i;
            }
        }
    }

    @Override
    public boolean isActiveFilterEnabled() {
        return this.m_activeFilterEnabled;
    }

    @Override
    public void setActiveFilterEnabled(boolean b) {
        this.m_activeFilterEnabled = b;
    }

    @Override
    public TriState getActiveFilter() {
        return this.m_activeFilter;
    }

    @Override
    public void setActiveFilter(TriState t) {
        if (this.isActiveFilterEnabled()) {
            if (t == null) {
                t = TriState.TRUE;
            }
            this.m_activeFilter = t;
        }
    }

    @Override
    public void setProposalFormHeight(int proposalFormHeight) {
        this.m_proposalFormHeight = proposalFormHeight;
    }

    @Override
    public int getProposalFormHeight() {
        return this.m_proposalFormHeight;
    }

    private void setContentAssistTableClass(Class<? extends IContentAssistFieldTable<VALUE>> configuredContentAssistTableClass) {
        this.m_contentAssistTableClazz = configuredContentAssistTableClass;
    }

    @Override
    public Class<? extends IContentAssistFieldTable<VALUE>> getContentAssistFieldTableClass() {
        return this.m_contentAssistTableClazz;
    }

    @Override
    public void doBrowseNew(String newText) {
        if (this.getBrowseNewText() != null) {
            try {
                ILookupRow<LOOKUP_KEY> newRow = this.interceptBrowseNew(newText);
                if (newRow != null) {
                    this.acceptProposal(newRow);
                }
            }
            catch (ProcessingException e) {
                ((IExceptionHandlerService)SERVICES.getService(IExceptionHandlerService.class)).handleException(e);
            }
            catch (Throwable t) {
                ((IExceptionHandlerService)SERVICES.getService(IExceptionHandlerService.class)).handleException(new ProcessingException("Unexpected", t));
            }
        }
    }

    @Override
    public String getBrowseIconId() {
        return this.propertySupport.getPropertyString("browseIconId");
    }

    @Override
    public void setBrowseIconId(String s) {
        this.propertySupport.setPropertyString("browseIconId", s);
    }

    @Override
    public String getIconId() {
        return this.propertySupport.getPropertyString("iconId");
    }

    @Override
    public void setIconId(String s) {
        this.propertySupport.setPropertyString("iconId", s);
    }

    @Override
    public boolean isBrowseAutoExpandAll() {
        return this.m_browseAutoExpandAll;
    }

    @Override
    public void setBrowseAutoExpandAll(boolean b) {
        this.m_browseAutoExpandAll = b;
    }

    @Override
    public boolean isBrowseLoadIncremental() {
        return this.m_loadIncremental;
    }

    @Override
    public void setBrowseLoadIncremental(boolean b) {
        this.m_loadIncremental = b;
    }

    @Override
    public boolean isBrowseHierarchy() {
        return this.m_browseHierarchy;
    }

    @Override
    public void setBrowseHierarchy(boolean b) {
        this.m_browseHierarchy = b;
    }

    @Override
    public int getBrowseMaxRowCount() {
        return this.m_maxRowCount;
    }

    @Override
    public void setBrowseMaxRowCount(int n) {
        this.m_maxRowCount = n;
    }

    @Override
    public String getBrowseNewText() {
        return this.m_browseNewText;
    }

    @Override
    public void setBrowseNewText(String s) {
        this.m_browseNewText = s;
    }

    @Override
    public Class<? extends ICodeType<?, LOOKUP_KEY>> getCodeTypeClass() {
        return this.m_codeTypeClass;
    }

    @Override
    public void setCodeTypeClass(Class<? extends ICodeType<?, LOOKUP_KEY>> codeType) {
        this.m_codeTypeClass = codeType;
        this.m_lookupCall = null;
        if (this.m_codeTypeClass != null) {
            this.m_lookupCall = CodeLookupCall.newInstanceByService(this.m_codeTypeClass);
            ICodeType t = CODES.getCodeType(this.m_codeTypeClass);
            if (t != null && !ConfigurationUtility.isMethodOverwrite(AbstractContentAssistField.class, (String)"getConfiguredBrowseHierarchy", (Class[])new Class[0], this.getClass())) {
                this.setBrowseHierarchy(t.isHierarchy());
            }
        }
    }

    @Override
    public ILookupCall<LOOKUP_KEY> getLookupCall() {
        return this.m_lookupCall;
    }

    @Override
    public void setLookupCall(ILookupCall<LOOKUP_KEY> call) {
        this.m_lookupCall = call;
    }

    @Override
    public void setUniquelyDefinedValue(boolean background) throws ProcessingException {
        ILookupCallFetcher fetcher = new ILookupCallFetcher<LOOKUP_KEY>(){

            public void dataFetched(List<? extends ILookupRow<LOOKUP_KEY>> rows, ProcessingException failed) {
                if (failed == null && rows.size() == 1) {
                    AbstractContentAssistField.this.acceptProposal(rows.get(0));
                }
            }
        };
        if (background) {
            this.callBrowseLookupInBackground("*", 2, fetcher);
        } else {
            fetcher.dataFetched(this.callBrowseLookup("*", 2), null);
        }
    }

    @Override
    public IContentAssistFieldProposalForm<LOOKUP_KEY> getProposalForm() {
        return (IContentAssistFieldProposalForm)this.propertySupport.getProperty("proposalForm");
    }

    protected void registerProposalFormInternal(IContentAssistFieldProposalForm<LOOKUP_KEY> form) {
        IContentAssistFieldProposalForm<LOOKUP_KEY> oldForm = this.getProposalForm();
        if (oldForm == form) {
            return;
        }
        if (oldForm != null) {
            if (this.m_proposalFormListener != null) {
                oldForm.removeFormListener(this.m_proposalFormListener);
                this.m_proposalFormListener = null;
            }
            try {
                oldForm.doClose();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (form != null) {
            if (this.m_proposalFormListener == null) {
                this.m_proposalFormListener = new P_ProposalFormListener();
            }
            form.addFormListener(this.m_proposalFormListener);
        }
        this.propertySupport.setProperty("proposalForm", form);
    }

    protected void unregisterProposalFormInternal(IContentAssistFieldProposalForm form) {
        if (form != null) {
            IContentAssistFieldProposalForm<LOOKUP_KEY> oldForm = this.getProposalForm();
            if (oldForm == form) {
                this.propertySupport.setProperty("proposalForm", null);
            }
            if (form.isFormOpen()) {
                try {
                    form.doClose();
                }
                catch (ProcessingException processingException) {
                    // empty catch block
                }
            }
        }
    }

    @Override
    public IContentAssistFieldProposalFormProvider<LOOKUP_KEY> getProposalFormProvider() {
        return this.m_proposalFormProvider;
    }

    @Override
    public void setProposalFormProvider(IContentAssistFieldProposalFormProvider<LOOKUP_KEY> provider) {
        this.m_proposalFormProvider = provider;
    }

    protected abstract IContentAssistFieldProposalForm<LOOKUP_KEY> createProposalForm() throws ProcessingException;

    public IContentAssistFieldLookupRowFetcher<LOOKUP_KEY> getLookupRowFetcher() {
        return this.m_lookupRowFetcher;
    }

    public void setLookupRowFetcher(IContentAssistFieldLookupRowFetcher<LOOKUP_KEY> fetcher) {
        this.m_lookupRowFetcher = fetcher;
    }

    protected IContentAssistFieldProposalForm<LOOKUP_KEY> createProposalForm(boolean allowCustomText) throws ProcessingException {
        IContentAssistFieldProposalFormProvider<LOOKUP_KEY> proposalFormProvider = this.getProposalFormProvider();
        if (proposalFormProvider == null) {
            return null;
        }
        return proposalFormProvider.createProposalForm(this, allowCustomText);
    }

    protected IContentAssistFieldProposalFormProvider<LOOKUP_KEY> createProposalFormProvider() {
        return new DefaultContentAssistFieldProposalFormProvider();
    }

    protected boolean isCurrentLookupRowValid(VALUE validKey) {
        if (this.getCurrentLookupRow() == null) {
            return true;
        }
        return validKey == this.getCurrentLookupRow().getKey() || validKey != null && validKey.equals(this.getCurrentLookupRow().getKey());
    }

    @Override
    protected final VALUE execValidateValue(VALUE rawValue) throws ProcessingException {
        return rawValue;
    }

    @Override
    protected VALUE validateValueInternal(VALUE rawKey) throws ProcessingException {
        if (rawKey instanceof Number) {
            if (this.getConfiguredTreat0AsNull() && ((Number)rawKey).longValue() == 0L) {
                rawKey = null;
            }
        } else if (rawKey instanceof String && this.getConfiguredTreat0AsNull() && ((String)rawKey).length() == 0) {
            rawKey = null;
        }
        return super.validateValueInternal(rawKey);
    }

    @Override
    public void revertValue() {
        this.setValue(this.getValue());
    }

    protected void installLookupRowContext(ILookupRow<LOOKUP_KEY> row) {
        try {
            this.m_installingRowContext = true;
            String text = row.getText();
            if (text != null) {
                text = text.replaceAll("[\\n\\r]+", " ");
            }
            this.setDisplayText(text);
            if (StringUtility.hasText((CharSequence)row.getTooltipText())) {
                this.setTooltipText(row.getTooltipText());
            } else {
                this.setTooltipText(this.m_decorationRow.getTooltipText());
            }
            if (StringUtility.hasText((CharSequence)row.getBackgroundColor())) {
                this.setBackgroundColor(row.getBackgroundColor());
            } else {
                this.setBackgroundColor(this.m_decorationRow.getBackgroundColor());
            }
            if (StringUtility.hasText((CharSequence)row.getForegroundColor())) {
                this.setForegroundColor(row.getForegroundColor());
            } else {
                this.setForegroundColor(this.m_decorationRow.getForegroundColor());
            }
            if (row.getFont() != null) {
                this.setFont(row.getFont());
            } else {
                this.setFont(this.m_decorationRow.getFont());
            }
        }
        finally {
            this.m_installingRowContext = false;
        }
    }

    @Override
    public String getDisplayText() {
        this.applyLazyStyles();
        return super.getDisplayText();
    }

    @Override
    public String getTooltipText() {
        this.applyLazyStyles();
        return super.getTooltipText();
    }

    @Override
    public String getBackgroundColor() {
        this.applyLazyStyles();
        return super.getBackgroundColor();
    }

    @Override
    public String getForegroundColor() {
        this.applyLazyStyles();
        return super.getForegroundColor();
    }

    @Override
    public FontSpec getFont() {
        this.applyLazyStyles();
        return super.getFont();
    }

    @Override
    public void doSearch(boolean selectCurrentValue, boolean synchronous) {
        this.doSearch(this.getLookupRowFetcher().getLastSearchText(), selectCurrentValue, synchronous);
    }

    @Override
    public void doSearch(String searchText, boolean selectCurrentValue, boolean synchronous) {
        IContentAssistFieldProposalForm<LOOKUP_KEY> proposalForm = this.getProposalForm();
        if (proposalForm != null) {
            proposalForm.setTablePopulateStatus((IProcessingStatus)new ProcessingStatus(ScoutTexts.get((String)"searchingProposals", (String[])new String[0]), 2));
        }
        this.getLookupRowFetcher().update(searchText, selectCurrentValue, synchronous);
    }

    public void setCurrentLookupRow(ILookupRow<LOOKUP_KEY> row) {
        this.m_currentLookupRow = row;
    }

    public ILookupRow<LOOKUP_KEY> getCurrentLookupRow() {
        return this.m_currentLookupRow;
    }

    @Override
    public void prepareKeyLookup(ILookupCall<LOOKUP_KEY> call, LOOKUP_KEY key) throws ProcessingException {
        call.setKey(key);
        call.setText(null);
        call.setAll(null);
        call.setRec(null);
        call.setActive(TriState.UNDEFINED);
        if (this.getMasterValue() != null || this.getLookupCall() == null || this.getLookupCall().getMaster() == null) {
            call.setMaster(this.getMasterValue());
        }
        this.interceptPrepareLookup(call);
        this.interceptPrepareKeyLookup(call, key);
    }

    @Override
    public void prepareTextLookup(ILookupCall<LOOKUP_KEY> call, String text) throws ProcessingException {
        String textPattern = text;
        if (textPattern == null) {
            textPattern = "";
        }
        textPattern = textPattern.toLowerCase();
        IDesktop desktop = ClientSyncJob.getCurrentSession().getDesktop();
        if (desktop != null && desktop.isAutoPrefixWildcardForTextSearch()) {
            textPattern = "*" + textPattern;
        }
        if (!textPattern.endsWith("*")) {
            textPattern = String.valueOf(textPattern) + "*";
        }
        call.setKey(null);
        call.setText(textPattern);
        call.setAll(null);
        call.setRec(null);
        call.setActive(this.isActiveFilterEnabled() ? this.getActiveFilter() : TriState.TRUE);
        if (this.getMasterValue() != null || this.getLookupCall() == null || this.getLookupCall().getMaster() == null) {
            call.setMaster(this.getMasterValue());
        }
        this.interceptPrepareLookup(call);
        this.interceptPrepareTextLookup(call, text);
    }

    @Override
    public void prepareBrowseLookup(ILookupCall<LOOKUP_KEY> call, String browseHint, TriState activeState) throws ProcessingException {
        call.setKey(null);
        call.setText(null);
        call.setAll(browseHint);
        call.setRec(null);
        call.setActive(activeState);
        if (this.getMasterValue() != null || this.getLookupCall() == null || this.getLookupCall().getMaster() == null) {
            call.setMaster(this.getMasterValue());
        }
        this.interceptPrepareLookup(call);
        this.interceptPrepareBrowseLookup(call, browseHint);
    }

    @Override
    public void prepareRecLookup(ILookupCall<LOOKUP_KEY> call, LOOKUP_KEY parentKey, TriState activeState) throws ProcessingException {
        call.setKey(null);
        call.setText(null);
        call.setAll(null);
        call.setRec(parentKey);
        if (this.getMasterValue() != null || this.getLookupCall() == null || this.getLookupCall().getMaster() == null) {
            call.setMaster(this.getMasterValue());
        }
        call.setActive(activeState);
        this.interceptPrepareLookup(call);
        this.interceptPrepareRecLookup(call, parentKey);
    }

    protected void filterKeyLookup(ILookupCall<LOOKUP_KEY> call, List<ILookupRow<LOOKUP_KEY>> result) throws ProcessingException {
        this.interceptFilterLookupResult(call, result);
        this.interceptFilterKeyLookupResult(call, result);
    }

    private void filterTextLookup(ILookupCall<LOOKUP_KEY> call, List<ILookupRow<LOOKUP_KEY>> result) throws ProcessingException {
        this.interceptFilterLookupResult(call, result);
        this.interceptFilterTextLookupResult(call, result);
    }

    private void filterBrowseLookup(ILookupCall<LOOKUP_KEY> call, List<ILookupRow<LOOKUP_KEY>> result) throws ProcessingException {
        this.interceptFilterLookupResult(call, result);
        this.interceptFilterBrowseLookupResult(call, result);
    }

    private void filterRecLookup(ILookupCall<LOOKUP_KEY> call, List<ILookupRow<LOOKUP_KEY>> result) throws ProcessingException {
        this.interceptFilterLookupResult(call, result);
        this.interceptFilterRecLookupResult(call, result);
    }

    @Override
    public List<? extends ILookupRow<LOOKUP_KEY>> callKeyLookup(LOOKUP_KEY key) throws ProcessingException {
        List data = null;
        ILookupCall<LOOKUP_KEY> call = this.getLookupCall();
        if (call != null) {
            call = ((ILookupCallProvisioningService)SERVICES.getService(ILookupCallProvisioningService.class)).newClonedInstance(call, new FormFieldProvisioningContext(this));
            this.prepareKeyLookup(call, key);
            data = call.getDataByKey();
        }
        ArrayList result = CollectionUtility.arrayList(data);
        this.filterKeyLookup(call, result);
        return this.cleanupResultList(result);
    }

    @Override
    public List<? extends ILookupRow<LOOKUP_KEY>> callTextLookup(String text, int maxRowCount) throws ProcessingException {
        final Holder rowsHolder = new Holder();
        final Holder failedHolder = new Holder(ProcessingException.class, (Object)new ProcessingException("callback was not invoked"));
        this.callTextLookupInternal(text, maxRowCount, new ILookupCallFetcher<LOOKUP_KEY>(){

            public void dataFetched(List<? extends ILookupRow<LOOKUP_KEY>> rows, ProcessingException failed) {
                rowsHolder.setValue(rows);
                failedHolder.setValue((Object)failed);
            }
        }, false);
        if (failedHolder.getValue() != null) {
            throw (ProcessingException)((Object)failedHolder.getValue());
        }
        return (List)rowsHolder.getValue();
    }

    @Override
    public JobEx callTextLookupInBackground(String text, int maxRowCount, ILookupCallFetcher<LOOKUP_KEY> fetcher) {
        return this.callTextLookupInternal(text, maxRowCount, fetcher, true);
    }

    private JobEx callTextLookupInternal(String text, int maxRowCount, final ILookupCallFetcher<LOOKUP_KEY> fetcher, final boolean background) {
        final ILookupCall<LOOKUP_KEY> call = this.getLookupCall() != null ? ((ILookupCallProvisioningService)SERVICES.getService(ILookupCallProvisioningService.class)).newClonedInstance(this.getLookupCall(), new FormFieldProvisioningContext(this)) : null;
        final IClientSession session = ClientSyncJob.getCurrentSession();
        ILookupCallFetcher internalFetcher = new ILookupCallFetcher<LOOKUP_KEY>(){

            public void dataFetched(final List<? extends ILookupRow<LOOKUP_KEY>> rows, final ProcessingException failed) {
                ClientSyncJob scoutSyncJob = new ClientSyncJob("Smartfield text lookup", session){

                    @Override
                    protected void runVoid(IProgressMonitor monitor) throws Throwable {
                        if (failed == null) {
                            ArrayList result = new ArrayList(rows);
                            try {
                                AbstractContentAssistField.this.filterTextLookup(call, result);
                                fetcher.dataFetched(AbstractContentAssistField.this.cleanupResultList(result), null);
                            }
                            catch (ProcessingException e) {
                                fetcher.dataFetched(null, e);
                            }
                        } else {
                            fetcher.dataFetched(null, failed);
                        }
                    }
                };
                if (background) {
                    scoutSyncJob.schedule();
                } else {
                    scoutSyncJob.runNow((IProgressMonitor)new NullProgressMonitor());
                }
            }
        };
        if (call != null) {
            if (maxRowCount > 0) {
                call.setMaxRowCount(maxRowCount);
            } else {
                call.setMaxRowCount(this.getBrowseMaxRowCount());
            }
            if (background) {
                try {
                    this.prepareTextLookup(call, text);
                    return call.getDataByTextInBackground(internalFetcher);
                }
                catch (ProcessingException e1) {
                    internalFetcher.dataFetched(null, e1);
                }
            } else {
                try {
                    this.prepareTextLookup(call, text);
                    internalFetcher.dataFetched(call.getDataByText(), null);
                }
                catch (ProcessingException e) {
                    internalFetcher.dataFetched(null, e);
                }
            }
        } else {
            internalFetcher.dataFetched(new ArrayList(), null);
        }
        return null;
    }

    @Override
    public List<? extends ILookupRow<LOOKUP_KEY>> callBrowseLookup(String browseHint, int maxRowCount) throws ProcessingException {
        return this.callBrowseLookup(browseHint, maxRowCount, this.isActiveFilterEnabled() ? this.getActiveFilter() : TriState.TRUE);
    }

    @Override
    public List<? extends ILookupRow<LOOKUP_KEY>> callBrowseLookup(String browseHint, int maxRowCount, TriState activeState) throws ProcessingException {
        final Holder rowsHolder = new Holder();
        final Holder failedHolder = new Holder(ProcessingException.class, (Object)new ProcessingException("callback was not invoked"));
        this.callBrowseLookupInternal(browseHint, maxRowCount, activeState, new ILookupCallFetcher<LOOKUP_KEY>(){

            public void dataFetched(List<? extends ILookupRow<LOOKUP_KEY>> rows, ProcessingException failed) {
                rowsHolder.setValue(rows);
                failedHolder.setValue((Object)failed);
            }
        }, false);
        if (failedHolder.getValue() != null) {
            throw (ProcessingException)((Object)failedHolder.getValue());
        }
        return (List)rowsHolder.getValue();
    }

    @Override
    public JobEx callBrowseLookupInBackground(String browseHint, int maxRowCount, ILookupCallFetcher<LOOKUP_KEY> fetcher) {
        return this.callBrowseLookupInBackground(browseHint, maxRowCount, this.isActiveFilterEnabled() ? this.getActiveFilter() : TriState.TRUE, fetcher);
    }

    @Override
    public JobEx callBrowseLookupInBackground(String browseHint, int maxRowCount, TriState activeState, ILookupCallFetcher<LOOKUP_KEY> fetcher) {
        return this.callBrowseLookupInternal(browseHint, maxRowCount, activeState, fetcher, true);
    }

    private JobEx callBrowseLookupInternal(String browseHint, int maxRowCount, TriState activeState, final ILookupCallFetcher<LOOKUP_KEY> fetcher, final boolean background) {
        final ILookupCall<LOOKUP_KEY> call = this.getLookupCall() != null ? ((ILookupCallProvisioningService)SERVICES.getService(ILookupCallProvisioningService.class)).newClonedInstance(this.getLookupCall(), new FormFieldProvisioningContext(this)) : null;
        final IClientSession session = ClientSyncJob.getCurrentSession();
        ILookupCallFetcher internalFetcher = new ILookupCallFetcher<LOOKUP_KEY>(){

            public void dataFetched(final List<? extends ILookupRow<LOOKUP_KEY>> rows, final ProcessingException failed) {
                ClientSyncJob scoutSyncJob = new ClientSyncJob("ContentAssistField browse lookup", session){

                    @Override
                    protected void runVoid(IProgressMonitor monitor) throws Throwable {
                        if (failed == null) {
                            ArrayList result = new ArrayList(rows);
                            try {
                                AbstractContentAssistField.this.filterBrowseLookup(call, result);
                                fetcher.dataFetched(AbstractContentAssistField.this.cleanupResultList(result), null);
                            }
                            catch (ProcessingException e) {
                                fetcher.dataFetched(null, e);
                            }
                        } else {
                            fetcher.dataFetched(null, failed);
                        }
                    }
                };
                if (background) {
                    scoutSyncJob.schedule();
                } else {
                    scoutSyncJob.runNow((IProgressMonitor)new NullProgressMonitor());
                }
            }
        };
        if (call != null) {
            if (maxRowCount > 0) {
                call.setMaxRowCount(maxRowCount);
            } else {
                call.setMaxRowCount(this.getBrowseMaxRowCount());
            }
            if (background) {
                try {
                    this.prepareBrowseLookup(call, browseHint, activeState);
                    return call.getDataByAllInBackground(internalFetcher);
                }
                catch (ProcessingException e1) {
                    internalFetcher.dataFetched(null, e1);
                }
            } else {
                try {
                    this.prepareBrowseLookup(call, browseHint, activeState);
                    internalFetcher.dataFetched(call.getDataByAll(), null);
                }
                catch (ProcessingException e) {
                    internalFetcher.dataFetched(null, e);
                }
            }
        } else {
            internalFetcher.dataFetched(new ArrayList(), null);
        }
        return null;
    }

    @Override
    public List<ILookupRow<LOOKUP_KEY>> callSubTreeLookup(LOOKUP_KEY parentKey) throws ProcessingException {
        return this.callSubTreeLookup(parentKey, this.isActiveFilterEnabled() ? this.getActiveFilter() : TriState.TRUE);
    }

    @Override
    public List<ILookupRow<LOOKUP_KEY>> callSubTreeLookup(LOOKUP_KEY parentKey, TriState activeState) throws ProcessingException {
        List data = null;
        ILookupCall<LOOKUP_KEY> call = this.getLookupCall();
        if (call != null) {
            call = ((ILookupCallProvisioningService)SERVICES.getService(ILookupCallProvisioningService.class)).newClonedInstance(call, new FormFieldProvisioningContext(this));
            call.setMaxRowCount(this.getBrowseMaxRowCount());
            this.prepareRecLookup(call, parentKey, activeState);
            data = call.getDataByRec();
        }
        ArrayList<Object> result = data != null ? new ArrayList<ILookupRow<LOOKUP_KEY>>(data) : new ArrayList(0);
        this.filterRecLookup(call, result);
        return this.cleanupResultList(result);
    }

    protected List<ILookupRow<LOOKUP_KEY>> cleanupResultList(List<ILookupRow<LOOKUP_KEY>> list) {
        ArrayList<ILookupRow<LOOKUP_KEY>> rows = new ArrayList<ILookupRow<LOOKUP_KEY>>();
        for (ILookupRow<LOOKUP_KEY> r : list) {
            if (r == null) continue;
            rows.add(r);
        }
        return rows;
    }

    protected abstract void handleProposalFormClosed(IContentAssistFieldProposalForm<LOOKUP_KEY> var1) throws ProcessingException;

    protected abstract void handleFetchResult(IContentAssistFieldDataFetchResult<LOOKUP_KEY> var1);

    protected IContentAssistFieldLookupRowFetcher<LOOKUP_KEY> createLookupRowFetcher() {
        if (this.isBrowseHierarchy()) {
            return new HierachycalContentAssistDataFetcher(this);
        }
        return new ContentAssistFieldDataFetcher(this);
    }

    @Override
    protected IContentAssistFieldExtension<VALUE, LOOKUP_KEY, ? extends AbstractContentAssistField<VALUE, LOOKUP_KEY>> createLocalExtension() {
        return new LocalContentAssistFieldExtension(this);
    }

    protected final void interceptFilterBrowseLookupResult(ILookupCall<LOOKUP_KEY> call, List<ILookupRow<LOOKUP_KEY>> result) throws ProcessingException {
        List<? extends IFormFieldExtension<? extends AbstractFormField>> extensions = this.getAllExtensions();
        ContentAssistFieldChains.ContentAssistFieldFilterBrowseLookupResultChain chain = new ContentAssistFieldChains.ContentAssistFieldFilterBrowseLookupResultChain(extensions);
        chain.execFilterBrowseLookupResult(call, result);
    }

    protected final ILookupRow<LOOKUP_KEY> interceptBrowseNew(String searchText) throws ProcessingException {
        List<? extends IFormFieldExtension<? extends AbstractFormField>> extensions = this.getAllExtensions();
        ContentAssistFieldChains.ContentAssistFieldBrowseNewChain chain = new ContentAssistFieldChains.ContentAssistFieldBrowseNewChain(extensions);
        return chain.execBrowseNew(searchText);
    }

    protected final void interceptFilterKeyLookupResult(ILookupCall<LOOKUP_KEY> call, List<ILookupRow<LOOKUP_KEY>> result) throws ProcessingException {
        List<? extends IFormFieldExtension<? extends AbstractFormField>> extensions = this.getAllExtensions();
        ContentAssistFieldChains.ContentAssistFieldFilterKeyLookupResultChain chain = new ContentAssistFieldChains.ContentAssistFieldFilterKeyLookupResultChain(extensions);
        chain.execFilterKeyLookupResult(call, result);
    }

    protected final void interceptPrepareLookup(ILookupCall<LOOKUP_KEY> call) throws ProcessingException {
        List<? extends IFormFieldExtension<? extends AbstractFormField>> extensions = this.getAllExtensions();
        ContentAssistFieldChains.ContentAssistFieldPrepareLookupChain chain = new ContentAssistFieldChains.ContentAssistFieldPrepareLookupChain(extensions);
        chain.execPrepareLookup(call);
    }

    protected final void interceptPrepareTextLookup(ILookupCall<LOOKUP_KEY> call, String text) throws ProcessingException {
        List<? extends IFormFieldExtension<? extends AbstractFormField>> extensions = this.getAllExtensions();
        ContentAssistFieldChains.ContentAssistFieldPrepareTextLookupChain chain = new ContentAssistFieldChains.ContentAssistFieldPrepareTextLookupChain(extensions);
        chain.execPrepareTextLookup(call, text);
    }

    protected final void interceptPrepareBrowseLookup(ILookupCall<LOOKUP_KEY> call, String browseHint) throws ProcessingException {
        List<? extends IFormFieldExtension<? extends AbstractFormField>> extensions = this.getAllExtensions();
        ContentAssistFieldChains.ContentAssistFieldPrepareBrowseLookupChain chain = new ContentAssistFieldChains.ContentAssistFieldPrepareBrowseLookupChain(extensions);
        chain.execPrepareBrowseLookup(call, browseHint);
    }

    protected final void interceptFilterTextLookupResult(ILookupCall<LOOKUP_KEY> call, List<ILookupRow<LOOKUP_KEY>> result) throws ProcessingException {
        List<? extends IFormFieldExtension<? extends AbstractFormField>> extensions = this.getAllExtensions();
        ContentAssistFieldChains.ContentAssistFieldFilterTextLookupResultChain chain = new ContentAssistFieldChains.ContentAssistFieldFilterTextLookupResultChain(extensions);
        chain.execFilterTextLookupResult(call, result);
    }

    protected final void interceptPrepareRecLookup(ILookupCall<LOOKUP_KEY> call, LOOKUP_KEY parentKey) throws ProcessingException {
        List<? extends IFormFieldExtension<? extends AbstractFormField>> extensions = this.getAllExtensions();
        ContentAssistFieldChains.ContentAssistFieldPrepareRecLookupChain chain = new ContentAssistFieldChains.ContentAssistFieldPrepareRecLookupChain(extensions);
        chain.execPrepareRecLookup(call, parentKey);
    }

    protected final void interceptFilterLookupResult(ILookupCall<LOOKUP_KEY> call, List<ILookupRow<LOOKUP_KEY>> result) throws ProcessingException {
        List<? extends IFormFieldExtension<? extends AbstractFormField>> extensions = this.getAllExtensions();
        ContentAssistFieldChains.ContentAssistFieldFilterLookupResultChain chain = new ContentAssistFieldChains.ContentAssistFieldFilterLookupResultChain(extensions);
        chain.execFilterLookupResult(call, result);
    }

    protected final void interceptFilterRecLookupResult(ILookupCall<LOOKUP_KEY> call, List<ILookupRow<LOOKUP_KEY>> result) throws ProcessingException {
        List<? extends IFormFieldExtension<? extends AbstractFormField>> extensions = this.getAllExtensions();
        ContentAssistFieldChains.ContentAssistFieldFilterRecLookupResultChain chain = new ContentAssistFieldChains.ContentAssistFieldFilterRecLookupResultChain(extensions);
        chain.execFilterRecLookupResult(call, result);
    }

    protected final void interceptPrepareKeyLookup(ILookupCall<LOOKUP_KEY> call, LOOKUP_KEY key) throws ProcessingException {
        List<? extends IFormFieldExtension<? extends AbstractFormField>> extensions = this.getAllExtensions();
        ContentAssistFieldChains.ContentAssistFieldPrepareKeyLookupChain chain = new ContentAssistFieldChains.ContentAssistFieldPrepareKeyLookupChain(extensions);
        chain.execPrepareKeyLookup(call, key);
    }

    protected static class LocalContentAssistFieldExtension<VALUE, LOOKUP_KEY, OWNER extends AbstractContentAssistField<VALUE, LOOKUP_KEY>>
    extends AbstractValueField.LocalValueFieldExtension<VALUE, OWNER>
    implements IContentAssistFieldExtension<VALUE, LOOKUP_KEY, OWNER> {
        public LocalContentAssistFieldExtension(OWNER owner) {
            super(owner);
        }

        @Override
        public void execFilterBrowseLookupResult(ContentAssistFieldChains.ContentAssistFieldFilterBrowseLookupResultChain<VALUE, LOOKUP_KEY> chain, ILookupCall<LOOKUP_KEY> call, List<ILookupRow<LOOKUP_KEY>> result) throws ProcessingException {
            ((AbstractContentAssistField)this.getOwner()).execFilterBrowseLookupResult(call, result);
        }

        @Override
        public ILookupRow<LOOKUP_KEY> execBrowseNew(ContentAssistFieldChains.ContentAssistFieldBrowseNewChain<VALUE, LOOKUP_KEY> chain, String searchText) throws ProcessingException {
            return ((AbstractContentAssistField)this.getOwner()).execBrowseNew(searchText);
        }

        @Override
        public void execFilterKeyLookupResult(ContentAssistFieldChains.ContentAssistFieldFilterKeyLookupResultChain<VALUE, LOOKUP_KEY> chain, ILookupCall<LOOKUP_KEY> call, List<ILookupRow<LOOKUP_KEY>> result) throws ProcessingException {
            ((AbstractContentAssistField)this.getOwner()).execFilterKeyLookupResult(call, result);
        }

        @Override
        public void execPrepareLookup(ContentAssistFieldChains.ContentAssistFieldPrepareLookupChain<VALUE, LOOKUP_KEY> chain, ILookupCall<LOOKUP_KEY> call) throws ProcessingException {
            ((AbstractContentAssistField)this.getOwner()).execPrepareLookup(call);
        }

        @Override
        public void execPrepareTextLookup(ContentAssistFieldChains.ContentAssistFieldPrepareTextLookupChain<VALUE, LOOKUP_KEY> chain, ILookupCall<LOOKUP_KEY> call, String text) throws ProcessingException {
            ((AbstractContentAssistField)this.getOwner()).execPrepareTextLookup(call, text);
        }

        @Override
        public void execPrepareBrowseLookup(ContentAssistFieldChains.ContentAssistFieldPrepareBrowseLookupChain<VALUE, LOOKUP_KEY> chain, ILookupCall<LOOKUP_KEY> call, String browseHint) throws ProcessingException {
            ((AbstractContentAssistField)this.getOwner()).execPrepareBrowseLookup(call, browseHint);
        }

        @Override
        public void execFilterTextLookupResult(ContentAssistFieldChains.ContentAssistFieldFilterTextLookupResultChain<VALUE, LOOKUP_KEY> chain, ILookupCall<LOOKUP_KEY> call, List<ILookupRow<LOOKUP_KEY>> result) throws ProcessingException {
            ((AbstractContentAssistField)this.getOwner()).execFilterTextLookupResult(call, result);
        }

        @Override
        public void execPrepareRecLookup(ContentAssistFieldChains.ContentAssistFieldPrepareRecLookupChain<VALUE, LOOKUP_KEY> chain, ILookupCall<LOOKUP_KEY> call, LOOKUP_KEY parentKey) throws ProcessingException {
            ((AbstractContentAssistField)this.getOwner()).execPrepareRecLookup(call, parentKey);
        }

        @Override
        public void execFilterLookupResult(ContentAssistFieldChains.ContentAssistFieldFilterLookupResultChain<VALUE, LOOKUP_KEY> chain, ILookupCall<LOOKUP_KEY> call, List<ILookupRow<LOOKUP_KEY>> result) throws ProcessingException {
            ((AbstractContentAssistField)this.getOwner()).execFilterLookupResult(call, result);
        }

        @Override
        public void execFilterRecLookupResult(ContentAssistFieldChains.ContentAssistFieldFilterRecLookupResultChain<VALUE, LOOKUP_KEY> chain, ILookupCall<LOOKUP_KEY> call, List<ILookupRow<LOOKUP_KEY>> result) throws ProcessingException {
            ((AbstractContentAssistField)this.getOwner()).execFilterRecLookupResult(call, result);
        }

        @Override
        public void execPrepareKeyLookup(ContentAssistFieldChains.ContentAssistFieldPrepareKeyLookupChain<VALUE, LOOKUP_KEY> chain, ILookupCall<LOOKUP_KEY> call, LOOKUP_KEY key) throws ProcessingException {
            ((AbstractContentAssistField)this.getOwner()).execPrepareKeyLookup(call, key);
        }
    }

    private class P_LookupRowFetcherPropertyListener
    implements PropertyChangeListener {
        private P_LookupRowFetcherPropertyListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if ("searchResult".equals(evt.getPropertyName())) {
                AbstractContentAssistField.this.handleFetchResult((IContentAssistFieldDataFetchResult)evt.getNewValue());
            }
        }
    }

    private class P_ProposalFormListener
    implements FormListener {
        private P_ProposalFormListener() {
        }

        @Override
        public void formChanged(FormEvent e) throws ProcessingException {
            switch (e.getType()) {
                case 3010: {
                    AbstractContentAssistField.this.handleProposalFormClosed((IContentAssistFieldProposalForm)e.getForm());
                }
            }
        }
    }
}

