/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.server.admin.diagnostic;

import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.core.runtime.IProduct;
import org.eclipse.core.runtime.Platform;
import org.eclipse.scout.commons.CollectionUtility;
import org.eclipse.scout.commons.CompareUtility;
import org.eclipse.scout.commons.LocaleThreadLocal;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.rt.server.admin.diagnostic.DiagnosticFactory;
import org.eclipse.scout.rt.server.admin.diagnostic.IDiagnostic;
import org.eclipse.scout.rt.shared.OfficialVersion;
import org.osgi.framework.Version;

public class DiagnosticSession {
    public void serviceRequest(HttpServletRequest req, HttpServletResponse res) throws IOException {
        String format;
        if (!req.getParameterMap().isEmpty()) {
            for (Map.Entry next : req.getParameterMap().entrySet()) {
                String action = (String)next.getKey();
                Object value = next.getValue();
                IDiagnostic diagnosticProvider = DiagnosticFactory.getDiagnosticProvider(action);
                if (diagnosticProvider == null || !(value instanceof Object[])) continue;
                diagnosticProvider.call(action, (Object[])value);
            }
        }
        if (CompareUtility.equals((Object)"xml", (Object)(format = req.getParameter("format")))) {
            this.doXmlResponse(res);
        } else {
            this.doHtmlResponse(req, res);
        }
    }

    private void doXmlResponse(HttpServletResponse resp) throws IOException {
        List<List<String>> result = this.getDiagnosticItems();
        String diagnosticXML = this.getDiagnosticItemsXML(result);
        resp.setContentType("text/xml");
        ServletOutputStream out = resp.getOutputStream();
        out.println("<?xml version='1.0' encoding='UTF-8' ?>");
        out.println("<diagnosticsStatus>");
        out.println(diagnosticXML);
        out.println("</diagnosticsStatus>");
    }

    private void doHtmlResponse(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        IDiagnostic[] diagnosticServices;
        String errorMsg = "";
        String doGc = req.getParameter("gc");
        if (StringUtility.hasText((CharSequence)doGc)) {
            System.gc();
            errorMsg = "<font color='blue'> System.gc() triggered.</font>";
        }
        List<List<String>> result = this.getDiagnosticItems();
        IDiagnostic[] iDiagnosticArray = diagnosticServices = DiagnosticFactory.getDiagnosticProviders();
        int n = diagnosticServices.length;
        int n2 = 0;
        while (n2 < n) {
            IDiagnostic diagnosticService = iDiagnosticArray[n2];
            if (CollectionUtility.hasElements((Object[])diagnosticService.getPossibleActions())) {
                diagnosticService.addSubmitButtonsHTML(result);
            }
            ++n2;
        }
        DiagnosticFactory.addDiagnosticItemToList(result, "System.gc()", "", "<input type='checkbox' name='gc' value='yes'/>");
        String diagnosticHTML = this.getDiagnosticItemsHTML(result);
        String title = "unknown";
        Version version = Version.emptyVersion;
        IProduct product = Platform.getProduct();
        if (product != null) {
            title = product.getName();
            version = Version.parseVersion((String)((String)product.getDefiningBundle().getHeaders().get("Bundle-Version")));
        }
        resp.setContentType("text/html");
        ServletOutputStream out = resp.getOutputStream();
        out.println("<html>");
        out.println("<head>");
        out.println("<title>" + title + "</title>");
        out.println("<style>");
        out.println("body {font-family: sans-serif; font-size: 12; background-color : #F6F6F6;}");
        out.println("a,a:VISITED {color: #6666ff;text-decoration: none;}");
        out.println("table {font-size: 12; empty-cells: show;}");
        out.println("th {text-align: left;vertical-align: top; padding-left: 2; background-color : #cccccc;}");
        out.println("td {text-align: left;vertical-align: top; padding-left: 2;}");
        out.println("p {margin-top: 4; margin-bottom: 4; padding-top: 4; padding-bottom: 4;}");
        out.println("dt {font-weight: bold;}");
        out.println("dd {margin-left: 20px; margin-bottom: 3px;}");
        out.println(".copyright {font-size: 10;}");
        out.println("</style>");
        out.println("<script type=\"text/javascript\">");
        out.println("function toggle_visibility(id) {");
        out.println("   var el = document.getElementById(id);");
        out.println("   el.style.display = (el.style.display != 'none' ? 'none' : 'block');");
        out.println("}");
        out.println("</script>");
        out.println("</head>");
        out.println("<body>");
        out.println("<h3>" + title + " " + version + "</h3>");
        out.println("<form method='POST' action='" + StringUtility.join((String)"?", (Object[])new Object[]{req.getRequestURL().toString(), req.getQueryString()}) + "'>");
        out.print(diagnosticHTML);
        out.println("<p><input type='submit' value='submit'/></p>");
        out.println("</form>");
        out.print(errorMsg);
        out.println("<p class=\"copyright\">&copy; " + OfficialVersion.COPYRIGHT + "</p>");
        out.println("</body>");
        out.println("</html>");
    }

    private List<List<String>> getDiagnosticItems() {
        ArrayList<List<String>> result = new ArrayList<List<String>>();
        ArrayList<String> infos = DiagnosticSession.getSystemInformation();
        DiagnosticFactory.addDiagnosticItemToList(result, "Server", "", "TITLE");
        DiagnosticFactory.addDiagnosticItemToList(result, "Runtime Environment", infos.get(0), "INFO");
        DiagnosticFactory.addDiagnosticItemToList(result, "Application Directory", infos.get(1), "INFO");
        DiagnosticFactory.addDiagnosticItemToList(result, "JVM Memory Status", "Max: " + infos.get(2) + ", Reserved: " + infos.get(3) + ", Currently Used: " + infos.get(4), "INFO");
        DiagnosticFactory.addDiagnosticItemToList(result, "JVM Locale", infos.get(11), "INFO");
        DiagnosticFactory.addDiagnosticItemToList(result, "Operating System", infos.get(6), "INFO");
        DiagnosticFactory.addDiagnosticItemToList(result, "Architecture", infos.get(5), "INFO");
        DiagnosticFactory.addDiagnosticItemToList(result, "#CPUs available to JVM", infos.get(12), "INFO");
        DiagnosticFactory.addDiagnosticItemToList(result, "OS Country / Timezone", String.valueOf(infos.get(9)) + " / " + infos.get(10), "INFO");
        DiagnosticFactory.addDiagnosticItemToList(result, "Host Address / Name", String.valueOf(infos.get(13)) + " / " + infos.get(14), "INFO");
        IDiagnostic[] diagnosticServices = DiagnosticFactory.getDiagnosticProviders();
        IDiagnostic[] iDiagnosticArray = diagnosticServices;
        int n = diagnosticServices.length;
        int n2 = 0;
        while (n2 < n) {
            IDiagnostic diagnosticService = iDiagnosticArray[n2];
            diagnosticService.addDiagnosticItemToList(result);
            ++n2;
        }
        ArrayList<String> properties = new ArrayList<String>();
        for (Object property : System.getProperties().keySet()) {
            properties.add("" + property);
        }
        Collections.sort(properties);
        String sysprops = "";
        sysprops = String.valueOf(sysprops) + "<a href=\"#\" onClick=\"javascript:toggle_visibility('sysprops'); return false;\">(show / hide)</a>";
        sysprops = String.valueOf(sysprops) + "<div id=\"sysprops\" style=\"width:600px; margin: 0px; padding: 0px; display: none; word-wrap: break-word;\">";
        sysprops = String.valueOf(sysprops) + "<dl>";
        for (String property : properties) {
            sysprops = String.valueOf(sysprops) + "<dt>" + property + ":</b></dt><dd>" + System.getProperty(property) + "</dd>";
        }
        sysprops = String.valueOf(sysprops) + "</dl>";
        sysprops = String.valueOf(sysprops) + "</div>";
        DiagnosticFactory.addDiagnosticItemToList(result, "System properties", sysprops, "INFO");
        ArrayList<String> envKeys = new ArrayList<String>();
        for (String envKey : System.getenv().keySet()) {
            envKeys.add(envKey);
        }
        Collections.sort(envKeys);
        String envList = "";
        envList = String.valueOf(envList) + "<a href=\"#\" onClick=\"javascript:toggle_visibility('env'); return false;\">(show / hide)</a>";
        envList = String.valueOf(envList) + "<div id=\"env\" style=\"width:600px; margin: 0px; padding: 0px; display: none; word-wrap: break-word;\">";
        envList = String.valueOf(envList) + "<dl>";
        for (String envKey : envKeys) {
            envList = String.valueOf(envList) + "<dt>" + envKey + ":</b></dt><dd>" + System.getenv(envKey) + "</dd>";
        }
        envList = String.valueOf(envList) + "</dl>";
        envList = String.valueOf(envList) + "</div>";
        DiagnosticFactory.addDiagnosticItemToList(result, "Environment variables", envList, "INFO");
        DiagnosticFactory.addDiagnosticItemToList(result, "Version", "", "TITLE");
        Version v = Version.emptyVersion;
        IProduct product = Platform.getProduct();
        String productId = "n/a";
        String productName = "n/a";
        String application = "n/a";
        String definingBundle = "n/a";
        if (product != null) {
            productId = product.getId();
            productName = product.getName();
            application = product.getApplication();
            definingBundle = product.getDefiningBundle().getSymbolicName();
            v = Version.parseVersion((String)((String)product.getDefiningBundle().getHeaders().get("Bundle-Version")));
        }
        DiagnosticFactory.addDiagnosticItemToList(result, "Product ID", productId, "INFO");
        DiagnosticFactory.addDiagnosticItemToList(result, "Product Name", productName, "INFO");
        DiagnosticFactory.addDiagnosticItemToList(result, "Application", application, "INFO");
        DiagnosticFactory.addDiagnosticItemToList(result, "Defining Bundle", definingBundle, "INFO");
        DiagnosticFactory.addDiagnosticItemToList(result, "Defining Bundle Version", v.toString(), "INFO");
        DiagnosticFactory.addDiagnosticItemToList(result, "Change values", "", "TITLE");
        return result;
    }

    private String getDiagnosticItemsXML(List<List<String>> result) {
        StringBuffer buf = new StringBuffer();
        for (List<String> status : result) {
            if (CompareUtility.equals((Object)"TITLE", (Object)status.get(2))) continue;
            buf.append("<status name='" + status.get(0) + "' status='" + status.get(2) + "'>");
            buf.append(status.get(1));
            buf.append("</status>");
        }
        return buf.toString();
    }

    private String getDiagnosticItemsHTML(List<List<String>> diagnosticItems) {
        StringBuffer buf = new StringBuffer();
        buf.append("<table>");
        int i = 0;
        while (i < diagnosticItems.size()) {
            List<String> item = diagnosticItems.get(i);
            String style = "";
            String status = item.get(2);
            if ("TITLE".equals(status)) {
                buf.append("<tr><td><b>" + item.get(0) + "&nbsp;&nbsp;</b></td><td></td><td></td>");
            } else {
                if ("OK".equals(status) || "ACTIVE".equals(status)) {
                    style = " style =\"color:white;background-color:green\"";
                } else if ("FAILED".equals(status) || "INACTIVE".equals(status)) {
                    style = " style =\"color:white;background-color:red\"";
                } else if ("INFO".equals(status)) {
                    style = " style =\"color:white;background-color:blue\"";
                }
                buf.append("<tr><td style=\"background-color:lightgrey\">" + item.get(0) + "&nbsp;&nbsp;</td><td>" + item.get(1) + "&nbsp;&nbsp;</td><td" + style + "><b>" + item.get(2) + "</b></td>");
            }
            ++i;
        }
        buf.append("</table>");
        return buf.toString();
    }

    public static ArrayList<String> getSystemInformation() {
        String hostname;
        Runtime rt = Runtime.getRuntime();
        ArrayList<String> result = new ArrayList<String>();
        result.add(String.valueOf(System.getProperty("java.runtime.name")) + " (" + System.getProperty("java.runtime.version") + ")");
        result.add(System.getProperty("user.dir"));
        DecimalFormat df = new DecimalFormat("0.00");
        result.add(String.valueOf(df.format((float)rt.maxMemory() / 1048576.0f)) + " MB");
        result.add(String.valueOf(df.format((float)rt.totalMemory() / 1048576.0f)) + " MB");
        result.add(String.valueOf(df.format((float)(rt.totalMemory() - rt.freeMemory()) / 1048576.0f)) + " MB");
        result.add(System.getProperty("os.arch"));
        result.add(String.valueOf(System.getProperty("os.name")) + " (" + System.getProperty("os.version") + ")");
        result.add(System.getProperty("user.name"));
        result.add(System.getProperty("user.home"));
        result.add(System.getProperty("user.country"));
        result.add(System.getProperty("user.timezone"));
        result.add(String.valueOf(LocaleThreadLocal.get().getDisplayLanguage()) + " (L) / " + LocaleThreadLocal.get().getLanguage() + " (F)");
        result.add(String.valueOf(rt.availableProcessors()));
        String ip = "";
        try {
            InetAddress addr = InetAddress.getLocalHost();
            ip = addr.getHostAddress();
            hostname = addr.getHostName();
        }
        catch (UnknownHostException e) {
            hostname = "Unknown";
            ip = "Unknown";
        }
        result.add(ip);
        result.add(hostname);
        return result;
    }
}

