/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.server.internal;

import java.util.HashSet;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.server.IServerSession;
import org.eclipse.scout.rt.server.ServiceTunnelServlet;
import org.osgi.framework.Bundle;

@Deprecated
public class ServerSessionClassFinder {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(ServerSessionClassFinder.class);

    public String findClassNameByConvention() {
        Bundle bundle = this.findServletContributorBundle();
        if (bundle == null) {
            return null;
        }
        return this.getServerSessionName(bundle);
    }

    public String findClassNameByConvention(String alias) {
        Bundle bundle = this.findServletContributorBundle(alias);
        if (bundle == null) {
            return null;
        }
        return this.getServerSessionName(bundle);
    }

    public Class<? extends IServerSession> findClassByConvention(String alias) {
        Bundle bundle = this.findServletContributorBundle(alias);
        if (bundle == null) {
            return null;
        }
        String serverSessionName = this.getServerSessionName(bundle);
        try {
            return bundle.loadClass(serverSessionName);
        }
        catch (ClassNotFoundException e) {
            LOG.error("Failed to load server session class '" + serverSessionName + "' from bundle '" + bundle.getSymbolicName());
            return null;
        }
    }

    private String getServerSessionName(Bundle bundle) {
        return String.valueOf(bundle.getSymbolicName()) + ".ServerSession";
    }

    private Bundle findServletContributorBundle() {
        return this.findServletContributorBundle(null);
    }

    public Bundle findServletContributorBundle(String alias) {
        IExtensionPoint xpServlet = this.getServletExtensionPoint();
        if (xpServlet != null) {
            HashSet<Bundle> serviceTunnelContributorBundles = new HashSet<Bundle>();
            IExtension[] iExtensionArray = xpServlet.getExtensions();
            int n = iExtensionArray.length;
            int n2 = 0;
            while (n2 < n) {
                IExtension xServlet = iExtensionArray[n2];
                IConfigurationElement[] iConfigurationElementArray = xServlet.getConfigurationElements();
                int n3 = iConfigurationElementArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    Bundle bundle;
                    String servletClassName;
                    IConfigurationElement cServlet = iConfigurationElementArray[n4];
                    if ("servlet".equals(cServlet.getName()) && this.isServiceTunnelServlet(servletClassName = cServlet.getAttribute("class"), bundle = Platform.getBundle((String)cServlet.getContributor().getName())) && this.isMatchingAlias(alias, cServlet)) {
                        serviceTunnelContributorBundles.add(bundle);
                    }
                    ++n4;
                }
                ++n2;
            }
            int count = serviceTunnelContributorBundles.size();
            if (count == 1) {
                return (Bundle)serviceTunnelContributorBundles.iterator().next();
            }
            if (count == 0) {
                LOG.warn("No contribution bundle found for servlet '" + ServiceTunnelServlet.class.getSimpleName() + "'");
            } else {
                LOG.warn("Multiple contribution bundles found for servlet '" + ServiceTunnelServlet.class.getSimpleName() + "'.");
            }
        }
        return null;
    }

    private boolean isMatchingAlias(String alias, IConfigurationElement cServlet) {
        if (alias != null) {
            return alias.equals(cServlet.getAttribute("alias"));
        }
        return true;
    }

    private boolean isServiceTunnelServlet(String className, Bundle bundle) {
        if (!ServiceTunnelServlet.class.getName().equals(className)) {
            return false;
        }
        if (bundle == null) {
            return false;
        }
        try {
            Class servletClass = bundle.loadClass(className);
            if (ServiceTunnelServlet.class.isAssignableFrom(servletClass)) {
                return true;
            }
        }
        catch (ClassNotFoundException e) {
            LOG.debug("Registered Servlet Class Not found ", (Throwable)e);
        }
        return false;
    }

    protected IExtensionPoint getServletExtensionPoint() {
        IExtensionRegistry reg = Platform.getExtensionRegistry();
        if (reg != null) {
            return reg.getExtensionPoint("org.eclipse.equinox.http.registry.servlets");
        }
        return null;
    }

    private Class<? extends IServerSession> loadServerSessionSafe(Bundle bundle, String serverSessionFqn) {
        try {
            Class clazz = bundle.loadClass(serverSessionFqn);
            if (IServerSession.class.isAssignableFrom(clazz)) {
                return clazz;
            }
            LOG.error("Server session class '" + serverSessionFqn + "' could not be loaded as not of the type '" + IServerSession.class.getName() + "'");
        }
        catch (ClassNotFoundException e) {
            LOG.error("Server session class '" + serverSessionFqn + "' could not be found");
        }
        return null;
    }
}

