/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.server.services.common.jdbc.internal.exec;

import java.lang.reflect.Method;
import org.eclipse.scout.commons.exception.ProcessingException;
import org.eclipse.scout.commons.holders.ITableBeanHolder;
import org.eclipse.scout.commons.holders.ITableBeanRowHolder;
import org.eclipse.scout.commons.parsers.token.IToken;
import org.eclipse.scout.commons.parsers.token.ValueInputToken;
import org.eclipse.scout.rt.server.services.common.jdbc.SqlBind;
import org.eclipse.scout.rt.server.services.common.jdbc.internal.exec.IBindInput;
import org.eclipse.scout.rt.server.services.common.jdbc.style.ISqlStyle;

class TableBeanHolderInput
implements IBindInput {
    private ITableBeanHolder m_table;
    private ITableBeanRowHolder[] m_filteredRows;
    private Method m_getterMethod;
    private ValueInputToken m_target;
    private int m_batchIndex = -1;
    private int m_jdbcBindIndex = -1;

    public TableBeanHolderInput(ITableBeanHolder table, ITableBeanRowHolder[] filteredRows, String columnName, ValueInputToken target) throws ProcessingException {
        this.m_table = table;
        this.m_filteredRows = filteredRows == null ? this.m_table.getRows() : filteredRows;
        try {
            this.m_getterMethod = table.getRowType().getMethod("get" + Character.toUpperCase(columnName.charAt(0)) + columnName.substring(1), new Class[0]);
        }
        catch (Throwable e) {
            throw new ProcessingException("unexpected exception", e);
        }
        this.m_target = target;
    }

    @Override
    public IToken getToken() {
        return this.m_target;
    }

    @Override
    public boolean isBatch() {
        return true;
    }

    @Override
    public boolean hasBatch(int i) {
        return i < this.m_filteredRows.length;
    }

    @Override
    public void setNextBatchIndex(int i) {
        this.m_batchIndex = i;
    }

    @Override
    public boolean isJdbcBind(ISqlStyle sqlStyle) {
        if (this.m_target.isPlainValue()) {
            return false;
        }
        return !this.m_target.isPlainSql();
    }

    @Override
    public int getJdbcBindIndex() {
        return this.m_jdbcBindIndex;
    }

    @Override
    public void setJdbcBindIndex(int index) {
        this.m_jdbcBindIndex = index;
    }

    @Override
    public SqlBind produceSqlBindAndSetReplaceToken(ISqlStyle sqlStyle) throws ProcessingException {
        Object value = null;
        if (this.m_batchIndex < this.m_filteredRows.length) {
            try {
                value = this.m_getterMethod.invoke((Object)this.m_filteredRows[this.m_batchIndex], new Object[0]);
            }
            catch (Throwable e) {
                throw new ProcessingException("unexpected exception", e);
            }
        }
        if (this.m_target.isPlainValue()) {
            this.m_target.setReplaceToken(sqlStyle.toPlainText(value));
            return null;
        }
        if (this.m_target.isPlainSql()) {
            this.m_target.setReplaceToken("" + value);
            return null;
        }
        this.m_target.setReplaceToken("?");
        return sqlStyle.buildBindFor(value, this.m_getterMethod.getReturnType());
    }
}

