/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.shared.data.basic;

import java.io.Serializable;
import org.eclipse.scout.commons.CompareUtility;

public class MemoryOptimizedObject
implements Serializable {
    private static final long serialVersionUID = 1L;
    private short m_bits;
    private Object[] m_data = new Object[0];

    protected synchronized boolean setValueInternal(int bitPos, Object newValue) {
        int index = this.getIndexFor(bitPos);
        if (index >= 0) {
            Object oldValue = this.m_data[index];
            if (newValue != null) {
                this.m_data[index] = newValue;
            } else {
                Object[] newData = new Object[this.m_data.length - 1];
                int i = 0;
                while (i < index) {
                    newData[i] = this.m_data[i];
                    ++i;
                }
                i = index;
                while (i < newData.length) {
                    newData[i] = this.m_data[i + 1];
                    ++i;
                }
                this.m_data = newData;
                this.m_bits = (short)(this.m_bits - (1 << bitPos));
            }
            return !CompareUtility.equals((Object)oldValue, (Object)newValue);
        }
        if (newValue != null) {
            int setCountBefore = 0;
            int i = 0;
            while (i < bitPos) {
                if ((this.m_bits & 1 << i) != 0) {
                    ++setCountBefore;
                }
                ++i;
            }
            index = setCountBefore;
            Object[] newData = new Object[this.m_data.length + 1];
            int i2 = 0;
            while (i2 < index) {
                newData[i2] = this.m_data[i2];
                ++i2;
            }
            newData[index] = newValue;
            i2 = index + 1;
            while (i2 < newData.length) {
                newData[i2] = this.m_data[i2 - 1];
                ++i2;
            }
            this.m_data = newData;
            this.m_bits = (short)(this.m_bits | 1 << bitPos);
            return true;
        }
        return false;
    }

    protected synchronized Object getValueInternal(int bitPos) {
        int index = this.getIndexFor(bitPos);
        if (index >= 0) {
            return this.m_data[index];
        }
        return null;
    }

    private int getIndexFor(int bitPos) {
        if ((this.m_bits & 1 << bitPos) != 0) {
            int setCount = 0;
            int i = 0;
            while (i <= bitPos) {
                if ((this.m_bits & 1 << i) != 0) {
                    ++setCount;
                }
                ++i;
            }
            return setCount - 1;
        }
        return -1;
    }
}

