/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.shared.services.common.security.internal;

import java.security.Permissions;
import java.util.Collection;
import java.util.HashSet;
import org.eclipse.scout.commons.CollectionUtility;
import org.eclipse.scout.commons.TTLCache;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.shared.services.common.security.IAccessControlService;
import org.eclipse.scout.service.SERVICES;

public class AccessControlStore {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(AccessControlStore.class);
    private TTLCache<String, Permissions> m_store;
    private Object m_storeLock = new Object();

    public AccessControlStore() {
        this.m_store = new TTLCache(3600000L);
    }

    public Permissions getPermissionsOfCurrentSubject() {
        String userId = ((IAccessControlService)SERVICES.getService(IAccessControlService.class)).getUserIdOfCurrentSubject();
        if (userId == null) {
            return null;
        }
        return this.getPermissions(userId);
    }

    public void setPermissionsOfCurrentSubject(Permissions p) {
        String userId = ((IAccessControlService)SERVICES.getService(IAccessControlService.class)).getUserIdOfCurrentSubject();
        if (userId == null) {
            throw new SecurityException("userId is null");
        }
        this.setPermissions(userId, p);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Permissions getPermissions(String userId) {
        if (userId == null) {
            return null;
        }
        Object object = this.m_storeLock;
        synchronized (object) {
            return (Permissions)this.m_store.get((Object)userId.toLowerCase());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPermissions(String userId, Permissions p) {
        if (userId == null) {
            return;
        }
        Object object = this.m_storeLock;
        synchronized (object) {
            if (p == null) {
                p = new Permissions();
                p.setReadOnly();
            }
            this.m_store.put((Object)userId.toLowerCase(), (Object)p);
        }
    }

    public void clearCache() {
        this.clearCacheOfUserIds(this.getUserIds());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearCacheOfUserIds(Collection<String> userIds0) {
        HashSet userIds = CollectionUtility.hashSetWithoutNullElements(userIds0);
        if (userIds.isEmpty()) {
            return;
        }
        Object object = this.m_storeLock;
        synchronized (object) {
            for (String userId : userIds) {
                if (userId == null) continue;
                this.m_store.remove((Object)userId.toLowerCase());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<String> getUserIds() {
        Object object = this.m_storeLock;
        synchronized (object) {
            return CollectionUtility.hashSet((Collection)this.m_store.keySet());
        }
    }
}

