/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.shared.validate;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.scout.rt.shared.validate.IValidationStrategy;
import org.eclipse.scout.rt.shared.validate.checks.IValidateCheck;

public class ValidateCheckSet {
    private final List<IValidateCheck> m_checks = new ArrayList<IValidateCheck>();
    private ValidateCheckSet m_parent;

    public ValidateCheckSet getParent() {
        return this.m_parent;
    }

    public void setParent(ValidateCheckSet parent) {
        this.m_parent = parent;
    }

    public boolean isEmpty() {
        return this.m_checks.isEmpty();
    }

    public void addCheck(IValidateCheck check) {
        if (check != null) {
            this.m_checks.add(check);
        }
    }

    public void applyChecks(IValidationStrategy strategy, Object obj, HashSet<String> consumedChecks) throws Exception {
        if (this.isEmpty() && this.m_parent == null) {
            return;
        }
        ListIterator<IValidateCheck> it = this.m_checks.listIterator(this.m_checks.size());
        while (it.hasPrevious()) {
            IValidateCheck check = it.previous();
            String id = check.getCheckId();
            if (consumedChecks.contains(id) || !strategy.accept(check) || !check.accept(obj)) continue;
            consumedChecks.add(id);
            check.check(obj);
        }
        if (this.m_parent != null) {
            this.m_parent.applyChecks(strategy, obj, consumedChecks);
        }
    }

    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + this.m_checks + ", parent=" + this.m_parent;
    }
}

