/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.spec.client.gen.extract;

import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.scout.commons.CollectionUtility;
import org.eclipse.scout.commons.ITypeWithClassId;
import org.eclipse.scout.rt.shared.TEXTS;
import org.eclipse.scout.rt.spec.client.gen.extract.AbstractNamedTextExtractor;
import org.eclipse.scout.rt.spec.client.gen.extract.IDocTextExtractor;

public class DescriptionExtractor<T extends ITypeWithClassId>
extends AbstractNamedTextExtractor<T>
implements IDocTextExtractor<T> {
    public DescriptionExtractor() {
        super(TEXTS.get((String)"org.eclipse.scout.rt.spec.doc"));
    }

    @Override
    public String getText(T o) {
        String doc = this.getDocAssociatedWithClassId(o);
        if (doc != null) {
            doc = doc.replaceAll("</html>", "");
            doc = doc.replaceAll("<html>", "");
        }
        return doc;
    }

    private String getDocAssociatedWithClassId(T o) {
        ArrayList<String> classIdParts = new ArrayList<String>(Arrays.asList(o.classId().split("_")));
        String text = null;
        while (!classIdParts.isEmpty() && text == null) {
            String classId = CollectionUtility.format(classIdParts, (String)"_");
            text = TEXTS.getWithFallback((String)classId, null);
            classIdParts.remove(classIdParts.size() - 1);
        }
        return text != null ? text : "";
    }
}

