/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.spec.client.gen.extract;

import org.eclipse.scout.commons.ConfigurationUtility;
import org.eclipse.scout.rt.shared.TEXTS;
import org.eclipse.scout.rt.shared.services.common.code.ICodeType;
import org.eclipse.scout.rt.spec.client.gen.extract.AbstractNamedTextExtractor;
import org.eclipse.scout.rt.spec.client.gen.extract.CodeTypeNameExtractor;
import org.eclipse.scout.rt.spec.client.out.mediawiki.MediawikiUtility;
import org.eclipse.scout.rt.spec.client.utility.SpecUtility;

public class LinkableTypeExtractor<T>
extends AbstractNamedTextExtractor<T> {
    public static final String LINKS_TAG_NAME = "links";
    private Class m_supertype;
    private boolean m_assumeAllSubtypesDocumented;

    public LinkableTypeExtractor() {
        this(Object.class, false);
    }

    public LinkableTypeExtractor(Class supertype, boolean assumeAllSubtypesDocumented) {
        super(TEXTS.get((String)"org.eclipse.scout.rt.spec.type"));
        this.m_supertype = supertype;
        this.m_assumeAllSubtypesDocumented = assumeAllSubtypesDocumented;
    }

    @Override
    public String getText(T o) {
        Class<?> type = o.getClass();
        return this.getText(type);
    }

    @Override
    public String getText(Class type) {
        Class hierarchyType = type;
        StringBuilder specType = new StringBuilder();
        while (hierarchyType != null) {
            if (SpecUtility.isDocType(hierarchyType, this.m_supertype, this.m_assumeAllSubtypesDocumented)) {
                String name = this.getName(hierarchyType);
                specType.append(MediawikiUtility.createLink("c_" + ConfigurationUtility.getAnnotatedClassIdWithFallback(hierarchyType), name));
                break;
            }
            hierarchyType = hierarchyType.getSuperclass();
        }
        if (specType.length() == 0) {
            specType.append(type.getSimpleName());
        }
        return specType.toString();
    }

    private String getName(Class hierarchyType) {
        String name = ICodeType.class.isAssignableFrom(hierarchyType) ? new CodeTypeNameExtractor(false).getText(hierarchyType) : TEXTS.getWithFallback((String)(String.valueOf(ConfigurationUtility.getAnnotatedClassIdWithFallback((Class)hierarchyType)) + "_name"), (String)hierarchyType.getSimpleName());
        return name;
    }
}

