/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.spec.client.screenshot;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.LinkedBlockingDeque;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.scout.commons.ITypeWithClassId;
import org.eclipse.scout.commons.exception.ProcessingException;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.client.ClientSyncJob;
import org.eclipse.scout.rt.client.ui.form.FormEvent;
import org.eclipse.scout.rt.client.ui.form.FormListener;
import org.eclipse.scout.rt.client.ui.form.IForm;
import org.eclipse.scout.rt.spec.client.screenshot.FormScreenshotPrinter;

public class PrintScreenshotsFormListener
implements FormListener {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(PrintScreenshotsFormListener.class);
    private final Queue<ITypeWithClassId> m_printQueue = new LinkedBlockingDeque<ITypeWithClassId>();
    private final FormScreenshotPrinter m_formPrinter;
    private final List<File> m_printedFiles = new ArrayList<File>();
    private IForm m_topLevelForm;

    public PrintScreenshotsFormListener(FormScreenshotPrinter formPrinter) {
        this.m_formPrinter = formPrinter;
    }

    public void formChanged(FormEvent e) throws ProcessingException {
        if (e.getType() == 510) {
            this.m_topLevelForm = e.getForm();
            this.enqueuePrintObjects(this.m_topLevelForm);
            this.scheduleNextPrintJob();
        } else if (e.getType() == 4010) {
            this.m_printedFiles.add(e.getPrintedFile());
            if (this.m_printQueue.isEmpty()) {
                LOG.info("Closing form : {}", (Object)this.m_topLevelForm);
                this.m_topLevelForm.doClose();
            } else {
                this.scheduleNextPrintJob();
            }
        }
    }

    protected void scheduleNextPrintJob() {
        new ClientSyncJob("Printing", ClientSyncJob.getCurrentSession()){

            protected void runVoid(IProgressMonitor monitor) {
                ITypeWithClassId next = (ITypeWithClassId)PrintScreenshotsFormListener.this.m_printQueue.remove();
                PrintScreenshotsFormListener.this.m_formPrinter.print(next);
            }
        }.schedule();
    }

    protected void enqueuePrintObjects(IForm form) {
        List<ITypeWithClassId> printObjects = this.m_formPrinter.getPrintObjects(form);
        for (ITypeWithClassId o : printObjects) {
            this.m_printQueue.add(o);
            LOG.info("Adding object to print: {}", (Object)o);
        }
    }

    public List<File> getPrintedFiles() {
        return this.m_printedFiles;
    }
}

