/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.testing.shared.runner.parameterized;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.scout.rt.testing.shared.runner.parameterized.IScoutTestParameter;
import org.eclipse.scout.rt.testing.shared.runner.parameterized.NonParameterized;
import org.eclipse.scout.rt.testing.shared.runner.parameterized.ParameterizedFrameworkMethod;
import org.junit.runner.Description;
import org.junit.runners.Parameterized;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.TestClass;

public class ParameterizedTestRunnerExtension {
    private ParameterizedTestRunnerExtension() {
    }

    public static Object createTest(TestClass testClass, IScoutTestParameter testParameter) throws Exception {
        try {
            return testClass.getOnlyConstructor().newInstance(testParameter);
        }
        catch (Exception ex) {
            String parameterName = testParameter != null ? testParameter.getName() : null;
            throw new Exception("Constructor can not be invoked with the parameter '" + parameterName + "')", ex);
        }
    }

    public static List<IScoutTestParameter> loadParameterList(TestClass testClass) {
        try {
            List parametersMethod = testClass.getAnnotatedMethods(Parameterized.Parameters.class);
            return (List)((FrameworkMethod)parametersMethod.get(0)).invokeExplosively(null, new Object[0]);
        }
        catch (Throwable t) {
            throw new IllegalStateException("Parameters cannot be loaded", t);
        }
    }

    public static List<FrameworkMethod> createTestMethods(List<FrameworkMethod> originalTestMethods, int numberOfParameterEntries) {
        LinkedList<FrameworkMethod> nonParameterizedTestMethods = new LinkedList<FrameworkMethod>();
        LinkedList<FrameworkMethod> originalTestMethodsToBeParameterized = new LinkedList<FrameworkMethod>();
        for (FrameworkMethod test : originalTestMethods) {
            if (test.getAnnotation(NonParameterized.class) != null) {
                nonParameterizedTestMethods.add(test);
                continue;
            }
            originalTestMethodsToBeParameterized.add(test);
        }
        LinkedList<FrameworkMethod> result = new LinkedList<FrameworkMethod>();
        result.addAll(nonParameterizedTestMethods);
        result.addAll(ParameterizedTestRunnerExtension.createParameterizedTestMethods(originalTestMethodsToBeParameterized, numberOfParameterEntries));
        return result;
    }

    protected static List<FrameworkMethod> createParameterizedTestMethods(List<FrameworkMethod> originalTestMethods, int numberOfParameterEntries) {
        LinkedList<FrameworkMethod> result = new LinkedList<FrameworkMethod>();
        int paramsIndex = 0;
        while (paramsIndex < numberOfParameterEntries) {
            for (FrameworkMethod test : originalTestMethods) {
                if (test.getAnnotation(NonParameterized.class) != null) continue;
                ParameterizedFrameworkMethod parameterizedTest = new ParameterizedFrameworkMethod(test, paramsIndex);
                result.add(parameterizedTest);
            }
            ++paramsIndex;
        }
        return result;
    }

    public static void validateOneParametersMethod(TestClass testClass, List<Throwable> errors) {
        List parametersMethods = testClass.getAnnotatedMethods(Parameterized.Parameters.class);
        if (parametersMethods.size() != 1) {
            errors.add(new Exception("Parameters method is missing. It must return List<" + IScoutTestParameter.class.getSimpleName() + ">"));
        } else {
            FrameworkMethod parametersMethod = (FrameworkMethod)parametersMethods.get(0);
            Method innerMethod = parametersMethod.getMethod();
            if (!Modifier.isStatic(innerMethod.getModifiers())) {
                errors.add(new Exception("Parameters method must be static"));
            }
            if (!Modifier.isPublic(innerMethod.getDeclaringClass().getModifiers())) {
                errors.add(new Exception("Class " + innerMethod.getDeclaringClass().getName() + " should be public"));
            }
            if (!Modifier.isPublic(innerMethod.getModifiers())) {
                errors.add(new Exception("Parameters method must be public"));
            }
            if (!List.class.isAssignableFrom(innerMethod.getReturnType())) {
                errors.add(new Exception("Parameters method return type must be List<" + IScoutTestParameter.class.getSimpleName() + ">"));
            }
        }
    }

    public static Description describeParameterizedChild(TestClass testClass, ParameterizedFrameworkMethod parameterizedMethod, String testName, List<IScoutTestParameter> parameterList) {
        return Description.createTestDescription((Class)testClass.getJavaClass(), (String)String.format("%s [%s]", testName, parameterList.get(parameterizedMethod.getParamIndex()).getName()), (Annotation[])parameterizedMethod.getAnnotations());
    }
}

