/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.testing.shared.services.common.code;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.scout.commons.CompareUtility;
import org.eclipse.scout.commons.exception.ProcessingException;
import org.eclipse.scout.commons.holders.Holder;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.commons.osgi.BundleClassDescriptor;
import org.eclipse.scout.rt.shared.services.common.code.ICode;
import org.eclipse.scout.rt.shared.services.common.code.ICodeService;
import org.eclipse.scout.rt.shared.services.common.code.ICodeType;
import org.eclipse.scout.rt.shared.services.common.code.ICodeVisitor;
import org.eclipse.scout.rt.shared.services.common.exceptionhandler.IExceptionHandlerService;
import org.eclipse.scout.service.AbstractService;
import org.eclipse.scout.service.SERVICES;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;

public class TestingCodeService
extends AbstractService
implements ICodeService {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(TestingCodeService.class);
    private final Map<Class<? extends ICodeType<?, ?>>, ICodeType<?, ?>> m_codeTypes = new HashMap();
    private final Object m_codeTypeMapLock = new Object();

    public TestingCodeService(List<? extends ICodeType<?, ?>> codeTypes) {
        this.addCodeTypes(codeTypes);
    }

    public TestingCodeService(ICodeType<?, ?> ... codeTypes) {
        this(Arrays.asList(codeTypes));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addCodeTypes(List<? extends ICodeType<?, ?>> codeTypes) {
        Object object = this.m_codeTypeMapLock;
        synchronized (object) {
            for (ICodeType<?, ?> ct : codeTypes) {
                if (ct == null) continue;
                this.m_codeTypes.put(ct.getClass(), ct);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends ICodeType<?, ?>> T getCodeType(Class<T> type) {
        Object object = this.m_codeTypeMapLock;
        synchronized (object) {
            return (T)this.m_codeTypes.get(type);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends ICodeType<?, ?>> T getCodeType(Long partitionId, Class<T> type) {
        Object object = this.m_codeTypeMapLock;
        synchronized (object) {
            return this.getCodeType(type);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> ICodeType<T, ?> findCodeTypeById(T id) {
        Object object = this.m_codeTypeMapLock;
        synchronized (object) {
            for (ICodeType<?, ?> ct : this.m_codeTypes.values()) {
                if (!CompareUtility.equals((Object)ct.getId(), id)) continue;
                return ct;
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> ICodeType<T, ?> findCodeTypeById(Long partitionId, T id) {
        Object object = this.m_codeTypeMapLock;
        synchronized (object) {
            return this.findCodeTypeById(id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ICodeType<?, ?>> getCodeTypes(List<Class<? extends ICodeType<?, ?>>> types) {
        Object object = this.m_codeTypeMapLock;
        synchronized (object) {
            ArrayList result = new ArrayList(types.size());
            for (Class<ICodeType<?, ?>> clazz : types) {
                ICodeType<?, ?> ct = this.getCodeType(clazz);
                if (ct == null) continue;
                result.add(ct);
            }
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ICodeType<?, ?>> getCodeTypes(Long partitionId, List<Class<? extends ICodeType<?, ?>>> types) {
        Object object = this.m_codeTypeMapLock;
        synchronized (object) {
            return this.getCodeTypes(types);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <CODE_ID_TYPE, CODE extends ICode<CODE_ID_TYPE>> CODE getCode(final Class<CODE> type) {
        Object object = this.m_codeTypeMapLock;
        synchronized (object) {
            block9: {
                if (type != null) break block9;
                return null;
            }
            Class<?> declaringCodeTypeClass = null;
            if (type.getDeclaringClass() != null) {
                Class<?> c = type.getDeclaringClass();
                while (c != null && !ICodeType.class.isAssignableFrom(c)) {
                    c = c.getDeclaringClass();
                }
                declaringCodeTypeClass = c;
            }
            if (declaringCodeTypeClass == null) {
                try {
                    declaringCodeTypeClass = ((ICode)type.newInstance()).getCodeType().getClass();
                }
                catch (Throwable t) {
                    ((IExceptionHandlerService)SERVICES.getService(IExceptionHandlerService.class)).handleException(new ProcessingException("error creating instance of class '" + type.getName() + "'.", t));
                }
            }
            Object codeType = this.getCodeType(declaringCodeTypeClass);
            final Holder codeHolder = new Holder();
            ICodeVisitor v = new ICodeVisitor<CODE>(){

                public boolean visit(CODE code, int treeLevel) {
                    if (code.getClass() == type) {
                        codeHolder.setValue(code);
                        return false;
                    }
                    return true;
                }
            };
            codeType.visit(v);
            return (CODE)((ICode)codeHolder.getValue());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <CODE_ID_TYPE, CODE extends ICode<CODE_ID_TYPE>> CODE getCode(Long partitionId, Class<CODE> type) {
        Object object = this.m_codeTypeMapLock;
        synchronized (object) {
            return this.getCode(type);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends ICodeType<?, ?>> T reloadCodeType(Class<T> type) throws ProcessingException {
        Object object = this.m_codeTypeMapLock;
        synchronized (object) {
            LOG.warn("reloading code types is not supported by this testing ICodeService");
            return this.getCodeType(type);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ICodeType<?, ?>> reloadCodeTypes(List<Class<? extends ICodeType<?, ?>>> types) throws ProcessingException {
        Object object = this.m_codeTypeMapLock;
        synchronized (object) {
            LOG.warn("reloading code types is not supported by this testing ICodeService");
            return this.getCodeTypes(types);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<BundleClassDescriptor> getAllCodeTypeClasses(String classPrefix) {
        Object object = this.m_codeTypeMapLock;
        synchronized (object) {
            HashSet<BundleClassDescriptor> result = new HashSet<BundleClassDescriptor>();
            for (Class<ICodeType<?, ?>> type : this.m_codeTypes.keySet()) {
                Bundle bundle = FrameworkUtil.getBundle(type);
                result.add(new BundleClassDescriptor(bundle.getSymbolicName(), type.getName()));
            }
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ICodeType<?, ?>> getAllCodeTypes(String classPrefix) {
        Object object = this.m_codeTypeMapLock;
        synchronized (object) {
            Collection<ICodeType<?, ?>> values = this.m_codeTypes.values();
            ArrayList result = new ArrayList(values.size());
            for (ICodeType<?, ?> ct : values) {
                if (!ct.getClass().getName().startsWith(classPrefix)) continue;
                result.add(ct);
            }
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ICodeType<?, ?>> getAllCodeTypes(String classPrefix, Long partitionId) {
        Object object = this.m_codeTypeMapLock;
        synchronized (object) {
            return this.getAllCodeTypes(classPrefix);
        }
    }
}

