/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.swing.form.fields.browserfield.internal;

import java.awt.AWTEvent;
import java.awt.Canvas;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.Toolkit;
import java.awt.event.AWTEventListener;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.io.File;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.JComponent;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.scout.commons.IOUtility;
import org.eclipse.scout.commons.exception.ProcessingException;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.client.ClientSyncJob;
import org.eclipse.scout.rt.client.ui.form.fields.IFormField;
import org.eclipse.scout.rt.client.ui.form.fields.browserfield.IBrowserField;
import org.eclipse.scout.rt.shared.services.common.file.RemoteFile;
import org.eclipse.scout.rt.ui.swing.LogicalGridLayout;
import org.eclipse.scout.rt.ui.swing.SwingUtility;
import org.eclipse.scout.rt.ui.swing.ext.JPanelEx;
import org.eclipse.scout.rt.ui.swing.ext.JStatusLabelEx;
import org.eclipse.scout.rt.ui.swing.ext.PopupFactoryEx;
import org.eclipse.scout.rt.ui.swing.form.fields.SwingScoutValueFieldComposite;
import org.eclipse.scout.rt.ui.swing.form.fields.browserfield.ISwingScoutBrowserField;
import org.eclipse.swt.awt.SWT_AWT;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.LocationAdapter;
import org.eclipse.swt.browser.LocationEvent;
import org.eclipse.swt.browser.LocationListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class SwingScoutBrowserField
extends SwingScoutValueFieldComposite<IBrowserField>
implements ISwingScoutBrowserField {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(SwingScoutBrowserField.class);
    private Shell m_swtShell;
    private Browser m_swtBrowser;
    private File m_tempDir;
    private P_CanvasEx m_canvas;
    private P_HierarchyListener m_hierarchyListener;
    private P_MouseEventListener m_mouseEventListener;
    private SwtThread m_swtThread;

    protected void initializeSwing() {
        JPanelEx container = new JPanelEx();
        container.setOpaque(false);
        JStatusLabelEx label = this.getSwingEnvironment().createStatusLabel((IFormField)this.getScoutObject());
        container.add((Component)label);
        JPanelEx wordComponent = new JPanelEx();
        this.m_canvas = new P_CanvasEx();
        wordComponent.add((Component)this.m_canvas);
        container.add((Component)wordComponent);
        this.setSwingContainer((JComponent)container);
        this.setSwingLabel(label);
        this.setSwingField((JComponent)wordComponent);
        this.getSwingContainer().setLayout((LayoutManager)new LogicalGridLayout(this.getSwingEnvironment(), 1, 0));
    }

    private void installMouseListener() {
        if (SwingUtility.IS_JAVA_7_OR_GREATER) {
            this.m_mouseEventListener = new P_MouseEventListener();
            this.m_mouseEventListener.setSwtShell(this.m_swtShell);
            Toolkit.getDefaultToolkit().addAWTEventListener(this.m_mouseEventListener, 16L);
        }
    }

    protected void attachScout() {
        super.attachScout();
        this.m_swtThread = new SwtThread();
        this.m_swtThread.start();
        this.m_hierarchyListener = new P_HierarchyListener();
        this.m_canvas.addHierarchyListener(this.m_hierarchyListener);
    }

    protected void detachScout() {
        this.m_canvas.removeHierarchyListener(this.m_hierarchyListener);
        if (this.m_tempDir != null) {
            IOUtility.deleteDirectory((File)this.m_tempDir);
            this.m_tempDir = null;
        }
        super.detachScout();
    }

    private boolean isSwtAttached() {
        return this.m_swtBrowser != null;
    }

    private void attachSwtSafe() {
        if (this.isSwtAttached()) {
            return;
        }
        PopupFactoryEx.activate();
        final Display display = this.m_swtThread.getDisplay();
        display.syncExec(new Runnable(){

            @Override
            public void run() {
                block9: {
                    try {
                        try {
                            SwingScoutBrowserField.this.m_swtShell = SWT_AWT.new_Shell((Display)display, (Canvas)SwingScoutBrowserField.this.m_canvas);
                            SwingScoutBrowserField.this.m_swtShell.setLayout((Layout)new FillLayout());
                            SwingScoutBrowserField.this.m_swtBrowser = new Browser((Composite)SwingScoutBrowserField.this.m_swtShell, 0);
                            SwingScoutBrowserField.this.m_swtBrowser.addLocationListener((LocationListener)new LocationAdapter(){

                                public void changing(LocationEvent event) {
                                    event.doit = SwingScoutBrowserField.this.fireBeforeLocationChangedFromSwt(event.location);
                                }

                                public void changed(LocationEvent event) {
                                    SwingScoutBrowserField.this.fireAfterLocationChangedFromSwt(event.location);
                                }
                            });
                            SwingScoutBrowserField.this.installMouseListener();
                            IBrowserField scoutField = (IBrowserField)SwingScoutBrowserField.this.getScoutObject();
                            String url = null;
                            if (scoutField.getLocation() != null) {
                                url = scoutField.getLocation();
                            } else if (scoutField.getValue() != null) {
                                url = SwingScoutBrowserField.this.toRemoteFileUrl((RemoteFile)scoutField.getValue());
                            }
                            if (url != null && !url.isEmpty()) {
                                SwingScoutBrowserField.this.getSwtBrowser().setUrl(url);
                                break block9;
                            }
                            SwingScoutBrowserField.this.getSwtBrowser().setText("");
                        }
                        catch (RuntimeException e) {
                            LOG.error("Failed to connect to SWT. All resources safely disposed.", (Throwable)e);
                            SwingScoutBrowserField.this.detachSwtSafe();
                            SwingScoutBrowserField.this.getSwingContainer().revalidate();
                        }
                    }
                    finally {
                        SwingScoutBrowserField.this.getSwingContainer().revalidate();
                    }
                }
            }
        });
    }

    private void detachSwtSafe() {
        if (!this.isSwtAttached()) {
            return;
        }
        PopupFactoryEx.deactivate();
        try {
            try {
                this.m_swtThread.dispose();
                this.m_swtBrowser = null;
                this.m_swtShell = null;
            }
            catch (RuntimeException e) {
                LOG.error("Failed to disconnect from SWT.", (Throwable)e);
                this.removeMouseListener();
            }
        }
        finally {
            this.removeMouseListener();
        }
    }

    private void removeMouseListener() {
        if (this.m_mouseEventListener != null) {
            Toolkit.getDefaultToolkit().removeAWTEventListener(this.m_mouseEventListener);
            this.m_mouseEventListener.setSwtShell(null);
            this.m_mouseEventListener = null;
        }
    }

    protected void handleScoutPropertyChange(String name, Object newValue) {
        super.handleScoutPropertyChange(name, newValue);
        if ("location".equals(name)) {
            this.setLocationFromScout();
        }
    }

    protected void setLocationFromScout() {
        this.setLocationInternal(((IBrowserField)this.getScoutObject()).getLocation());
    }

    protected void setValueFromScout(Object value) {
        this.setLocationInternal(this.toRemoteFileUrl((RemoteFile)((IBrowserField)this.getScoutObject()).getValue()));
    }

    protected String toRemoteFileUrl(RemoteFile remoteFile) {
        block10: {
            block9: {
                if (remoteFile == null || !remoteFile.exists()) {
                    return null;
                }
                if (this.m_tempDir != null) break block9;
                try {
                    this.m_tempDir = IOUtility.createTempDirectory((String)"html");
                }
                catch (ProcessingException e) {
                    LOG.error("Failed to create temporary folder for the content to be displayed in the browser.", (Throwable)e);
                    return null;
                }
            }
            try {
                if (!remoteFile.getName().matches(".*\\.(zip|jar)")) break block10;
                remoteFile.writeZipContentToDirectory(this.m_tempDir);
                String simpleName = remoteFile.getName().replaceAll("\\.(zip|jar)", ".htm");
                File[] fileArray = this.m_tempDir.listFiles();
                int n = fileArray.length;
                int n2 = 0;
                while (n2 < n) {
                    File f = fileArray[n2];
                    if (f.getName().startsWith(simpleName)) {
                        return f.toURI().toURL().toExternalForm();
                    }
                    ++n2;
                }
                return null;
            }
            catch (Exception e) {
                LOG.error(String.format("Failed to prepare HTML content to be displayed in the browser [remoteFile=%s]", remoteFile), (Throwable)e);
                return null;
            }
        }
        File f = new File(this.m_tempDir, remoteFile.getName());
        remoteFile.writeData(f);
        return f.toURI().toURL().toExternalForm();
    }

    protected void setLocationInternal(final String location) {
        if (!this.isSwtAttached()) {
            return;
        }
        this.m_swtThread.getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (location != null && !location.isEmpty()) {
                    SwingScoutBrowserField.this.getSwtBrowser().setUrl(location);
                } else {
                    SwingScoutBrowserField.this.getSwtBrowser().setText("");
                }
            }
        });
    }

    protected boolean fireBeforeLocationChangedFromSwt(final String location) {
        final AtomicReference<Boolean> accept = new AtomicReference<Boolean>(false);
        ClientSyncJob job = new ClientSyncJob("fireBeforeLocationChangedFromSwt", this.getSwingEnvironment().getScoutSession()){

            protected void runVoid(IProgressMonitor monitor) {
                accept.set(((IBrowserField)SwingScoutBrowserField.this.getScoutObject()).getUIFacade().fireBeforeLocationChangedFromUI(location));
            }
        };
        job.schedule();
        try {
            job.join(TimeUnit.SECONDS.toMillis(10L));
            return accept.get();
        }
        catch (InterruptedException e) {
            LOG.warn("Failed to wait for the Scout model to accept a location change.", (Throwable)e);
            return false;
        }
    }

    protected void fireAfterLocationChangedFromSwt(final String location) {
        ClientSyncJob job = new ClientSyncJob("fireAfterLocationChangedFromSwt", this.getSwingEnvironment().getScoutSession()){

            protected void runVoid(IProgressMonitor monitor) throws Throwable {
                ((IBrowserField)SwingScoutBrowserField.this.getScoutObject()).getUIFacade().fireAfterLocationChangedFromUI(location);
            }
        };
        job.schedule();
    }

    protected Browser getSwtBrowser() {
        return this.m_swtBrowser;
    }

    private class P_CanvasEx
    extends Canvas {
        private static final long serialVersionUID = 1L;

        private P_CanvasEx() {
        }

        @Override
        public void removeNotify() {
            SwingScoutBrowserField.this.detachSwtSafe();
            super.removeNotify();
        }
    }

    private class P_HierarchyListener
    implements HierarchyListener {
        private P_HierarchyListener() {
        }

        @Override
        public void hierarchyChanged(HierarchyEvent e) {
            if (e.getID() == 1400 && (e.getChangeFlags() & 2L) != 0L && e.getChanged() == SwingScoutBrowserField.this.m_canvas && e.getChanged().isDisplayable()) {
                SwingScoutBrowserField.this.attachSwtSafe();
            }
        }
    }

    private class P_MouseEventListener
    implements AWTEventListener {
        private Shell m_swtShell;

        private P_MouseEventListener() {
        }

        public void setSwtShell(Shell swtShell) {
            this.m_swtShell = swtShell;
        }

        @Override
        public void eventDispatched(AWTEvent e) {
            if (e.getID() == 500 && this.m_swtShell != null) {
                SwingScoutBrowserField.this.m_swtThread.getDisplay().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (P_MouseEventListener.this.m_swtShell.getEnabled()) {
                            P_MouseEventListener.this.m_swtShell.setEnabled(false);
                            P_MouseEventListener.this.m_swtShell.setEnabled(true);
                        }
                    }
                });
            }
        }
    }

    private static class SwtThread
    extends Thread {
        private Display m_display;
        private final Object m_displayLock = new Object();
        private static final long DISPLAY_WAIT_TIMEOUT = 15L;

        public SwtThread() {
            super("SWT Browser Thread");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         */
        @Override
        public void run() {
            var1_1 = Device.class;
            synchronized (Device.class) {
                this.m_display = new Display();
                if (this.m_display == Display.getDefault()) {
                    try {
                        f_default = Display.class.getDeclaredField("Default");
                        f_default.setAccessible(true);
                        f_default.set(null, null);
                    }
                    catch (Exception e) {
                        SwingScoutBrowserField.access$3().error(String.format("Failed to unregister the Display to not be the global Display [display=%s]", new Object[]{this.m_display}), (Throwable)e);
                    }
                }
                // ** MonitorExit[var1_1] (shouldn't be in output)
                var1_1 = this.m_displayLock;
                synchronized (var1_1) {
                    this.m_displayLock.notifyAll();
                    // MONITOREXIT @DISABLED, blocks:[2, 4, 5] lbl22 : MonitorExitStatement: MONITOREXIT : var1_1
                    if (true) ** GOTO lbl30
                }
                {
                    do {
                        if (this.m_display.readAndDispatch()) continue;
                        this.m_display.sleep();
lbl30:
                        // 3 sources

                    } while (!this.m_display.isDisposed());
                    this.m_display = null;
                }
                return;
            }
        }

        public void dispose() {
            this.m_display.syncExec(new Runnable(){

                @Override
                public void run() {
                    SwtThread.this.m_display.dispose();
                }
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        Display getDisplay() {
            long threshold = System.nanoTime() + TimeUnit.SECONDS.toNanos(15L);
            while (this.m_display == null && System.nanoTime() < threshold) {
                try {
                    Object object = this.m_displayLock;
                    synchronized (object) {
                        if (this.m_display == null) {
                            this.m_displayLock.wait(TimeUnit.SECONDS.toMillis(15L));
                        }
                    }
                }
                catch (InterruptedException e) {
                    throw new RuntimeException("Interrupted while waiting for the Display to be created.", e);
                }
            }
            if (this.m_display == null) {
                throw new IllegalStateException("SWT Display could not be acquired.");
            }
            return this.m_display;
        }
    }
}

