/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.swing.basic;

import java.util.HashMap;
import java.util.Map;
import javax.swing.Icon;
import org.eclipse.scout.rt.ui.swing.Activator;
import org.eclipse.scout.rt.ui.swing.ISwingEnvironment;

public class IconGroup {
    private final Map<IconState, Icon> iconMap = new HashMap<IconState, Icon>();

    public IconGroup() {
    }

    public IconGroup(String iconId) {
        Icon selected;
        if (iconId == null) {
            return;
        }
        Icon normal = Activator.getIcon(iconId);
        Icon rollover = Activator.getIcon(String.valueOf(iconId) + "_mouse_over");
        if (rollover == null) {
            rollover = Activator.getIcon(String.valueOf(iconId) + "_rollover");
        }
        if ((selected = Activator.getIcon(String.valueOf(iconId) + "_active")) == null && (selected = Activator.getIcon(String.valueOf(iconId) + "_pressed")) == null) {
            selected = Activator.getIcon(String.valueOf(iconId) + "_selected");
        }
        Icon disabled = Activator.getIcon(String.valueOf(iconId) + "_disabled");
        this.iconMap.put(IconState.NORMAL, normal);
        if (rollover != null) {
            this.iconMap.put(IconState.ROLLOVER, rollover);
        }
        if (selected != null) {
            this.iconMap.put(IconState.SELECTED, selected);
        }
        if (disabled != null) {
            this.iconMap.put(IconState.DISABLED, disabled);
        }
    }

    public IconGroup(ISwingEnvironment env, String iconId) {
        Icon selected;
        if (iconId == null) {
            return;
        }
        Icon normal = env.getIcon(iconId);
        Icon rollover = env.getIcon(String.valueOf(iconId) + "_mouse_over");
        if (rollover == null) {
            rollover = env.getIcon(String.valueOf(iconId) + "_rollover");
        }
        if ((selected = env.getIcon(String.valueOf(iconId) + "_active")) == null && (selected = env.getIcon(String.valueOf(iconId) + "_pressed")) == null) {
            selected = env.getIcon(String.valueOf(iconId) + "_selected");
        }
        Icon disabled = env.getIcon(String.valueOf(iconId) + "_disabled");
        this.iconMap.put(IconState.NORMAL, normal);
        if (rollover != null) {
            this.iconMap.put(IconState.ROLLOVER, rollover);
        }
        if (selected != null) {
            this.iconMap.put(IconState.SELECTED, selected);
        }
        if (disabled != null) {
            this.iconMap.put(IconState.DISABLED, disabled);
        }
    }

    public Icon getIcon(IconState state) {
        Icon icon = this.iconMap.get((Object)state);
        if (icon == null && state != IconState.NORMAL) {
            icon = this.iconMap.get((Object)IconState.NORMAL);
        }
        return icon;
    }

    public void setIcon(IconState state, Icon icon) {
        this.iconMap.put(state, icon);
    }

    public boolean hasIcon(IconState state) {
        return this.iconMap.containsKey((Object)state);
    }

    public static enum IconState {
        NORMAL,
        ROLLOVER,
        SELECTED,
        DISABLED;

    }
}

