/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.swing.basic.document;

import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.DocumentFilter;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.rt.ui.swing.SwingUtility;

public class BasicDocumentFilter
extends DocumentFilter {
    private static final long serialVersionUID = 1L;
    private int m_maxLen;

    public BasicDocumentFilter() {
        this(-1);
    }

    public BasicDocumentFilter(int maxLength) {
        this.m_maxLen = maxLength;
    }

    public int getMaxLength() {
        return this.m_maxLen;
    }

    public void setMaxLength(int maxLen) {
        this.m_maxLen = maxLen;
    }

    @Override
    public void insertString(DocumentFilter.FilterBypass fb, int offset, String s, AttributeSet a) throws BadLocationException {
        s = StringUtility.emptyIfNull((Object)s);
        String truncatedText = this.checkStringTooLong(fb, s, fb.getDocument().getLength() + s.length());
        fb.insertString(offset, truncatedText, a);
    }

    @Override
    public void replace(DocumentFilter.FilterBypass fb, int offset, int length, String s, AttributeSet a) throws BadLocationException {
        s = StringUtility.emptyIfNull((Object)s);
        s = this.checkStringTooLong(fb, s, fb.getDocument().getLength() + s.length() - length);
        fb.replace(offset, length, s, a);
    }

    protected String checkStringTooLong(DocumentFilter.FilterBypass fb, String text, int newLength) throws BadLocationException {
        if (this.m_maxLen > 0 && newLength > this.m_maxLen) {
            this.showTruncateTextMessage();
            return text.substring(0, Math.max(0, text.length() - (newLength - this.m_maxLen)));
        }
        return text;
    }

    private void showTruncateTextMessage() {
        if (SwingUtility.isPasteAction() || SwingUtility.isSunDropAction()) {
            SwingUtility.showMessageDialogSynthCapable(SwingUtility.getOwnerForChildWindow(), SwingUtility.getNlsText("PasteTextTooLongForFieldX", "" + this.getMaxLength()), SwingUtility.getNlsText("Paste", new String[0]), 2);
        }
    }
}

