/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.swing.form.fields.splitbox;

import java.awt.Component;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import javax.swing.JSplitPane;
import org.eclipse.scout.commons.CollectionUtility;
import org.eclipse.scout.commons.OptimisticLock;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.client.IClientSession;
import org.eclipse.scout.rt.client.ui.ClientUIPreferences;
import org.eclipse.scout.rt.client.ui.form.fields.IFormField;
import org.eclipse.scout.rt.client.ui.form.fields.splitbox.ISplitBox;
import org.eclipse.scout.rt.ui.swing.form.fields.ISwingScoutFormField;
import org.eclipse.scout.rt.ui.swing.form.fields.SwingScoutFieldComposite;
import org.eclipse.scout.rt.ui.swing.form.fields.splitbox.ISwingScoutSplitBox;

public class SwingScoutSplitBox
extends SwingScoutFieldComposite<ISplitBox>
implements ISwingScoutSplitBox {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(SwingScoutSplitBox.class);
    private OptimisticLock lockSplitter = new OptimisticLock();

    @Override
    protected void initializeSwing() {
        JSplitPane container = new JSplitPane(((ISplitBox)this.getScoutObject()).isSplitHorizontal() ? 1 : 0, true);
        container.setName(String.valueOf(((ISplitBox)this.getScoutObject()).getClass().getSimpleName()) + ".container");
        container.setBorder(null);
        List scoutFields = ((ISplitBox)this.getScoutObject()).getFields();
        if (scoutFields.size() == 2) {
            ISwingScoutFormField swingScoutComposite = this.getSwingEnvironment().createFormField(container, (IFormField)CollectionUtility.firstElement((List)scoutFields));
            container.add(swingScoutComposite.getSwingContainer());
            ISwingScoutFormField swingScoutComposite1 = this.getSwingEnvironment().createFormField(container, (IFormField)CollectionUtility.getElement((List)scoutFields, (int)1));
            container.add(swingScoutComposite1.getSwingContainer());
        } else {
            LOG.error("SplitBox allows exact 2 inner fields.");
        }
        container.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                Component component = e.getComponent();
                boolean horizontal = ((ISplitBox)SwingScoutSplitBox.this.getScoutObject()).isSplitHorizontal();
                if (horizontal && component.getHeight() > 0 || !horizontal && component.getWidth() > 0) {
                    SwingScoutSplitBox.this.initializeSplitterPosition();
                    component.removeComponentListener(this);
                }
            }
        });
        this.setSwingContainer(container);
    }

    private void initializeSplitterPosition() {
        if (((ISplitBox)this.getScoutObject()).isCacheSplitterPosition()) {
            this.setCachedSplitterPosition();
        } else {
            this.setSplitterPositionFromScout();
        }
        this.getSwingContainer().addPropertyChangeListener("dividerLocation", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                SwingScoutSplitBox.this.setSplitterPositionFromSwing();
            }
        });
    }

    protected void setCachedSplitterPosition() {
        int[] a = ClientUIPreferences.getInstance((IClientSession)this.getSwingEnvironment().getScoutSession()).getSplitterPosition((ISplitBox)this.getScoutObject());
        if (a != null && a.length == 2) {
            this.setSplitterPosition(a[0], a[1]);
        } else {
            this.setSplitterPositionFromScout();
        }
    }

    protected void setSplitterPositionFromScout() {
        try {
            double p;
            if (this.lockSplitter.acquire() && (p = ((ISplitBox)this.getScoutObject()).getSplitterPosition()) >= 0.0 && p <= 1.0) {
                this.getSwingContainer().setDividerLocation(p);
                this.getSwingContainer().setResizeWeight(p);
            }
        }
        finally {
            this.lockSplitter.release();
        }
    }

    protected void setSplitterPosition(int leftWidth, int rightWidth) {
        if (leftWidth < 0 || rightWidth < 0) {
            return;
        }
        try {
            double total;
            if (this.lockSplitter.acquire() && (total = (double)(leftWidth + rightWidth)) > 0.0) {
                double d = (double)leftWidth / total;
                this.getSwingContainer().setDividerLocation(d);
                this.getSwingContainer().setResizeWeight(d);
            }
        }
        finally {
            this.lockSplitter.release();
        }
    }

    protected void setSplitterPositionFromSwing() {
        if (((ISplitBox)this.getScoutObject()).isCacheSplitterPosition()) {
            int total = (this.getSwingContainer().getOrientation() == 1 ? this.getSwingContainer().getWidth() : this.getSwingContainer().getHeight()) - this.getSwingContainer().getDividerSize();
            if (total > 32) {
                int left = this.getSwingContainer().getDividerLocation();
                int right = total - left;
                this.cacheSplitterPosition(new int[]{left, right});
            }
        } else {
            this.cacheSplitterPosition(null);
        }
    }

    protected void cacheSplitterPosition(int[] weights) {
        ClientUIPreferences.getInstance((IClientSession)this.getSwingEnvironment().getScoutSession()).setSplitterPosition((ISplitBox)this.getScoutObject(), weights);
    }

    @Override
    protected void handleScoutPropertyChange(String name, Object newValue) {
        if (!"splitterEnabled".equals(name) && "splitterPosition".equals(name)) {
            this.setSplitterPositionFromScout();
        }
        super.handleScoutPropertyChange(name, newValue);
    }

    @Override
    public JSplitPane getSwingContainer() {
        return (JSplitPane)super.getSwingContainer();
    }
}

