/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.swing.login.internal;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.UndeclaredThrowableException;
import java.net.Authenticator;
import java.net.PasswordAuthentication;
import java.util.HashSet;
import javax.swing.SwingUtilities;
import org.eclipse.scout.commons.BundleContextUtility;
import org.eclipse.scout.commons.SecurePreferencesUtility;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.ui.swing.login.internal.AuthStatus;
import org.eclipse.scout.rt.ui.swing.login.internal.LoginDialog;

public class InternalNetAuthenticator
extends Authenticator {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(InternalNetAuthenticator.class);
    public static final boolean NET_AUTHENTICATION_CACHE_ENABLED = BundleContextUtility.parseBooleanProperty((String)"java.net.authenticate.cache.enabled", (boolean)false);
    private HashSet<String> m_visitedKeys = new HashSet();

    @Override
    protected PasswordAuthentication getPasswordAuthentication() {
        AuthStatus status = new AuthStatus();
        status.setUrl(this.getRequestingURL());
        status.setProxy(this.getRequestorType() == Authenticator.RequestorType.PROXY);
        String path = String.valueOf(this.getRequestingURL().getHost()) + this.getRequestingURL().getPath();
        String visitedKey = null;
        if (NET_AUTHENTICATION_CACHE_ENABLED) {
            try {
                String[] a = SecurePreferencesUtility.loadCredentials((String)path);
                if (a != null) {
                    status.setUsername(a[0]);
                    status.setPassword(a[1]);
                    visitedKey = String.valueOf(status.getUsername()) + "@" + path;
                    if (!this.m_visitedKeys.contains(visitedKey)) {
                        this.m_visitedKeys.add(visitedKey);
                        return new PasswordAuthentication(status.getUsername(), status.getPassword().toCharArray());
                    }
                }
            }
            catch (Throwable t) {
                LOG.error(this.getRequestingURL().toExternalForm(), t);
            }
        }
        try {
            this.showModalDialog(status);
        }
        catch (Throwable t) {
            LOG.error(this.getRequestingURL().toExternalForm(), t);
        }
        if (status.isOk()) {
            if (status.isSavePassword()) {
                visitedKey = String.valueOf(status.getUsername()) + "@" + path;
                this.m_visitedKeys.add(visitedKey);
                if (status.isSavePassword()) {
                    try {
                        SecurePreferencesUtility.storeCredentials((String)path, (String)status.getUsername(), (String)status.getPassword());
                    }
                    catch (Throwable t) {
                        LOG.error(this.getRequestingURL().toExternalForm(), t);
                    }
                }
            }
            return new PasswordAuthentication(status.getUsername(), status.getPassword().toCharArray());
        }
        if (status.isCancel()) {
            System.exit(0);
            return null;
        }
        return null;
    }

    private void showModalDialog(final AuthStatus status) throws Throwable {
        if (!SwingUtilities.isEventDispatchThread()) {
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            InternalNetAuthenticator.this.showModalDialog(status);
                        }
                        catch (Throwable e) {
                            throw new UndeclaredThrowableException(e);
                        }
                    }
                });
            }
            catch (Throwable ex) {
                Throwable t = ex;
                if (t instanceof InvocationTargetException) {
                    if (t.getCause() != null) {
                        t = t.getCause();
                    }
                } else if (t instanceof UndeclaredThrowableException && t.getCause() != null) {
                    t = t.getCause();
                }
                throw t;
            }
            return;
        }
        LoginDialog dlg = new LoginDialog(status);
        dlg.setModal(true);
        dlg.setLocationRelativeTo(null);
        dlg.setVisible(true);
        dlg.dispose();
    }
}

