/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.swt.form.fields.datefield.chooser;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableColorProvider;
import org.eclipse.jface.viewers.ITableFontProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.scout.commons.DateUtility;
import org.eclipse.scout.commons.LocaleThreadLocal;
import org.eclipse.scout.rt.shared.data.basic.FontSpec;
import org.eclipse.scout.rt.ui.swt.ISwtEnvironment;
import org.eclipse.scout.rt.ui.swt.form.fields.datefield.chooser.DateRow;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.RGB;

public class DatefieldTableModel
implements IStructuredContentProvider,
ITableLabelProvider,
ITableColorProvider,
ITableFontProvider {
    private List<DateRow> m_rows = new ArrayList<DateRow>();
    private Date m_navigationDate = null;
    private Date m_highLightDate = null;
    private SimpleDateFormat m_monthYearFormat = new SimpleDateFormat("MMMMM yyyy");
    private Color m_weekendBackground;
    private Color m_outMonthForeground;
    private Color m_highlightBackground;
    private Color m_highlightForeground;
    private Font m_highlightFont;
    private final ISwtEnvironment m_environment;

    public DatefieldTableModel(ISwtEnvironment environment) {
        this.m_environment = environment;
        this.m_weekendBackground = this.getEnvironment().getColor(new RGB(238, 238, 238));
        this.m_outMonthForeground = this.getEnvironment().getColor(new RGB(180, 180, 180));
        this.m_highlightBackground = this.getEnvironment().getColor(new RGB(1, 42, 195));
        this.m_highlightForeground = this.getEnvironment().getColor(new RGB(255, 255, 255));
        this.m_highlightFont = this.getEnvironment().getFont(new FontSpec(null, 1, -1), JFaceResources.getDefaultFont());
    }

    public void dispose() {
    }

    public DateRow getHighLightRow() {
        for (DateRow row : this.m_rows) {
            Date min = row.getDate(0);
            Date max = row.getDate(8);
            if (!min.before(this.m_highLightDate) || !max.after(this.m_highLightDate)) continue;
            return row;
        }
        return null;
    }

    public int indexOf(DateRow row) {
        return this.m_rows.indexOf(row);
    }

    public void setRows(ArrayList<DateRow> rows) {
        this.m_rows.clear();
        this.m_rows.addAll(rows);
    }

    public void setHighLightDate(Date date) {
        if (date == null) {
            date = new Date();
        }
        this.m_highLightDate = date;
    }

    public void setNavigationDate(Date date) {
        if (date == null) {
            date = new Date();
        }
        this.m_navigationDate = date;
        this.m_rows.clear();
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        int firstDayOfWeek = c.getFirstDayOfWeek();
        c.add(5, -(c.get(5) - 1));
        c.add(7, -((c.get(7) - firstDayOfWeek + 7) % 7));
        int iRows = 0;
        while (iRows < 6) {
            DateRow row = new DateRow(c.getTime());
            this.m_rows.add(row);
            c.add(5, 7);
            ++iRows;
        }
    }

    public Date getNavigationDate() {
        return this.m_navigationDate;
    }

    public String getMonthYearLabel() {
        return this.m_monthYearFormat.format(this.m_navigationDate);
    }

    public Object[] getElements(Object inputElement) {
        return this.m_rows.toArray();
    }

    public Image getColumnImage(Object element, int columnIndex) {
        return null;
    }

    public String getColumnText(Object element, int columnIndex) {
        Calendar c = Calendar.getInstance();
        c.setTime(((DateRow)element).getDate(columnIndex - 1));
        int dayOfMonth = c.get(5);
        return "" + dayOfMonth;
    }

    public Color getBackground(Object element, int columnIndex) {
        Date date = ((DateRow)element).getDate(columnIndex - 1);
        if (DateUtility.isSameDay((Date)date, (Date)this.m_highLightDate)) {
            return this.m_highlightBackground;
        }
        if (DateUtility.isWeekend((Date)date, (Locale)LocaleThreadLocal.get())) {
            return this.m_weekendBackground;
        }
        return this.m_highlightForeground;
    }

    public Color getForeground(Object element, int columnIndex) {
        Date date = ((DateRow)element).getDate(columnIndex - 1);
        if (DateUtility.isSameDay((Date)date, (Date)this.m_highLightDate)) {
            return this.m_highlightForeground;
        }
        if (!DateUtility.isSameMonth((Date)date, (Date)this.m_navigationDate)) {
            return this.m_outMonthForeground;
        }
        return null;
    }

    public Font getFont(Object element, int columnIndex) {
        Date date = ((DateRow)element).getDate(columnIndex - 1);
        if (DateUtility.isSameDay((Date)date, (Date)this.m_highLightDate)) {
            return this.m_highlightFont;
        }
        return null;
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }

    public void addListener(ILabelProviderListener listener) {
    }

    public boolean isLabelProperty(Object element, String property) {
        return false;
    }

    public void removeListener(ILabelProviderListener listener) {
    }

    public ISwtEnvironment getEnvironment() {
        return this.m_environment;
    }
}

