/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.swt.form.fields.groupbox;

import org.eclipse.scout.rt.client.ui.form.fields.IFormField;
import org.eclipse.scout.rt.client.ui.form.fields.groupbox.IGroupBox;
import org.eclipse.scout.rt.client.ui.form.fields.tabbox.ITabBox;
import org.eclipse.scout.rt.ui.swt.DefaultValidateRoot;
import org.eclipse.scout.rt.ui.swt.LogicalGridLayout;
import org.eclipse.scout.rt.ui.swt.ext.ScrolledFormEx;
import org.eclipse.scout.rt.ui.swt.ext.StatusLabelEx;
import org.eclipse.scout.rt.ui.swt.extension.IUiDecoration;
import org.eclipse.scout.rt.ui.swt.extension.UiDecorationExtensionPoint;
import org.eclipse.scout.rt.ui.swt.form.fields.ISwtScoutFormField;
import org.eclipse.scout.rt.ui.swt.form.fields.SwtScoutFieldComposite;
import org.eclipse.scout.rt.ui.swt.form.fields.SwtScoutFormFieldGridData;
import org.eclipse.scout.rt.ui.swt.form.fields.groupbox.ISwtScoutGroupBox;
import org.eclipse.scout.rt.ui.swt.form.fields.groupbox.SwtScoutGroupBoxButtonbar;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.events.ExpansionAdapter;
import org.eclipse.ui.forms.events.ExpansionEvent;
import org.eclipse.ui.forms.events.IExpansionListener;
import org.eclipse.ui.forms.widgets.Section;

public class SwtScoutGroupBox
extends SwtScoutFieldComposite<IGroupBox>
implements ISwtScoutGroupBox {
    private ScrolledFormEx m_scrolledForm;
    private Composite m_swtBodyPart;
    private SwtScoutGroupBoxButtonbar m_swtButtonbar;
    private Section m_swtSection;
    private Group m_swtGroup;
    private boolean m_containerBorderEnabled;
    private String m_containerBorderDecorationResolved;
    private String m_containerImage;

    @Override
    protected void initializeSwt(Composite parent) {
        GridData bodyData;
        this.m_containerBorderDecorationResolved = this.resolveBorderDecoration((IGroupBox)this.getScoutObject());
        this.m_containerBorderEnabled = ((IGroupBox)this.getScoutObject()).isBorderVisible();
        Composite rootPane = this.createContainer(parent);
        if (((IGroupBox)this.getScoutObject()).isScrollable()) {
            this.m_scrolledForm = this.getEnvironment().getFormToolkit().createScrolledFormEx(rootPane, 768);
            this.m_swtBodyPart = this.m_scrolledForm.getBody();
            this.m_scrolledForm.setData("SCROLLED_FORM", new Object());
            bodyData = new GridData(1808);
            bodyData.horizontalIndent = 0;
            bodyData.verticalIndent = 0;
            this.m_scrolledForm.setLayoutData(bodyData);
            this.m_swtBodyPart.setData("LayoutValidateManager.validateRoot", (Object)new DefaultValidateRoot(this.m_swtBodyPart){

                @Override
                public void validate() {
                    if (SwtScoutGroupBox.this.m_scrolledForm != null && !SwtScoutGroupBox.this.m_scrolledForm.isDisposed()) {
                        SwtScoutGroupBox.this.m_scrolledForm.reflow(true);
                    }
                }
            });
        } else {
            this.m_swtBodyPart = this.getEnvironment().getFormToolkit().createComposite(rootPane);
            bodyData = new GridData(1808);
            bodyData.horizontalIndent = 0;
            bodyData.verticalIndent = 0;
            this.m_swtBodyPart.setLayoutData((Object)bodyData);
        }
        this.m_swtBodyPart.setData("groupBoxMarker", (Object)Boolean.TRUE);
        this.createButtonbar(rootPane);
        IUiDecoration deco = UiDecorationExtensionPoint.getLookAndFeel();
        int minWidth = -1;
        if (((IGroupBox)this.getScoutObject()).isScrollable()) {
            minWidth = (int)((double)(((IGroupBox)this.getScoutObject()).getGridData().w * deco.getLogicalGridLayoutDefaultColumnWidth()) * 0.8);
        }
        LogicalGridLayout bodyLayout = new LogicalGridLayout(deco.getLogicalGridLayoutHorizontalGap(), deco.getLogicalGridLayoutVerticalGap(), minWidth);
        this.m_swtBodyPart.setLayout((Layout)bodyLayout);
        this.installSwtContainerBorder();
        for (IFormField field : ((IGroupBox)this.getScoutObject()).getControlFields()) {
            ISwtScoutFormField swtScoutComposite = this.getEnvironment().createFormField(this.m_swtBodyPart, field);
            SwtScoutFormFieldGridData layoutData = new SwtScoutFormFieldGridData(field);
            swtScoutComposite.getSwtContainer().setLayoutData((Object)layoutData);
        }
    }

    protected Composite createButtonbar(Composite parent) {
        this.m_swtButtonbar = new SwtScoutGroupBoxButtonbar();
        this.m_swtButtonbar.createField(parent, (IGroupBox)this.getScoutObject(), this.getEnvironment());
        GridData data = new GridData(768);
        data.horizontalIndent = 0;
        data.verticalIndent = 0;
        this.m_swtButtonbar.getSwtContainer().setLayoutData((Object)data);
        this.m_swtButtonbar.updateButtonbarVisibility();
        return this.m_swtButtonbar.getSwtContainer();
    }

    protected String resolveBorderDecoration(IGroupBox box) {
        if ("section".equals(box.getBorderDecoration())) {
            return "section";
        }
        if ("line".equals(box.getBorderDecoration())) {
            return "line";
        }
        if ("empty".equals(box.getBorderDecoration())) {
            return "empty";
        }
        if ("auto".equals(box.getBorderDecoration())) {
            if (box.isExpandable()) {
                return "section";
            }
            if (box.isMainBox()) {
                return "empty";
            }
            if (box.getParentField() instanceof ITabBox) {
                return "empty";
            }
            return "line";
        }
        return "empty";
    }

    protected Composite createContainer(Composite parent) {
        Composite rootPane = null;
        GridLayout layout = new GridLayout(1, true);
        this.setSwtLabel(null);
        if (this.m_containerBorderEnabled) {
            if ("section".equals(this.m_containerBorderDecorationResolved)) {
                int style = (((IGroupBox)this.getScoutObject()).isExpanded() ? 64 : 0) | 0x100;
                if (((IGroupBox)this.getScoutObject()).isExpandable()) {
                    style |= 2;
                }
                this.m_swtSection = this.getEnvironment().getFormToolkit().createSection(parent, style);
                String label = ((IGroupBox)this.getScoutObject()).getLabel();
                if (label == null) {
                    label = "";
                }
                this.m_swtSection.setText(label);
                this.m_swtSection.addExpansionListener((IExpansionListener)new P_ExpansionListener());
                rootPane = this.getEnvironment().getFormToolkit().createComposite((Composite)this.m_swtSection);
                this.m_swtSection.setClient((Control)rootPane);
                this.setSwtContainer((Composite)this.m_swtSection);
                layout.horizontalSpacing = 4;
                layout.verticalSpacing = 4;
                layout.marginWidth = 0;
                layout.marginHeight = 0;
                layout.marginTop = 6;
                layout.marginLeft = 6;
                layout.marginBottom = 6;
                layout.marginRight = 6;
                rootPane.setLayout((Layout)layout);
            } else if ("line".equals(this.m_containerBorderDecorationResolved)) {
                this.m_swtGroup = this.getEnvironment().getFormToolkit().createGroup(parent, 16);
                rootPane = this.m_swtGroup;
                this.setSwtContainer((Composite)this.m_swtGroup);
                layout.horizontalSpacing = 4;
                layout.verticalSpacing = 4;
                layout.marginWidth = 0;
                layout.marginHeight = 0;
                layout.marginTop = 6;
                layout.marginLeft = 6;
                layout.marginBottom = 6;
                layout.marginRight = 6;
                rootPane.setLayout((Layout)layout);
            } else {
                rootPane = this.getEnvironment().getFormToolkit().createComposite(parent);
                this.setSwtContainer(rootPane);
                layout.horizontalSpacing = 4;
                layout.verticalSpacing = 4;
                layout.marginWidth = 0;
                layout.marginHeight = 0;
                layout.marginTop = 12;
                layout.marginLeft = 12;
                layout.marginBottom = 12;
                layout.marginRight = 12;
                rootPane.setLayout((Layout)layout);
            }
        } else {
            rootPane = this.getEnvironment().getFormToolkit().createComposite(parent);
            this.setSwtContainer(rootPane);
            layout.horizontalSpacing = 0;
            layout.verticalSpacing = 0;
            layout.marginWidth = 0;
            layout.marginHeight = 0;
            layout.marginTop = 0;
            layout.marginLeft = 0;
            layout.marginBottom = 0;
            layout.marginRight = 0;
            rootPane.setLayout((Layout)layout);
        }
        return rootPane;
    }

    @Override
    public StatusLabelEx getSwtLabel() {
        return null;
    }

    @Override
    protected void attachScout() {
        super.attachScout();
        if (this.m_swtButtonbar != null) {
            this.m_swtButtonbar.attachScout();
        }
        this.updateBackgroundImageFromScout();
        this.updateBackgroundImageHorizontalAlignFromScout();
        this.updateBackgroundImageVerticalAlignFromScout();
        this.setExpandedFromScout();
    }

    @Override
    protected void detachScout() {
        super.detachScout();
        if (this.m_swtButtonbar != null) {
            this.m_swtButtonbar.detachScout();
        }
    }

    protected void setExpandedFromScout() {
        if (((IGroupBox)this.getScoutObject()).isExpandable() && this.m_swtSection != null && this.m_swtSection.isExpanded() != ((IGroupBox)this.getScoutObject()).isExpanded()) {
            this.m_swtSection.setExpanded(((IGroupBox)this.getScoutObject()).isExpanded());
        }
    }

    @Override
    protected void setEnabledFromScout(boolean b) {
    }

    @Override
    protected void setLabelFromScout(String s) {
        if (s == null) {
            s = "";
        }
        if (this.m_swtSection != null) {
            this.m_swtSection.setText(s);
            this.m_swtSection.layout(true, true);
        }
        if (this.m_swtGroup != null) {
            this.m_swtGroup.setText(s);
        }
    }

    protected void updateBackgroundImageFromScout() {
        String imageName = ((IGroupBox)this.getScoutObject()).getBackgroundImageName();
        if (!(imageName == this.m_containerImage || imageName != null && imageName.equals(this.m_containerImage))) {
            this.m_containerImage = imageName;
            this.installSwtContainerBorder();
        }
    }

    protected void updateBackgroundImageHorizontalAlignFromScout() {
    }

    protected void updateBackgroundImageVerticalAlignFromScout() {
    }

    private void installSwtContainerBorder() {
    }

    @Override
    protected void handleScoutPropertyChange(String name, Object newValue) {
        super.handleScoutPropertyChange(name, newValue);
        if (name.equals("expanded")) {
            this.setExpandedFromScout();
        } else if (name.equals("backgroundImageName")) {
            this.updateBackgroundImageFromScout();
        } else if (name.equals("backgroundImageHorizontalAlignment")) {
            this.updateBackgroundImageHorizontalAlignFromScout();
        } else if (name.equals("backgroundImageVerticalAlignment")) {
            this.updateBackgroundImageVerticalAlignFromScout();
        }
    }

    protected void handleSwtGroupBoxExpanded(final boolean expanded) {
        Runnable t = new Runnable(){

            @Override
            public void run() {
                ((IGroupBox)SwtScoutGroupBox.this.getScoutObject()).getUIFacade().setExpandedFromUI(expanded);
            }
        };
        this.getEnvironment().invokeScoutLater(t, 0L);
    }

    @Override
    protected void setBackgroundFromScout(String scoutColor) {
        this.setBackgroundFromScout(scoutColor, (Control)this.getSwtContainer());
    }

    private class P_ExpansionListener
    extends ExpansionAdapter {
        private P_ExpansionListener() {
        }

        public void expansionStateChanged(ExpansionEvent e) {
            SwtScoutGroupBox.this.handleSwtGroupBoxExpanded(e.getState());
        }
    }
}

