/*******************************************************************************
 * Copyright (c) 2013 BSI Business Systems Integration AG.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     BSI Business Systems Integration AG - initial API and implementation
 ******************************************************************************/
package org.eclipse.scout.sdk.ui.executor;

import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.jdt.core.IType;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.scout.sdk.jobs.OperationJob;
import org.eclipse.scout.sdk.operation.util.wellform.WellformScoutTypeOperation;
import org.eclipse.scout.sdk.ui.util.UiUtility;
import org.eclipse.swt.widgets.Shell;

/**
 * <h3>{@link WellformScoutTypeExecutor}</h3>
 *
 * @author Matthias Villiger
 * @since 4.1.0 13.10.2014
 */
public class WellformScoutTypeExecutor extends AbstractExecutor {

  private IType m_type;

  @Override
  public Object run(Shell shell, IStructuredSelection selection, ExecutionEvent event) {
    new OperationJob(new WellformScoutTypeOperation(m_type, true)).schedule();
    return null;
  }

  @Override
  public boolean canRun(IStructuredSelection selection) {
    m_type = UiUtility.getTypeFromSelection(selection);
    return isEditable(m_type);
  }

}
