/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.executor;

import java.util.LinkedList;
import java.util.List;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.scout.commons.CollectionUtility;
import org.eclipse.scout.sdk.Texts;
import org.eclipse.scout.sdk.ui.executor.AbstractRenameExecutor;
import org.eclipse.scout.sdk.ui.internal.ScoutSdkUi;
import org.eclipse.scout.sdk.ui.internal.jdt.JdtRenameTransaction;
import org.eclipse.scout.sdk.ui.internal.view.outline.pages.project.shared.SharedContextPropertyNodePage;
import org.eclipse.scout.sdk.ui.view.outline.pages.basic.beanproperty.BeanPropertyNodePage;
import org.eclipse.scout.sdk.util.IRegEx;
import org.eclipse.scout.sdk.util.NamingUtility;
import org.eclipse.scout.sdk.util.ScoutUtility;
import org.eclipse.scout.sdk.util.type.IMethodFilter;
import org.eclipse.scout.sdk.util.type.IPropertyBean;
import org.eclipse.scout.sdk.util.type.ITypeFilter;
import org.eclipse.scout.sdk.util.type.MethodFilters;
import org.eclipse.scout.sdk.util.type.TypeFilters;
import org.eclipse.scout.sdk.util.type.TypeUtility;
import org.eclipse.scout.sdk.util.typecache.ITypeHierarchy;

public class PropertyBeansRenameExecutor
extends AbstractRenameExecutor {
    List<IPropertyBean> m_beans;

    @Override
    public boolean canRun(IStructuredSelection selection) {
        boolean superRun = super.canRun(selection);
        if (!superRun) {
            return false;
        }
        Object selectedElement = selection.getFirstElement();
        this.m_beans = new LinkedList<IPropertyBean>();
        if (selectedElement instanceof SharedContextPropertyNodePage) {
            SharedContextPropertyNodePage scpnp = (SharedContextPropertyNodePage)selectedElement;
            if (scpnp.getClientDesc() != null) {
                this.m_beans.add(scpnp.getClientDesc());
            }
            if (scpnp.getServerDesc() != null) {
                this.m_beans.add(scpnp.getServerDesc());
            }
        } else if (selectedElement instanceof BeanPropertyNodePage) {
            BeanPropertyNodePage bpnp = (BeanPropertyNodePage)selectedElement;
            this.m_beans.add(bpnp.getPropertyDescriptor());
        }
        if (this.m_beans.isEmpty()) {
            return false;
        }
        for (IPropertyBean p : this.m_beans) {
            if (this.isEditable((IJavaElement)p.getDeclaringType())) continue;
            return false;
        }
        return true;
    }

    @Override
    protected void fillTransaction(JdtRenameTransaction transaction, String newName) throws CoreException {
        if (this.m_beans != null && this.m_beans.size() > 0) {
            this.setOldName(((IPropertyBean)CollectionUtility.firstElement(this.m_beans)).getBeanName());
        }
        String oldNameLower = NamingUtility.ensureStartWithLowerCase((String)this.getOldName());
        String oldNameUpper = NamingUtility.ensureStartWithUpperCase((String)this.getOldName());
        for (IPropertyBean d : this.m_beans) {
            for (IMember m : d.getAllMembers()) {
                String elementName = m.getElementName();
                switch (m.getElementType()) {
                    case 8: {
                        transaction.add((IField)m, elementName.replaceAll(oldNameLower, NamingUtility.ensureStartWithLowerCase((String)newName)));
                        break;
                    }
                    case 9: {
                        transaction.add((IMethod)m, elementName.replaceAll(oldNameUpper, NamingUtility.ensureStartWithUpperCase((String)newName)));
                    }
                }
            }
        }
    }

    @Override
    protected IStatus validate(String newName) {
        IStatus inheritedStatus = ScoutUtility.validateJavaName((String)newName, (String)this.getReadOnlySuffix());
        if (inheritedStatus.matches(4)) {
            return inheritedStatus;
        }
        String name = NamingUtility.ensureStartWithUpperCase((String)newName);
        for (IPropertyBean bean : this.m_beans) {
            ITypeHierarchy typeHierarchy = TypeUtility.getLocalTypeHierarchy((IJavaElement[])new IJavaElement[]{bean.getDeclaringType()});
            try {
                List allValueFields = TypeUtility.getAllTypes((ICompilationUnit)bean.getDeclaringType().getCompilationUnit(), (ITypeFilter)TypeFilters.getSubtypeFilter((IType)TypeUtility.getType((String)"org.eclipse.scout.rt.client.ui.form.fields.IValueField"), (ITypeHierarchy)typeHierarchy));
                for (IType valueField : allValueFields) {
                    String fieldName = ScoutUtility.removeFieldSuffix((String)valueField.getElementName());
                    if (!name.equals(fieldName)) continue;
                    return new Status(4, "org.eclipse.scout.sdk.ui", Texts.get((String)"Error_nameAlreadyUsed"));
                }
            }
            catch (JavaModelException e) {
                ScoutSdkUi.logError("unable to validate property rename", e);
                return new Status(4, "org.eclipse.scout.sdk.ui", "Fatal: " + e.getMessage());
            }
            if (TypeUtility.getMethods((IType)bean.getDeclaringType(), (IMethodFilter)MethodFilters.getNameRegexFilter((Pattern)Pattern.compile("^(get|set|is)" + name))).size() <= 0) continue;
            return new Status(4, "org.eclipse.scout.sdk.ui", Texts.get((String)"Error_nameAlreadyUsed"));
        }
        if (IRegEx.WELLFORMED_PROPERTY.matcher(newName).matches()) {
            return Status.OK_STATUS;
        }
        if (IRegEx.JAVAFIELD.matcher(newName).matches()) {
            return new Status(2, "org.eclipse.scout.sdk.ui", Texts.get((String)"Warning_notWellformedJavaName"));
        }
        return new Status(4, "org.eclipse.scout.sdk.ui", Texts.get((String)"Error_invalidFieldX", (String[])new String[]{newName}));
    }
}

