/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.extensions.preferences;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.scout.sdk.Texts;
import org.eclipse.scout.sdk.extensions.targetpackage.DefaultTargetPackage;
import org.eclipse.scout.sdk.extensions.targetpackage.TargetPackageEntry;
import org.eclipse.scout.sdk.ui.extensions.preferences.AbstractScoutProjectPreferencePage;
import org.eclipse.scout.sdk.ui.extensions.preferences.IScoutProjectScrolledContent;
import org.eclipse.scout.sdk.ui.extensions.preferences.TargetPackageModel;
import org.eclipse.scout.sdk.ui.extensions.preferences.TargetPackagePreferenceScrolledContent;

public class TargetPackagePreferencePage
extends AbstractScoutProjectPreferencePage<TargetPackagePreferenceScrolledContent, TargetPackageModel> {
    public TargetPackagePreferencePage() {
        super(Texts.get((String)"ScoutSDKDefaultPackagePreferences"), TargetPackagePreferenceScrolledContent.class, "CLIENT", "SERVER", "SHARED");
    }

    @Override
    protected void loadAllModels(IScoutProjectScrolledContent.IModelLoadProgressObserver<TargetPackageModel> observer, IProgressMonitor monitor) {
        Set defaultPackages = DefaultTargetPackage.getAllDefaults();
        for (Map.Entry e : this.getProjectModelMap().entrySet()) {
            if (monitor.isCanceled()) {
                return;
            }
            ArrayList<TargetPackageModel> list = new ArrayList<TargetPackageModel>();
            for (TargetPackageEntry entry : defaultPackages) {
                if (!e.getKey().hasType(entry.getBundleType())) continue;
                list.add(new TargetPackageModel(entry.getId(), entry.getDefaultSuffix(), e.getKey()));
            }
            Collections.sort(list);
            ((TargetPackagePreferenceScrolledContent)e.getValue()).loadModel((List<TargetPackageModel>)list, observer, monitor);
        }
    }

    @Override
    protected int getTotalWork() {
        return DefaultTargetPackage.getAllDefaults().size();
    }
}

