/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.extensions.quickassist;

import java.util.ArrayList;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IAnnotatable;
import org.eclipse.jdt.core.IAnnotation;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IImportDeclaration;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.core.WorkingCopyOwner;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.Annotation;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.MarkerAnnotation;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.NormalAnnotation;
import org.eclipse.jdt.core.dom.SingleMemberAnnotation;
import org.eclipse.jdt.core.dom.StringLiteral;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.rewrite.ListRewrite;
import org.eclipse.jdt.internal.core.DefaultWorkingCopyOwner;
import org.eclipse.jdt.internal.corext.refactoring.structure.CompilationUnitRewrite;
import org.eclipse.jdt.internal.ui.JavaPluginImages;
import org.eclipse.jdt.ui.text.java.IInvocationContext;
import org.eclipse.jdt.ui.text.java.IJavaCompletionProposal;
import org.eclipse.jdt.ui.text.java.IProblemLocation;
import org.eclipse.jdt.ui.text.java.IQuickAssistProcessor;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.scout.nls.sdk.model.INlsEntry;
import org.eclipse.scout.sdk.Texts;
import org.eclipse.scout.sdk.extensions.classidgenerators.ClassIdGenerationContext;
import org.eclipse.scout.sdk.extensions.classidgenerators.ClassIdGenerators;
import org.eclipse.scout.sdk.ui.extensions.quickassist.ClassIdDocumentationSupport;
import org.eclipse.scout.sdk.ui.extensions.quickassist.IClassIdDocumentationListener;
import org.eclipse.scout.sdk.ui.internal.ScoutSdkUi;
import org.eclipse.scout.sdk.ui.util.proposal.CUCorrectionProposal;
import org.eclipse.scout.sdk.util.ast.visitor.DefaultAstVisitor;
import org.eclipse.scout.sdk.util.jdt.JdtUtility;
import org.eclipse.scout.sdk.util.type.TypeUtility;
import org.eclipse.scout.sdk.util.typecache.ITypeHierarchy;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.text.edits.TextEditGroup;

public class ClassIdQuickAssistProcessor
implements IQuickAssistProcessor {
    public boolean hasAssists(IInvocationContext context) throws CoreException {
        IJavaCompletionProposal[] assists = this.getAssists(context, null);
        return assists != null && assists.length > 0;
    }

    public IJavaCompletionProposal[] getAssists(IInvocationContext context, IProblemLocation[] locations) throws CoreException {
        final ClassIdTarget selectedType = this.getTarget(context.getCoveringNode());
        if (selectedType != null) {
            ClassIdDocumentationSupport support;
            ArrayList<Object> proposals = new ArrayList<Object>(2);
            if (!TypeUtility.exists((IJavaElement)selectedType.annotation)) {
                CompilationUnitRewrite rewrite = this.createRewrite(selectedType.type, selectedType.td);
                proposals.add(new ClassIdAddProposal(rewrite));
            }
            if ((support = new ClassIdDocumentationSupport(selectedType.type)).getNlsProject() != null) {
                proposals.add(new EditDocumentationProposal(support));
                support.addModifiedListener(new IClassIdDocumentationListener(){

                    @Override
                    public void modified(int eventType, INlsEntry entry, IType owner) {
                        if (eventType == 4) {
                            ScoutSdkUi.showJavaElementInEditor((IJavaElement)selectedType.type, false);
                        }
                    }
                });
            }
            if (proposals.size() > 0) {
                return proposals.toArray(new IJavaCompletionProposal[proposals.size()]);
            }
        }
        return null;
    }

    private CompilationUnitRewrite createRewrite(IType type, TypeDeclaration td) throws JavaModelException {
        CompilationUnitRewrite cuRewrite = new CompilationUnitRewrite((WorkingCopyOwner)DefaultWorkingCopyOwner.PRIMARY, type.getCompilationUnit(), (CompilationUnit)td.getRoot());
        ListRewrite listRewrite = cuRewrite.getASTRewrite().getListRewrite((ASTNode)td, td.getModifiersProperty());
        SingleMemberAnnotation newAnnotation = td.getAST().newSingleMemberAnnotation();
        newAnnotation.setTypeName((Name)td.getAST().newSimpleName(Signature.getSimpleName((String)"org.eclipse.scout.commons.annotations.ClassId")));
        StringLiteral id = td.getAST().newStringLiteral();
        id.setLiteralValue(ClassIdGenerators.generateNewId((ClassIdGenerationContext)new ClassIdGenerationContext(type)));
        newAnnotation.setValue((Expression)id);
        if (!this.isClassIdImportPresent(type.getCompilationUnit())) {
            cuRewrite.getImportRewrite().addImport("org.eclipse.scout.commons.annotations.ClassId");
        }
        TextEditGroup group = cuRewrite.createGroupDescription("");
        ASTNode sibling = this.getSibling(td, id.getEscapedValue(), newAnnotation);
        if (sibling == null) {
            listRewrite.insertLast((ASTNode)newAnnotation, group);
        } else {
            listRewrite.insertBefore((ASTNode)newAnnotation, sibling, group);
        }
        return cuRewrite;
    }

    private ASTNode getSibling(final TypeDeclaration td, String newAnnotValue, SingleMemberAnnotation newAnnotation) {
        final ArrayList annotations = new ArrayList();
        td.accept((ASTVisitor)new DefaultAstVisitor(){

            public boolean visitNode(ASTNode node) {
                return false;
            }

            public boolean visit(TypeDeclaration node) {
                return node == td;
            }

            public boolean visit(MarkerAnnotation node) {
                annotations.add(node);
                return super.visit(node);
            }

            public boolean visit(NormalAnnotation node) {
                annotations.add(node);
                return super.visit(node);
            }

            public boolean visit(SingleMemberAnnotation node) {
                annotations.add(node);
                return super.visit(node);
            }
        });
        if (annotations.size() > 0) {
            int newAnnotLen = newAnnotation.getTypeName().getFullyQualifiedName().length() + newAnnotValue.length() + 3;
            Annotation[] orderedAnnotations = annotations.toArray(new Annotation[annotations.size()]);
            int i = orderedAnnotations.length - 1;
            while (i >= 0) {
                int len = orderedAnnotations[i].getLength();
                if (len > 0 && len >= newAnnotLen) {
                    return orderedAnnotations[i];
                }
                --i;
            }
        }
        for (Object o : td.modifiers()) {
            if (!(o instanceof Modifier)) continue;
            return (Modifier)o;
        }
        return null;
    }

    private boolean isClassIdImportPresent(ICompilationUnit icu) throws JavaModelException {
        IImportDeclaration[] iImportDeclarationArray = icu.getImports();
        int n = iImportDeclarationArray.length;
        int n2 = 0;
        while (n2 < n) {
            IImportDeclaration importDecl = iImportDeclarationArray[n2];
            if ("org.eclipse.scout.commons.annotations.ClassId".equals(importDecl.getElementName())) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private ClassIdTarget getTarget(ASTNode selectedNode) {
        if (selectedNode != null && selectedNode.getParent() != null && (selectedNode.getNodeType() == 42 || selectedNode.getNodeType() == 40 || selectedNode.getNodeType() == 83 || selectedNode.getNodeType() == 55)) {
            IJavaElement javaElement;
            TypeDeclaration typeDecl = null;
            if (selectedNode.getParent().getNodeType() == 55) {
                typeDecl = (TypeDeclaration)selectedNode.getParent();
            } else if (selectedNode.getNodeType() == 55) {
                typeDecl = (TypeDeclaration)selectedNode;
            } else {
                return null;
            }
            ITypeBinding resolveTypeBinding = typeDecl.resolveBinding();
            if (resolveTypeBinding != null && TypeUtility.exists((IJavaElement)(javaElement = resolveTypeBinding.getJavaElement())) && javaElement.getElementType() == 7) {
                IType t = (IType)javaElement;
                try {
                    ITypeHierarchy superTypeHierarchy;
                    IType filterType;
                    if (!t.isBinary() && !t.isAnonymous() && TypeUtility.exists((IJavaElement)(filterType = TypeUtility.getType((String)"org.eclipse.scout.commons.ITypeWithClassId"))) && (superTypeHierarchy = TypeUtility.getSupertypeHierarchy((IType)t)).contains(filterType)) {
                        IAnnotation annotation = JdtUtility.getAnnotation((IAnnotatable)t, (String)"org.eclipse.scout.commons.annotations.ClassId");
                        return new ClassIdTarget(typeDecl, t, annotation);
                    }
                }
                catch (JavaModelException e) {
                    ScoutSdkUi.logError("Unable to check if type '" + t.getFullyQualifiedName() + "' is anonymous.", e);
                }
            }
        }
        return null;
    }

    private static final class ClassIdAddProposal
    extends CUCorrectionProposal {
        private final CompilationUnitRewrite m_rewrite;

        private ClassIdAddProposal(CompilationUnitRewrite cur) {
            super("Add @ClassId annotation", cur.getCu(), 100, JavaPluginImages.get((String)"org.eclipse.jdt.ui.correction_change.gif"));
            this.m_rewrite = cur;
        }

        @Override
        protected void addEdits(IDocument document, TextEdit editRoot) throws CoreException {
            Map options = this.m_rewrite.getCu().getJavaProject().getOptions(true);
            editRoot.addChild(this.m_rewrite.getASTRewrite().rewriteAST(document, options));
            if (this.m_rewrite.getImportRewrite().hasRecordedChanges()) {
                editRoot.addChild(this.m_rewrite.getImportRewrite().rewriteImports(null));
            }
        }
    }

    private static final class ClassIdTarget {
        private final TypeDeclaration td;
        private final IType type;
        private final IAnnotation annotation;

        private ClassIdTarget(TypeDeclaration td, IType type, IAnnotation annotation) {
            this.td = td;
            this.type = type;
            this.annotation = annotation;
        }
    }

    private static final class EditDocumentationProposal
    implements IJavaCompletionProposal {
        private final ClassIdDocumentationSupport m_support;

        private EditDocumentationProposal(ClassIdDocumentationSupport support) {
            this.m_support = support;
        }

        public void apply(IDocument document) {
            Shell shell = ScoutSdkUi.getShell();
            if (shell != null) {
                this.m_support.editDocumentation(shell);
            }
        }

        public Point getSelection(IDocument document) {
            return null;
        }

        public String getAdditionalProposalInfo() {
            return Texts.get((String)"EditDocumentationForClass", (String[])new String[]{this.m_support.getType().getFullyQualifiedName().replace('$', '.')});
        }

        public String getDisplayString() {
            return Texts.get((String)"EditDocumentation");
        }

        public Image getImage() {
            return ScoutSdkUi.getImage("text.png");
        }

        public IContextInformation getContextInformation() {
            return null;
        }

        public int getRelevance() {
            return 0;
        }
    }
}

