/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.fields.javacode;

import org.eclipse.jface.fieldassist.IControlContentAdapter;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Control;

public class JavaCodeFieldContentAdapter
implements IControlContentAdapter {
    public String getControlContents(Control control) {
        return ((StyledText)control).getText();
    }

    public void setControlContents(Control control, String text, int cursorPosition) {
        StyledText tc = (StyledText)control;
        int currentCursorPosition = tc.getSelection().x;
        String newTextBefore = tc.getText().substring(0, currentCursorPosition);
        String newTextAfter = tc.getText().substring(tc.getSelection().y);
        newTextBefore = newTextBefore.replaceFirst("[a-zA-Z$_]*$", text);
        String newText = String.valueOf(newTextBefore) + newTextAfter;
        ((StyledText)control).setText(newText);
        ((StyledText)control).setSelection(newTextBefore.length(), newTextBefore.length());
    }

    public void insertControlContents(Control control, String text, int cursorPosition) {
        Point selection = ((StyledText)control).getSelection();
        ((StyledText)control).insert(text);
        if (cursorPosition < text.length()) {
            ((StyledText)control).setSelection(selection.x + cursorPosition, selection.x + cursorPosition);
        }
    }

    public int getCursorPosition(Control control) {
        return ((StyledText)control).getCaretOffset();
    }

    public Rectangle getInsertionBounds(Control control) {
        StyledText text = (StyledText)control;
        Point caretOrigin = text.getCaret().getLocation();
        return new Rectangle(caretOrigin.x, caretOrigin.y, 1, text.getLineHeight());
    }

    public void setCursorPosition(Control control, int position) {
        ((StyledText)control).setSelection(new Point(position, position));
    }
}

