/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.internal.extensions;

import org.eclipse.jdt.core.IType;
import org.eclipse.scout.sdk.ui.extensions.AbstractInnerTypeWizard;
import org.eclipse.scout.sdk.ui.extensions.IFormFieldExtension;
import org.eclipse.scout.sdk.ui.internal.ScoutSdkUi;
import org.eclipse.scout.sdk.ui.view.outline.pages.AbstractScoutTypePage;
import org.eclipse.scout.sdk.ui.view.outline.pages.IPage;

public class FormFieldExtension
implements IFormFieldExtension {
    private final IType m_modelType;
    private final String m_name;
    private Class<? extends AbstractInnerTypeWizard> m_newWizardClazz;
    private Class<? extends AbstractScoutTypePage> m_nodePageClazz;
    private boolean m_inShortList;

    public FormFieldExtension(String name, IType modelType) {
        this.m_name = name;
        this.m_modelType = modelType;
    }

    @Override
    public AbstractInnerTypeWizard createNewWizard() {
        if (this.m_newWizardClazz == null) {
            ScoutSdkUi.logWarning("new Wizard is not defined");
            return null;
        }
        try {
            return this.m_newWizardClazz.newInstance();
        }
        catch (Exception e) {
            ScoutSdkUi.logError("could not instansiate new wizard '" + this.m_newWizardClazz.getName() + "'.", e);
            return null;
        }
    }

    @Override
    public IPage createNodePage() {
        if (this.m_nodePageClazz == null) {
            ScoutSdkUi.logWarning("node page is not defined");
            return null;
        }
        try {
            AbstractScoutTypePage nodePage = this.m_nodePageClazz.newInstance();
            return nodePage;
        }
        catch (Exception e) {
            ScoutSdkUi.logError("could not instansiate nodePage '" + this.m_nodePageClazz.getName() + "'.", e);
            return null;
        }
    }

    @Override
    public String getName() {
        return this.m_name;
    }

    @Override
    public IType getModelType() {
        return this.m_modelType;
    }

    @Override
    public Class<? extends AbstractInnerTypeWizard> getNewWizardClazz() {
        return this.m_newWizardClazz;
    }

    public void setNewWizardClazz(Class<? extends AbstractInnerTypeWizard> newWizardClazz) {
        this.m_newWizardClazz = newWizardClazz;
    }

    @Override
    public Class<? extends AbstractScoutTypePage> getNodePage() {
        return this.m_nodePageClazz;
    }

    public void setNodePage(Class<? extends AbstractScoutTypePage> nodePage) {
        this.m_nodePageClazz = nodePage;
    }

    @Override
    public boolean isInShortList() {
        return this.m_inShortList;
    }

    public void setInShortList(boolean isShortList) {
        this.m_inShortList = isShortList;
    }
}

