/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.internal.view.outline.pages.project.client.wizard;

import java.util.Set;
import org.eclipse.jdt.core.IType;
import org.eclipse.scout.sdk.Texts;
import org.eclipse.scout.sdk.ui.action.IScoutHandler;
import org.eclipse.scout.sdk.ui.action.WellformAction;
import org.eclipse.scout.sdk.ui.action.create.WizardNewAction;
import org.eclipse.scout.sdk.ui.internal.ScoutSdkUi;
import org.eclipse.scout.sdk.ui.internal.view.outline.pages.project.client.wizard.WizardNodePage;
import org.eclipse.scout.sdk.ui.view.outline.pages.AbstractPage;
import org.eclipse.scout.sdk.ui.view.outline.pages.IPage;
import org.eclipse.scout.sdk.util.type.TypeComparators;
import org.eclipse.scout.sdk.util.type.TypeUtility;
import org.eclipse.scout.sdk.util.typecache.ICachedTypeHierarchy;
import org.eclipse.scout.sdk.util.typecache.ITypeHierarchyChangedListener;
import org.eclipse.scout.sdk.workspace.IScoutBundle;
import org.eclipse.scout.sdk.workspace.type.ScoutTypeFilters;

public class WizardTablePage
extends AbstractPage {
    private ICachedTypeHierarchy m_wizardHierarchy;

    public WizardTablePage(IPage parent) {
        this.setName(Texts.get((String)"WizardTablePage"));
        this.setParent(parent);
        this.setImageDescriptor(ScoutSdkUi.getImageDescriptor("wizzards.png"));
    }

    @Override
    public void unloadPage() {
        if (this.m_wizardHierarchy != null) {
            this.m_wizardHierarchy.removeHierarchyListener((ITypeHierarchyChangedListener)this.getPageDirtyListener());
        }
        super.unloadPage();
    }

    @Override
    public void refresh(boolean clearCache) {
        if (clearCache && this.m_wizardHierarchy != null) {
            this.m_wizardHierarchy.invalidate();
        }
        super.refresh(clearCache);
    }

    @Override
    public String getPageId() {
        return "org.eclipse.scout.sdk.page.WizardTablePage";
    }

    @Override
    public boolean isFolder() {
        return true;
    }

    @Override
    protected void loadChildrenImpl() {
        IType iWizard = TypeUtility.getType((String)"org.eclipse.scout.rt.client.ui.wizard.IWizard");
        if (this.m_wizardHierarchy == null) {
            this.m_wizardHierarchy = TypeUtility.getPrimaryTypeHierarchy((IType)iWizard);
            this.m_wizardHierarchy.addHierarchyListener((ITypeHierarchyChangedListener)this.getPageDirtyListener());
        }
        Set searchForms = this.m_wizardHierarchy.getAllSubtypes(iWizard, ScoutTypeFilters.getClassesInScoutBundles((IScoutBundle)this.getScoutBundle()), TypeComparators.getTypeNameComparator());
        for (IType searchForm : searchForms) {
            new WizardNodePage(this, searchForm);
        }
    }

    @Override
    public Set<Class<? extends IScoutHandler>> getSupportedMenuActions() {
        return this.newSet(WellformAction.class, WizardNewAction.class);
    }
}

