/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.internal.view.outline.pages.project.shared;

import java.util.Set;
import java.util.TreeMap;
import org.eclipse.jdt.core.IElementChangedListener;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.scout.sdk.Texts;
import org.eclipse.scout.sdk.ui.action.IScoutHandler;
import org.eclipse.scout.sdk.ui.action.create.SharedContextBeanPropertyNewAction;
import org.eclipse.scout.sdk.ui.internal.ScoutSdkUi;
import org.eclipse.scout.sdk.ui.internal.view.outline.pages.project.shared.SharedContextPropertyNodePage;
import org.eclipse.scout.sdk.ui.view.outline.pages.AbstractPage;
import org.eclipse.scout.sdk.ui.view.outline.pages.IPage;
import org.eclipse.scout.sdk.util.jdt.AbstractElementChangedListener;
import org.eclipse.scout.sdk.util.type.IMethodFilter;
import org.eclipse.scout.sdk.util.type.IPropertyBean;
import org.eclipse.scout.sdk.util.type.PropertyBean;
import org.eclipse.scout.sdk.util.type.TypeUtility;

public class SharedContextPropertyTablePage
extends AbstractPage {
    private final IType m_clientSession;
    private final IType m_serverSession;
    private P_MethodChangedListener m_methodChangedListener;

    public SharedContextPropertyTablePage(IPage parent, IType clientSession, IType serverSession) {
        this.setParent(parent);
        this.m_clientSession = clientSession;
        this.m_serverSession = serverSession;
        this.setName(Texts.get((String)"SharedContextTablePage", (String[])new String[]{clientSession.getElementName()}));
        this.setImageDescriptor(ScoutSdkUi.getImageDescriptor("variables.png"));
    }

    @Override
    public void unloadPage() {
        if (this.m_methodChangedListener != null) {
            JavaCore.removeElementChangedListener((IElementChangedListener)this.m_methodChangedListener);
        }
        super.unloadPage();
    }

    @Override
    public String getPageId() {
        return "org.eclipse.scout.sdk.page.SharedContextPropertyTablePage";
    }

    @Override
    public boolean isFolder() {
        return true;
    }

    @Override
    protected void loadChildrenImpl() {
        if (this.m_methodChangedListener == null) {
            this.m_methodChangedListener = new P_MethodChangedListener();
            JavaCore.addElementChangedListener((IElementChangedListener)this.m_methodChangedListener);
        }
        P_PropertyMethodFilter clientFilter = new P_PropertyMethodFilter();
        TypeUtility.getMethods((IType)this.getClientSession(), (IMethodFilter)clientFilter, null);
        P_PropertyMethodFilter serverFilter = new P_PropertyMethodFilter();
        TypeUtility.getMethods((IType)this.getServerSession(), (IMethodFilter)serverFilter, null);
        for (IPropertyBean iPropertyBean : serverFilter.m_beans.values()) {
            IPropertyBean clientBean = (IPropertyBean)clientFilter.m_beans.get(iPropertyBean.getBeanName());
            if (clientBean == null) continue;
            new SharedContextPropertyNodePage(this, clientBean, iPropertyBean);
        }
    }

    @Override
    public Set<Class<? extends IScoutHandler>> getSupportedMenuActions() {
        return this.newSet(SharedContextBeanPropertyNewAction.class);
    }

    public IType getClientSession() {
        return this.m_clientSession;
    }

    public IType getServerSession() {
        return this.m_serverSession;
    }

    private class P_MethodChangedListener
    extends AbstractElementChangedListener {
        private P_MethodChangedListener() {
        }

        protected boolean visit(int kind, int flags, IJavaElement e, CompilationUnit ast) {
            IType declaringType;
            if (e != null && e.getElementType() == 9 && ((declaringType = ((IMethod)e).getDeclaringType()).equals(SharedContextPropertyTablePage.this.getClientSession()) || declaringType.equals(SharedContextPropertyTablePage.this.getServerSession()))) {
                SharedContextPropertyTablePage.this.markStructureDirty();
                return false;
            }
            return super.visit(kind, flags, e, ast);
        }
    }

    private class P_PropertyMethodFilter
    implements IMethodFilter {
        TreeMap<String, PropertyBean> m_beans = new TreeMap();

        private P_PropertyMethodFilter() {
        }

        public boolean accept(IMethod candidate) {
            if (TypeUtility.exists((IJavaElement)candidate)) {
                try {
                    String source = candidate.getSource();
                    if (source != null) {
                        if (source.contains("setSharedContextVariable")) {
                            String propName = candidate.getElementName();
                            PropertyBean bean = this.m_beans.get(propName = propName.replaceFirst("^set", ""));
                            if (bean == null) {
                                bean = new PropertyBean(candidate.getDeclaringType(), propName);
                                this.m_beans.put(propName, bean);
                            }
                            bean.setWriteMethod(candidate);
                        } else if (source.contains("getSharedContextVariable")) {
                            String propName = candidate.getElementName();
                            PropertyBean bean = this.m_beans.get(propName = propName.replaceFirst("^(get|is)", ""));
                            if (bean == null) {
                                bean = new PropertyBean(candidate.getDeclaringType(), propName);
                                this.m_beans.put(propName, bean);
                            }
                            bean.setReadMethod(candidate);
                        }
                    }
                }
                catch (JavaModelException e) {
                    ScoutSdkUi.logError("could not parse method '" + candidate.getElementName() + "' on type '" + candidate.getDeclaringType().getFullyQualifiedName() + "'.", e);
                }
            }
            return false;
        }
    }
}

