/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.internal.view.properties.model.links;

import java.util.ArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.sdk.ui.internal.ScoutSdkUi;
import org.eclipse.scout.sdk.ui.internal.view.properties.model.links.AbstractLink;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.model.IWorkbenchAdapter;
import org.eclipse.ui.part.FileEditorInput;

public class FileOpenLink
extends AbstractLink {
    private final IFile m_file;
    private final String m_editorId;
    private ArrayList<Resource> m_allocatedResources = new ArrayList();

    public FileOpenLink(IFile file, int order) {
        this(file, order, null);
    }

    public FileOpenLink(IFile file, String displayName, int order) {
        this(file, displayName, order, null);
    }

    public FileOpenLink(IFile file, int order, String editorId) {
        this(file, file.getName(), order, editorId);
    }

    public FileOpenLink(IFile file, String displayName, int order, String editorId) {
        super(displayName, order);
        ImageDescriptor imageDescriptor;
        this.m_editorId = editorId;
        this.m_file = file;
        Image img = ScoutSdkUi.getImage("file.gif");
        IWorkbenchAdapter wbAdapter = (IWorkbenchAdapter)file.getAdapter(IWorkbenchAdapter.class);
        if (wbAdapter != null && (imageDescriptor = wbAdapter.getImageDescriptor((Object)file)) != null) {
            img = imageDescriptor.createImage();
            this.m_allocatedResources.add((Resource)img);
        }
        this.setImage(img);
    }

    @Override
    public void dispose() {
        super.dispose();
        for (Resource r : this.m_allocatedResources) {
            try {
                r.dispose();
            }
            catch (Exception e) {
                ScoutSdkUi.logWarning("could not dispose resource '" + r + "'.", e);
            }
        }
    }

    @Override
    public void execute() {
        try {
            IWorkbenchPage activePage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
            if (StringUtility.isNullOrEmpty((CharSequence)this.m_editorId)) {
                IDE.openEditor((IWorkbenchPage)activePage, (IFile)this.getFile(), (boolean)true);
            } else {
                activePage.openEditor((IEditorInput)new FileEditorInput(this.getFile()), this.m_editorId, true, 3);
            }
        }
        catch (Exception e) {
            ScoutSdkUi.logError(e);
        }
    }

    public IFile getFile() {
        return this.m_file;
    }
}

