/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.internal.view.properties.presenter.single;

import java.util.ArrayList;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.scout.commons.CollectionUtility;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.sdk.ui.fields.proposal.ContentProposalProvider;
import org.eclipse.scout.sdk.ui.fields.proposal.ProposalTextField;
import org.eclipse.scout.sdk.ui.fields.proposal.javaelement.JavaElementLabelProvider;
import org.eclipse.scout.sdk.ui.view.properties.PropertyViewFormToolkit;
import org.eclipse.scout.sdk.ui.view.properties.presenter.single.AbstractTypeProposalPresenter;
import org.eclipse.scout.sdk.util.IRegEx;
import org.eclipse.scout.sdk.util.type.TypeComparators;
import org.eclipse.scout.sdk.util.type.TypeUtility;
import org.eclipse.scout.sdk.workspace.IScoutBundle;
import org.eclipse.scout.sdk.workspace.type.ScoutTypeFilters;
import org.eclipse.scout.sdk.workspace.type.ScoutTypeUtility;
import org.eclipse.scout.sdk.workspace.type.config.ConfigurationMethod;
import org.eclipse.swt.widgets.Composite;

public class SearchFormPresenter
extends AbstractTypeProposalPresenter {
    public SearchFormPresenter(PropertyViewFormToolkit toolkit, Composite parent) {
        super(toolkit, parent);
    }

    @Override
    protected void createProposalFieldProviders(ProposalTextField proposalField) {
        JavaElementLabelProvider labelProvider = new JavaElementLabelProvider();
        this.getProposalField().setLabelProvider((IBaseLabelProvider)labelProvider);
        this.getProposalField().setContentProvider(new P_ContentProvider(labelProvider));
    }

    @Override
    protected void init(ConfigurationMethod method) throws CoreException {
        if (method != null) {
            this.getProposalField().setInput(method.getType());
            super.init(method);
        } else {
            this.getProposalField().setInput(null);
        }
    }

    private final class P_ContentProvider
    extends ContentProposalProvider {
        private Set<IType> m_proposals;
        private final ILabelProvider m_labelProvider;

        private P_ContentProvider(ILabelProvider labelProvider) {
            this.m_labelProvider = labelProvider;
        }

        @Override
        public Object[] getProposals(String searchPattern, IProgressMonitor monitor) {
            this.ensureCache();
            searchPattern = !StringUtility.hasText((CharSequence)searchPattern) ? "*" : String.valueOf(IRegEx.STAR_END.matcher(searchPattern).replaceAll("")) + "*";
            char[] pattern = CharOperation.toLowerCase((char[])searchPattern.toCharArray());
            ArrayList<IType> collector = new ArrayList<IType>(this.m_proposals.size());
            for (IType proposal : this.m_proposals) {
                if (!CharOperation.match((char[])pattern, (char[])this.m_labelProvider.getText((Object)proposal).toCharArray(), (boolean)false)) continue;
                collector.add(proposal);
            }
            return collector.toArray(new Object[collector.size()]);
        }

        @Override
        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            if (this.m_proposals != null) {
                this.m_proposals = null;
            }
        }

        private void ensureCache() {
            if (this.m_proposals == null) {
                if (SearchFormPresenter.this.getMethod() != null) {
                    IScoutBundle sb = ScoutTypeUtility.getScoutBundle((IJavaElement)SearchFormPresenter.this.getMethod().getType());
                    IType iSearchForm = TypeUtility.getType((String)"org.eclipse.scout.rt.client.ui.desktop.outline.pages.ISearchForm");
                    this.m_proposals = TypeUtility.getPrimaryTypeHierarchy((IType)iSearchForm).getAllSubtypes(iSearchForm, ScoutTypeFilters.getClassesInScoutBundles((IScoutBundle)sb), TypeComparators.getTypeNameComparator());
                } else {
                    this.m_proposals = CollectionUtility.hashSet((Object[])new IType[0]);
                }
            }
        }
    }
}

