/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.internal.wizard.export;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.scout.sdk.ui.fields.bundletree.ITreeNode;
import org.eclipse.scout.sdk.ui.fields.bundletree.ITreeNodeFilter;
import org.eclipse.scout.sdk.ui.internal.ScoutSdkUi;
import org.eclipse.scout.sdk.util.pde.ProductFileModelHelper;

public class DeployableProductFileNodeFilter
implements ITreeNodeFilter {
    public static final String BUNDLE_ID_HTTP_REGISTRY = "org.eclipse.equinox.http.registry";
    public static final String BUNDLE_ID_HTTP_SERVLETBRIDGE = "org.eclipse.equinox.http.servletbridge";
    private final String m_bundleSymbolicNameFilter;

    public DeployableProductFileNodeFilter(String bundleSymbolicNameFilter) {
        this.m_bundleSymbolicNameFilter = bundleSymbolicNameFilter;
    }

    @Override
    public boolean accept(ITreeNode node) {
        if ("zz_product_node".equals(node.getType())) {
            IFile productFile = (IFile)node.getData();
            try {
                ProductFileModelHelper pfmh = new ProductFileModelHelper(productFile);
                return pfmh.ProductFile.existsDependency(this.m_bundleSymbolicNameFilter) && this.getServletBridgeProductStatus(pfmh).isOK();
            }
            catch (CoreException e) {
                ScoutSdkUi.logError("Unable to parse product '" + productFile.getFullPath().toOSString() + "'.", e);
                return false;
            }
        }
        return true;
    }

    private IStatus getServletBridgeProductStatus(ProductFileModelHelper h) throws CoreException {
        if (!h.ProductFile.isValid()) {
            return new Status(4, "org.eclipse.scout.sdk.ui", "product file is not valid.");
        }
        if (!h.ProductFile.existsDependency(BUNDLE_ID_HTTP_REGISTRY)) {
            return new Status(4, "org.eclipse.scout.sdk.ui", "product must contain 'org.eclipse.equinox.http.registry' as required bundle.");
        }
        if (!h.ProductFile.existsDependency(BUNDLE_ID_HTTP_SERVLETBRIDGE)) {
            return new Status(4, "org.eclipse.scout.sdk.ui", "product must contain 'org.eclipse.equinox.http.servletbridge' as required bundle.");
        }
        String osgiBundleEntry = h.ConfigurationFile.getOsgiBundlesEntry();
        if (osgiBundleEntry == null) {
            return new Status(4, "org.eclipse.scout.sdk.ui", "osgi.bundles entry in config.ini is missing.");
        }
        if (!osgiBundleEntry.contains(BUNDLE_ID_HTTP_SERVLETBRIDGE)) {
            return new Status(4, "org.eclipse.scout.sdk.ui", "osgi.bundles entry in config.ini file must conatin 'org.eclipse.equinox.http.servletbridge' bundle.");
        }
        if (!osgiBundleEntry.contains(BUNDLE_ID_HTTP_REGISTRY)) {
            return new Status(4, "org.eclipse.scout.sdk.ui", "osgi.bundles entry in config.ini file must conatin 'org.eclipse.equinox.http.registry' bundle.");
        }
        return Status.OK_STATUS;
    }
}

