/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.view.properties.part.singlepage;

import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.scout.commons.CollectionUtility;
import org.eclipse.scout.sdk.ui.view.properties.part.ISection;
import org.eclipse.scout.sdk.ui.view.properties.part.singlepage.JdtTypePropertyPart;
import org.eclipse.scout.sdk.ui.view.properties.part.singlepage.PropertyViewConfig;
import org.eclipse.scout.sdk.workspace.type.config.ConfigPropertyType;
import org.eclipse.scout.sdk.workspace.type.config.ConfigurationMethod;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.events.ExpansionAdapter;
import org.eclipse.ui.forms.events.ExpansionEvent;
import org.eclipse.ui.forms.events.IExpansionListener;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class ConfigurationMethodSection {
    private static final PropertyViewConfig CONFIG = new PropertyViewConfig();
    private static final FormToolkit TOOLKIT = new FormToolkit(Display.getDefault());
    private final Set<ConfigurationMethodEx> m_methods;
    private ISection m_section;
    private int m_numCategories;

    public ConfigurationMethodSection(ConfigPropertyType t, int methodType, PropertyViewConfig.ConfigTypes configurationType) {
        this.m_methods = this.getConfigMethods(t, methodType, configurationType);
    }

    public ISection createContent(JdtTypePropertyPart parent, String id, String label, boolean expanded) {
        if (this.m_methods != null && this.m_methods.size() > 0) {
            this.m_numCategories = this.getCategoryCount();
            this.m_section = this.createSection(parent, id, label, expanded);
        }
        return this.m_section;
    }

    private ISection createSection(final JdtTypePropertyPart part, String id, String label, boolean expanded) {
        final ISection section = part.addSection(id, label);
        section.setExpanded(expanded);
        final Composite clientSection = section.getSectionClient();
        GridLayout layout = new GridLayout(1, true);
        layout.horizontalSpacing = 0;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.verticalSpacing = 0;
        clientSection.setLayout((Layout)layout);
        if (expanded) {
            this.createCategories(clientSection, part, section);
        } else {
            section.addExpansionListener((IExpansionListener)new ExpansionAdapter(){

                public void expansionStateChanging(ExpansionEvent e) {
                    if (e.getState()) {
                        ConfigurationMethodSection.this.createCategories(clientSection, part, section);
                        section.removeExpansionListener((IExpansionListener)this);
                    }
                }
            });
        }
        return section;
    }

    private void createCategories(Composite parent, JdtTypePropertyPart part, ISection section) {
        PropertyViewConfig.ConfigCategory curCat = null;
        Composite curCatContainer = null;
        for (ConfigurationMethodEx m : this.m_methods) {
            if (!m.m_category.equals((Object)curCat)) {
                curCat = m.m_category;
                if (this.m_numCategories > 1) {
                    this.createCategoryHeading(parent, curCat.getLabel());
                }
                curCatContainer = this.createCategory(parent, section);
            }
            if (m.m_configMethod.getMethodType() == 1) {
                part.createConfigMethodPresenter(curCatContainer, m.m_configMethod);
                continue;
            }
            if (m.m_configMethod.getMethodType() != 2) continue;
            part.createOperationPresenter(curCatContainer, m.m_configMethod);
        }
    }

    private Composite createCategory(Composite parent, ISection section) {
        Composite category = TOOLKIT.createComposite(parent);
        GridLayout catLayout = new GridLayout(1, true);
        catLayout.marginHeight = 0;
        catLayout.marginWidth = 0;
        catLayout.verticalSpacing = 0;
        category.setLayout((Layout)catLayout);
        category.setLayoutData((Object)new GridData(768));
        return category;
    }

    private Composite createCategoryHeading(Composite parent, String label) {
        Composite body = TOOLKIT.createComposite(parent);
        GridLayout bodyLayout = new GridLayout(2, false);
        bodyLayout.horizontalSpacing = 5;
        bodyLayout.marginHeight = 0;
        bodyLayout.marginWidth = 0;
        bodyLayout.verticalSpacing = 0;
        body.setLayout((Layout)bodyLayout);
        GridData bodyLayoutData = new GridData(768);
        body.setLayoutData((Object)bodyLayoutData);
        Label l = new Label(body, 0);
        l.setText(label);
        Label line = new Label(body, 266);
        line.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        return body;
    }

    private Set<ConfigurationMethodEx> getConfigMethods(ConfigPropertyType source, int methodType, PropertyViewConfig.ConfigTypes configurationType) {
        List allMethods = source.getConfigurationMethods(methodType);
        TreeSet<ConfigurationMethodEx> result = new TreeSet<ConfigurationMethodEx>();
        for (ConfigurationMethod m : allMethods) {
            ConfigurationMethodEx cme = new ConfigurationMethodEx(m);
            if (!cme.m_configType.equals((Object)configurationType)) continue;
            result.add(cme);
        }
        return result;
    }

    private int getCategoryCount() {
        PropertyViewConfig.ConfigCategory cat = ((ConfigurationMethodEx)CollectionUtility.firstElement(this.m_methods)).m_category;
        int ret = 1;
        for (ConfigurationMethodEx m : this.m_methods) {
            if (m.m_category.equals((Object)cat)) continue;
            cat = m.m_category;
            ++ret;
        }
        return ret;
    }

    private static final class ConfigurationMethodEx
    implements Comparable<ConfigurationMethodEx> {
        private final ConfigurationMethod m_configMethod;
        private final Double m_order;
        private final PropertyViewConfig.ConfigCategory m_category;
        private final PropertyViewConfig.ConfigTypes m_configType;

        private ConfigurationMethodEx(ConfigurationMethod configMethod) {
            this.m_configMethod = configMethod;
            PropertyViewConfig.Config c = CONFIG.getConfiguration(configMethod);
            Double o = null;
            o = c != null && c.getOrder() != null ? c.getOrder() : configMethod.getOrder();
            this.m_order = o == null ? Double.valueOf(Double.MAX_VALUE) : o;
            this.m_category = c == null ? PropertyViewConfig.DEFAULT_CONFIG_CATEGORY : c.getCategory();
            this.m_configType = c == null ? PropertyViewConfig.DEFAULT_CONFIG_TYPE : c.getType();
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof ConfigurationMethodEx)) {
                return false;
            }
            ConfigurationMethodEx other = (ConfigurationMethodEx)obj;
            return this.m_category.getOrder() == other.m_category.getOrder() && this.m_order.equals(other.m_order) && this.m_configMethod.getMethodName().equals(other.m_configMethod.getMethodName());
        }

        public int hashCode() {
            int hash = this.m_category.hashCode();
            hash ^= this.m_order.hashCode();
            return hash ^= this.m_configMethod.getMethodName().hashCode();
        }

        @Override
        public int compareTo(ConfigurationMethodEx o) {
            int catComp = Integer.valueOf(this.m_category.getOrder()).compareTo(o.m_category.getOrder());
            if (catComp != 0) {
                return catComp;
            }
            int orderComp = this.m_order.compareTo(o.m_order);
            if (orderComp != 0) {
                return orderComp;
            }
            return this.m_configMethod.getMethodName().compareTo(o.m_configMethod.getMethodName());
        }
    }
}

