/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.wizard.menu;

import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.nls.sdk.model.INlsEntry;
import org.eclipse.scout.sdk.Texts;
import org.eclipse.scout.sdk.extensions.runtime.classes.RuntimeClasses;
import org.eclipse.scout.sdk.operation.MenuNewOperation;
import org.eclipse.scout.sdk.ui.fields.StyledTextField;
import org.eclipse.scout.sdk.ui.fields.proposal.ContentProposalEvent;
import org.eclipse.scout.sdk.ui.fields.proposal.IProposalAdapterListener;
import org.eclipse.scout.sdk.ui.fields.proposal.ProposalTextField;
import org.eclipse.scout.sdk.ui.fields.proposal.SiblingProposal;
import org.eclipse.scout.sdk.ui.fields.proposal.javaelement.AbstractJavaElementContentProvider;
import org.eclipse.scout.sdk.ui.fields.proposal.javaelement.JavaElementAbstractTypeContentProvider;
import org.eclipse.scout.sdk.ui.fields.proposal.javaelement.SimpleJavaElementContentProvider;
import org.eclipse.scout.sdk.ui.internal.ScoutSdkUi;
import org.eclipse.scout.sdk.ui.wizard.AbstractWorkspaceWizardPage;
import org.eclipse.scout.sdk.util.NamingUtility;
import org.eclipse.scout.sdk.util.ScoutUtility;
import org.eclipse.scout.sdk.util.signature.SignatureCache;
import org.eclipse.scout.sdk.util.type.TypeUtility;
import org.eclipse.scout.sdk.util.typecache.IWorkingCopyManager;
import org.eclipse.scout.sdk.workspace.type.IStructuredType;
import org.eclipse.scout.sdk.workspace.type.ScoutTypeUtility;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;

public class MenuNewWizardPage
extends AbstractWorkspaceWizardPage {
    private static final String PROP_SIBLING = "sibling";
    private static final String PROP_FORM_TO_OPEN = "formToOpen";
    private static final String PROP_FORM_HANDLER = "formHandler";
    private final IType iMenuType = TypeUtility.getType((String)"org.eclipse.scout.rt.client.ui.action.menu.IMenu");
    private INlsEntry m_nlsName;
    private String m_typeName;
    private IType m_superType;
    private ProposalTextField m_nlsNameField;
    private StyledTextField m_typeNameField;
    private ProposalTextField m_superTypeField;
    private ProposalTextField m_siblingField;
    private ProposalTextField m_formToOpenField;
    private ProposalTextField m_formHandlerField;
    private final IType m_declaringType;
    private final IType m_abstractMenuType;
    private IType m_createdMenu;

    public MenuNewWizardPage(IType declaringType) {
        super(MenuNewWizardPage.class.getName());
        this.setTitle(Texts.get((String)"NewMenu"));
        this.setDescription(Texts.get((String)"CreateANewMenu"));
        this.m_declaringType = declaringType;
        this.m_superType = this.m_abstractMenuType = RuntimeClasses.getSuperType((String)"org.eclipse.scout.rt.client.ui.action.menu.IMenu", (IJavaProject)this.m_declaringType.getJavaProject());
        this.setSiblingInternal(SiblingProposal.SIBLING_END);
    }

    @Override
    protected void createContent(Composite parent) {
        this.m_nlsNameField = this.getFieldToolkit().createNlsProposalTextField(parent, ScoutTypeUtility.findNlsProject((IJavaElement)this.m_declaringType), Texts.get((String)"PropText"));
        this.m_nlsNameField.acceptProposal(this.m_nlsName);
        this.m_nlsNameField.addProposalAdapterListener(new IProposalAdapterListener(){

            @Override
            public void proposalAccepted(ContentProposalEvent event) {
                try {
                    MenuNewWizardPage.this.setStateChanging(true);
                    INlsEntry oldEntry = null;
                    oldEntry = MenuNewWizardPage.this.getNlsName();
                    MenuNewWizardPage.this.m_nlsName = (INlsEntry)event.proposal;
                    if (MenuNewWizardPage.this.m_nlsName != null && (oldEntry == null || oldEntry.getKey().equals(MenuNewWizardPage.this.m_typeNameField.getModifiableText()) || StringUtility.isNullOrEmpty((CharSequence)MenuNewWizardPage.this.m_typeNameField.getModifiableText()))) {
                        MenuNewWizardPage.this.m_typeNameField.setText(NamingUtility.toJavaCamelCase((String)MenuNewWizardPage.this.m_nlsName.getKey(), (boolean)false));
                    }
                }
                finally {
                    MenuNewWizardPage.this.setStateChanging(false);
                }
            }
        });
        this.m_typeNameField = this.getFieldToolkit().createStyledTextField(parent, Texts.get((String)"TypeName"));
        this.m_typeNameField.setReadOnlySuffix("Menu");
        this.m_typeNameField.setText(this.m_typeName);
        this.m_typeName = this.m_typeNameField.getText();
        this.m_typeNameField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                MenuNewWizardPage.this.m_typeName = MenuNewWizardPage.this.m_typeNameField.getText();
                MenuNewWizardPage.this.pingStateChanging();
            }
        });
        this.m_superTypeField = this.getFieldToolkit().createJavaElementProposalField(parent, Texts.get((String)"SuperType"), new JavaElementAbstractTypeContentProvider(this.iMenuType, this.getDeclaringType().getJavaProject(), this.m_abstractMenuType));
        this.m_superTypeField.acceptProposal(this.m_superType);
        this.m_superTypeField.addProposalAdapterListener(new IProposalAdapterListener(){

            @Override
            public void proposalAccepted(ContentProposalEvent event) {
                MenuNewWizardPage.this.m_superType = (IType)event.proposal;
                MenuNewWizardPage.this.pingStateChanging();
            }
        });
        this.m_siblingField = this.getFieldToolkit().createSiblingProposalField(parent, this.getDeclaringType(), this.iMenuType);
        this.m_siblingField.acceptProposal(this.getSibling());
        this.m_siblingField.addProposalAdapterListener(new IProposalAdapterListener(){

            @Override
            public void proposalAccepted(ContentProposalEvent event) {
                MenuNewWizardPage.this.setSiblingInternal((SiblingProposal)event.proposal);
                MenuNewWizardPage.this.pingStateChanging();
            }
        });
        Control formGroup = this.createFormGroup(parent);
        parent.setLayout((Layout)new GridLayout(1, true));
        this.m_nlsNameField.setLayoutData(new GridData(768));
        this.m_typeNameField.setLayoutData(new GridData(768));
        this.m_superTypeField.setLayoutData(new GridData(768));
        this.m_siblingField.setLayoutData(new GridData(768));
        formGroup.setLayoutData((Object)new GridData(768));
    }

    protected Control createFormGroup(Composite parent) {
        Group groupBox = new Group(parent, 16);
        this.m_formToOpenField = this.getFieldToolkit().createJavaElementProposalField((Composite)groupBox, Texts.get((String)"FormToStart"), new AbstractJavaElementContentProvider(){

            @Override
            protected Object[][] computeProposals() {
                IType iFormType = TypeUtility.getType((String)"org.eclipse.scout.rt.client.ui.form.IForm");
                Set forms = TypeUtility.getClassesOnClasspath((IType)iFormType, (IJavaProject)MenuNewWizardPage.this.getDeclaringType().getJavaProject(), null);
                return new Object[][]{forms.toArray(new IType[forms.size()])};
            }
        });
        this.m_formToOpenField.acceptProposal(this.getFormToOpen());
        this.m_formToOpenField.addProposalAdapterListener(new IProposalAdapterListener(){

            @Override
            public void proposalAccepted(ContentProposalEvent event) {
                try {
                    MenuNewWizardPage.this.setStateChanging(true);
                    MenuNewWizardPage.this.setFormToOpenInternal((IType)event.proposal);
                    SimpleJavaElementContentProvider formHandlerProvider = null;
                    IType formHandlerSelection = (IType)MenuNewWizardPage.this.m_formHandlerField.getSelectedProposal();
                    if (MenuNewWizardPage.this.getFormToOpen() != null) {
                        Set formHandlers = ScoutTypeUtility.getFormHandlers((IType)MenuNewWizardPage.this.getFormToOpen());
                        if (formHandlers != null) {
                            formHandlerProvider = new SimpleJavaElementContentProvider(formHandlers.toArray(new IType[formHandlers.size()]));
                        }
                        if (formHandlerSelection != null && !MenuNewWizardPage.this.getFormToOpen().equals(formHandlerSelection.getDeclaringType())) {
                            formHandlerSelection = null;
                        }
                        MenuNewWizardPage.this.m_formHandlerField.setEnabled(true);
                    } else {
                        MenuNewWizardPage.this.m_formHandlerField.setEnabled(false);
                    }
                    MenuNewWizardPage.this.m_formHandlerField.setContentProvider(formHandlerProvider);
                    MenuNewWizardPage.this.m_formHandlerField.setLabelProvider((IBaseLabelProvider)(formHandlerProvider == null ? null : formHandlerProvider.getLabelProvider()));
                    MenuNewWizardPage.this.m_formHandlerField.acceptProposal(formHandlerSelection);
                }
                finally {
                    MenuNewWizardPage.this.setStateChanging(false);
                }
            }
        });
        this.m_formHandlerField = this.getFieldToolkit().createProposalField((Composite)groupBox, Texts.get((String)"FormHandler"));
        this.m_formHandlerField.setEnabled(false);
        this.m_formHandlerField.acceptProposal(this.getHandler());
        this.m_formHandlerField.addProposalAdapterListener(new IProposalAdapterListener(){

            @Override
            public void proposalAccepted(ContentProposalEvent event) {
                MenuNewWizardPage.this.setFormHandlerInternal((IType)event.proposal);
                MenuNewWizardPage.this.pingStateChanging();
            }
        });
        groupBox.setLayout((Layout)new GridLayout(1, true));
        this.m_formToOpenField.setLayoutData(new GridData(768));
        this.m_formHandlerField.setLayoutData(new GridData(768));
        return groupBox;
    }

    @Override
    public boolean performFinish(IProgressMonitor monitor, IWorkingCopyManager manager) throws CoreException {
        MenuNewOperation operation = new MenuNewOperation(this.getTypeName(), this.getDeclaringType(), true);
        operation.setNlsEntry(this.getNlsName());
        IType superType = this.getSuperType();
        if (superType != null) {
            String signature = SignatureCache.createTypeSignature((String)superType.getFullyQualifiedName());
            operation.setSuperTypeSignature(signature);
        }
        if (this.getSibling() == SiblingProposal.SIBLING_END || this.getSibling() == null) {
            IStructuredType structuredType = ScoutTypeUtility.createStructuredType((IType)this.m_declaringType);
            operation.setSibling(structuredType.getSibling(IStructuredType.CATEGORIES.TYPE_MENU));
        } else {
            operation.setSibling(this.getSibling().getElement());
        }
        operation.setFormToOpen(this.getFormToOpen());
        operation.setFormHandler(this.getHandler());
        operation.run(monitor, manager);
        this.m_createdMenu = operation.getCreatedMenu();
        return true;
    }

    @Override
    protected void validatePage(MultiStatus multiStatus) {
        try {
            multiStatus.add(this.getStatusNameField());
            multiStatus.add(this.getStatusSuperType());
        }
        catch (JavaModelException e) {
            ScoutSdkUi.logError("could not validate name field.", e);
        }
    }

    protected IStatus getStatusNameField() throws JavaModelException {
        IStatus javaFieldNameStatus = ScoutUtility.validateJavaName((String)this.getTypeName(), (String)"Menu");
        if (javaFieldNameStatus.getSeverity() > 2) {
            return javaFieldNameStatus;
        }
        if (TypeUtility.hasInnerType((IType)this.m_declaringType, (String)this.getTypeName())) {
            return new Status(4, "org.eclipse.scout.sdk.ui", Texts.get((String)"Error_nameAlreadyUsed"));
        }
        return javaFieldNameStatus;
    }

    protected IStatus getStatusSuperType() throws JavaModelException {
        if (this.getSuperType() == null) {
            return new Status(4, "org.eclipse.scout.sdk.ui", Texts.get((String)"TheSuperTypeCanNotBeNull"));
        }
        return Status.OK_STATUS;
    }

    public IType getDeclaringType() {
        return this.m_declaringType;
    }

    public IType getCreatedMenu() {
        return this.m_createdMenu;
    }

    public INlsEntry getNlsName() {
        return this.m_nlsName;
    }

    public void setNlsName(INlsEntry nlsName) {
        try {
            this.setStateChanging(true);
            this.m_nlsName = nlsName;
            if (this.isControlCreated()) {
                this.m_nlsNameField.acceptProposal(nlsName);
            }
        }
        finally {
            this.setStateChanging(false);
        }
    }

    public String getTypeName() {
        return this.m_typeName;
    }

    public void setTypeName(String typeName) {
        try {
            this.setStateChanging(true);
            this.m_typeName = typeName;
            if (this.isControlCreated()) {
                this.m_typeNameField.setText(typeName);
            }
        }
        finally {
            this.setStateChanging(false);
        }
    }

    public IType getSuperType() {
        return this.m_superType;
    }

    public void setSuperType(IType superType) {
        try {
            this.setStateChanging(true);
            this.m_superType = superType;
            if (this.isControlCreated()) {
                this.m_superTypeField.acceptProposal(superType);
            }
        }
        finally {
            this.setStateChanging(false);
        }
    }

    public SiblingProposal getSibling() {
        return (SiblingProposal)this.getProperty(PROP_SIBLING);
    }

    public void setSibling(SiblingProposal sibling) {
        try {
            this.setStateChanging(true);
            this.setSiblingInternal(sibling);
            if (this.isControlCreated()) {
                this.m_siblingField.acceptProposal(sibling);
            }
        }
        finally {
            this.setStateChanging(false);
        }
    }

    private void setSiblingInternal(SiblingProposal sibling) {
        this.setProperty(PROP_SIBLING, sibling);
    }

    public IType getFormToOpen() {
        return (IType)this.getProperty(PROP_FORM_TO_OPEN);
    }

    public void setFormToOpen(IType formToOpen) {
        try {
            this.setStateChanging(true);
            this.setFormToOpenInternal(formToOpen);
            if (this.isControlCreated()) {
                this.m_formToOpenField.acceptProposal(formToOpen);
            }
        }
        finally {
            this.setStateChanging(false);
        }
    }

    private void setFormToOpenInternal(IType formToOpen) {
        this.setProperty(PROP_FORM_TO_OPEN, formToOpen);
    }

    public IType getHandler() {
        return (IType)this.getProperty(PROP_FORM_HANDLER);
    }

    public void setFormHandler(IType formHandler) {
        try {
            this.setStateChanging(true);
            this.setFormHandlerInternal(formHandler);
            if (this.isControlCreated()) {
                this.m_formHandlerField.acceptProposal(formHandler);
            }
        }
        finally {
            this.setStateChanging(false);
        }
    }

    private void setFormHandlerInternal(IType formHandler) {
        this.setProperty(PROP_FORM_HANDLER, formHandler);
    }
}

