/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.wizard.page;

import java.util.Set;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.nls.sdk.model.INlsEntry;
import org.eclipse.scout.sdk.Texts;
import org.eclipse.scout.sdk.extensions.runtime.classes.RuntimeClasses;
import org.eclipse.scout.sdk.extensions.targetpackage.DefaultTargetPackage;
import org.eclipse.scout.sdk.ui.fields.StyledTextField;
import org.eclipse.scout.sdk.ui.fields.javacode.EntityTextField;
import org.eclipse.scout.sdk.ui.fields.proposal.ContentProposalEvent;
import org.eclipse.scout.sdk.ui.fields.proposal.IProposalAdapterListener;
import org.eclipse.scout.sdk.ui.fields.proposal.ProposalTextField;
import org.eclipse.scout.sdk.ui.fields.proposal.javaelement.AbstractJavaElementContentProvider;
import org.eclipse.scout.sdk.ui.internal.ScoutSdkUi;
import org.eclipse.scout.sdk.ui.wizard.AbstractWorkspaceWizardPage;
import org.eclipse.scout.sdk.util.NamingUtility;
import org.eclipse.scout.sdk.util.ScoutUtility;
import org.eclipse.scout.sdk.util.type.ITypeFilter;
import org.eclipse.scout.sdk.util.type.TypeFilters;
import org.eclipse.scout.sdk.util.type.TypeUtility;
import org.eclipse.scout.sdk.util.typecache.ITypeHierarchy;
import org.eclipse.scout.sdk.workspace.IScoutBundle;
import org.eclipse.scout.sdk.workspace.type.ScoutTypeFilters;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;

public class PageNewAttributesWizardPage
extends AbstractWorkspaceWizardPage {
    public static final String PROP_TYPE_NAME = "typeName";
    private final IType iPageWithNodes = TypeUtility.getType((String)"org.eclipse.scout.rt.client.ui.desktop.outline.pages.IPageWithNodes");
    private final IType iPageWithTable = TypeUtility.getType((String)"org.eclipse.scout.rt.client.ui.desktop.outline.pages.IPageWithTable");
    private final IType iOutline = TypeUtility.getType((String)"org.eclipse.scout.rt.client.ui.desktop.outline.IOutline");
    private INlsEntry m_nlsName;
    private IType m_superType;
    private IType m_holderType;
    private String m_nameSuffix;
    private String m_packageName;
    private ProposalTextField m_nlsNameField;
    private StyledTextField m_typeNameField;
    private ProposalTextField m_holderTypeField;
    private EntityTextField m_entityField;
    private boolean m_hoderTypeEnabled = true;
    private final IScoutBundle m_clientBundle;

    public PageNewAttributesWizardPage(IScoutBundle clientBundle) {
        super(PageNewAttributesWizardPage.class.getName());
        this.m_clientBundle = clientBundle;
        this.setTitle(Texts.get((String)"NewPage"));
        this.setDescription(Texts.get((String)"CreateANewPage"));
        this.setTargetPackage(DefaultTargetPackage.get((IScoutBundle)clientBundle, (String)"client.page"));
        this.m_nameSuffix = "";
        this.setSuperType(RuntimeClasses.getSuperType((String)"org.eclipse.scout.rt.client.ui.desktop.outline.pages.IPageWithNodes", (IScoutBundle)this.m_clientBundle));
    }

    @Override
    protected void createContent(Composite parent) {
        int labelColWidthPercent = 20;
        Group group = new Group(parent, 64);
        group.setText(Texts.get((String)"Page"));
        this.m_nlsNameField = this.getFieldToolkit().createNlsProposalTextField((Composite)group, this.getClientBundle().getNlsProject(), Texts.get((String)"PropTitle"), labelColWidthPercent);
        this.m_nlsNameField.acceptProposal(this.m_nlsName);
        this.m_nlsNameField.addProposalAdapterListener(new IProposalAdapterListener(){

            @Override
            public void proposalAccepted(ContentProposalEvent event) {
                try {
                    PageNewAttributesWizardPage.this.setStateChanging(true);
                    INlsEntry oldEntry = PageNewAttributesWizardPage.this.getNlsName();
                    PageNewAttributesWizardPage.this.m_nlsName = (INlsEntry)event.proposal;
                    if (PageNewAttributesWizardPage.this.m_nlsName != null && (oldEntry == null || oldEntry.getKey().equals(PageNewAttributesWizardPage.this.m_typeNameField.getModifiableText()) || StringUtility.isNullOrEmpty((CharSequence)PageNewAttributesWizardPage.this.m_typeNameField.getModifiableText()))) {
                        PageNewAttributesWizardPage.this.m_typeNameField.setText(NamingUtility.toJavaCamelCase((String)PageNewAttributesWizardPage.this.m_nlsName.getKey(), (boolean)false));
                    }
                }
                finally {
                    PageNewAttributesWizardPage.this.setStateChanging(false);
                }
            }
        });
        this.m_typeNameField = this.getFieldToolkit().createStyledTextField((Composite)group, Texts.get((String)"TypeName"), labelColWidthPercent);
        this.m_typeNameField.setReadOnlySuffix(this.m_nameSuffix);
        this.m_typeNameField.setText(this.getTypeName());
        this.setTypeNameInternal(this.m_typeNameField.getText());
        this.m_typeNameField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                PageNewAttributesWizardPage.this.setTypeNameInternal(PageNewAttributesWizardPage.this.m_typeNameField.getText());
                PageNewAttributesWizardPage.this.pingStateChanging();
            }
        });
        if (DefaultTargetPackage.isPackageConfigurationEnabled()) {
            this.m_entityField = this.getFieldToolkit().createEntityTextField((Composite)group, Texts.get((String)"EntityTextField"), this.m_clientBundle, labelColWidthPercent);
            this.m_entityField.setText(this.getTargetPackage());
            this.m_entityField.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    PageNewAttributesWizardPage.this.setTargetPackageInternal(PageNewAttributesWizardPage.this.m_entityField.getText());
                    PageNewAttributesWizardPage.this.pingStateChanging();
                }
            });
            this.m_entityField.setLayoutData(new GridData(768));
        }
        Control parentPageControl = this.createParentPageGroup(parent);
        parent.setLayout((Layout)new GridLayout(1, true));
        group.setLayout((Layout)new GridLayout(1, true));
        group.setLayoutData((Object)new GridData(768));
        this.m_nlsNameField.setLayoutData(new GridData(768));
        this.m_typeNameField.setLayoutData(new GridData(768));
        parentPageControl.setLayoutData((Object)new GridData(768));
        this.m_nlsNameField.setFocus();
    }

    protected Control createParentPageGroup(Composite parent) {
        Group group = new Group(parent, 64);
        group.setText(Texts.get((String)"AddTo"));
        this.m_holderTypeField = this.getFieldToolkit().createJavaElementProposalField((Composite)group, Texts.get((String)"PageOutline"), new AbstractJavaElementContentProvider(){

            @Override
            protected Object[][] computeProposals() {
                ITypeFilter filter = TypeFilters.getMultiTypeFilterAnd((ITypeFilter[])new ITypeFilter[]{ScoutTypeFilters.getInScoutBundles((IScoutBundle)PageNewAttributesWizardPage.this.getClientBundle()), TypeFilters.getClassFilter()});
                Set holders = TypeUtility.getPrimaryTypeHierarchy((IType)PageNewAttributesWizardPage.this.iPageWithNodes).getAllSubtypes(PageNewAttributesWizardPage.this.iPageWithNodes, filter);
                holders.addAll(TypeUtility.getPrimaryTypeHierarchy((IType)PageNewAttributesWizardPage.this.iOutline).getAllSubtypes(PageNewAttributesWizardPage.this.iOutline, filter));
                return new Object[][]{holders.toArray(new IType[holders.size()])};
            }
        });
        this.m_holderTypeField.acceptProposal(this.getHolderType());
        this.m_holderTypeField.addProposalAdapterListener(new IProposalAdapterListener(){

            @Override
            public void proposalAccepted(ContentProposalEvent event) {
                PageNewAttributesWizardPage.this.m_holderType = (IType)event.proposal;
                PageNewAttributesWizardPage.this.pingStateChanging();
            }
        });
        group.setLayout((Layout)new GridLayout(1, true));
        this.m_holderTypeField.setLayoutData(new GridData(768));
        return group;
    }

    @Override
    protected void validatePage(MultiStatus multiStatus) {
        try {
            multiStatus.add(this.getStatusClientBundle());
            if (!multiStatus.matches(4)) {
                multiStatus.add(this.getStatusNameField());
                multiStatus.add(this.getStatusTargetPackge());
            }
        }
        catch (JavaModelException e) {
            ScoutSdkUi.logError("could not validate name field.", e);
        }
    }

    protected IStatus getStatusTargetPackge() {
        return ScoutUtility.validatePackageName((String)this.getTargetPackage());
    }

    protected IStatus getStatusClientBundle() throws JavaModelException {
        if (this.getClientBundle() == null) {
            return new Status(4, "org.eclipse.scout.sdk.ui", Texts.get((String)"ClientBundleMissing"));
        }
        return Status.OK_STATUS;
    }

    protected IStatus getStatusNameField() throws JavaModelException {
        IStatus javaFieldNameStatus = ScoutUtility.validateJavaName((String)this.getTypeName(), (String)this.m_nameSuffix);
        if (javaFieldNameStatus.getSeverity() > 2) {
            return javaFieldNameStatus;
        }
        IStatus existingStatus = ScoutUtility.validateTypeNotExisting((IScoutBundle)this.getClientBundle(), (String)this.getTargetPackage(), (String)this.getTypeName());
        if (!existingStatus.isOK()) {
            return existingStatus;
        }
        return javaFieldNameStatus;
    }

    public IScoutBundle getClientBundle() {
        return this.m_clientBundle;
    }

    public INlsEntry getNlsName() {
        return this.m_nlsName;
    }

    public void setNlsName(INlsEntry nlsName) {
        try {
            this.setStateChanging(true);
            this.m_nlsName = nlsName;
            if (this.isControlCreated()) {
                this.m_nlsNameField.acceptProposal(nlsName);
            }
        }
        finally {
            this.setStateChanging(false);
        }
    }

    public String getTypeName() {
        return this.getPropertyString(PROP_TYPE_NAME);
    }

    public void setTypeName(String typeName) {
        try {
            this.setStateChanging(true);
            this.setTypeNameInternal(typeName);
            if (this.isControlCreated()) {
                this.m_typeNameField.setText(typeName);
            }
        }
        finally {
            this.setStateChanging(false);
        }
    }

    private void setTypeNameInternal(String typeName) {
        this.setPropertyString(PROP_TYPE_NAME, typeName);
    }

    public IType getSuperType() {
        return this.m_superType;
    }

    public void setSuperType(IType superType) {
        try {
            this.setStateChanging(true);
            this.m_superType = superType;
            if (TypeUtility.exists((IJavaElement)superType)) {
                ITypeHierarchy superTypeHierarchy = TypeUtility.getSupertypeHierarchy((IType)superType);
                this.m_nameSuffix = superTypeHierarchy.contains(this.iPageWithNodes) ? "NodePage" : (superTypeHierarchy.contains(this.iPageWithTable) ? "TablePage" : "Page");
            }
            if (this.isControlCreated()) {
                this.m_typeNameField.setReadOnlySuffix(this.m_nameSuffix);
            }
        }
        finally {
            this.setStateChanging(false);
        }
    }

    public void setHolderType(IType holderPage) {
        try {
            this.setStateChanging(true);
            this.m_holderType = holderPage;
            if (this.isControlCreated()) {
                this.m_holderTypeField.acceptProposal(holderPage);
            }
        }
        finally {
            this.setStateChanging(false);
        }
    }

    public IType getHolderType() {
        return this.m_holderType;
    }

    public void setHoderTypeEnabled(boolean hoderTypeEnabled) {
        if (this.isControlCreated()) {
            throw new IllegalStateException("control already created.");
        }
        this.m_hoderTypeEnabled = hoderTypeEnabled;
    }

    public boolean isHoderTypeEnabled() {
        return this.m_hoderTypeEnabled;
    }

    public String getTargetPackage() {
        return this.m_packageName;
    }

    public void setTargetPackage(String targetPackage) {
        try {
            this.setStateChanging(true);
            this.setTargetPackageInternal(targetPackage);
            if (this.isControlCreated() && this.m_entityField != null) {
                this.m_entityField.setText(targetPackage);
            }
        }
        finally {
            this.setStateChanging(false);
        }
    }

    protected void setTargetPackageInternal(String targetPackage) {
        this.m_packageName = targetPackage;
    }
}

