/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.util.ast.visitor;

import org.eclipse.jdt.core.IAnnotation;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.Annotation;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.IAnnotationBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.MarkerAnnotation;
import org.eclipse.jdt.core.dom.NormalAnnotation;
import org.eclipse.jdt.core.dom.SingleMemberAnnotation;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.scout.sdk.util.ast.visitor.DefaultAstVisitor;

public class TypeAnnotationAstVisitor
extends DefaultAstVisitor {
    private final String m_declaringTypeFqn;
    private final IAnnotation m_annotation;
    private final ASTVisitor m_visitor;
    private boolean m_inAnnotation;

    public TypeAnnotationAstVisitor(IAnnotation annotationToVisit, IType declaringType, ASTVisitor visitor) {
        this.m_annotation = annotationToVisit;
        this.m_declaringTypeFqn = declaringType.getFullyQualifiedName();
        this.m_visitor = visitor;
        this.m_inAnnotation = false;
    }

    @Override
    public boolean visitNode(ASTNode node) {
        if (this.m_inAnnotation) {
            node.accept(this.m_visitor);
        }
        return false;
    }

    @Override
    public boolean visit(CompilationUnit node) {
        return true;
    }

    private boolean visitAnnotation(Annotation node) {
        IJavaElement javaElement;
        boolean isAnnotationInteresting = false;
        IAnnotationBinding binding = node.resolveAnnotationBinding();
        if (binding != null && (javaElement = binding.getJavaElement()) != null) {
            isAnnotationInteresting = javaElement.equals(this.m_annotation);
        }
        this.m_inAnnotation = isAnnotationInteresting;
        return isAnnotationInteresting;
    }

    @Override
    public boolean visit(MarkerAnnotation node) {
        return this.visitAnnotation((Annotation)node);
    }

    @Override
    public boolean visit(SingleMemberAnnotation node) {
        return this.visitAnnotation((Annotation)node);
    }

    @Override
    public boolean visit(NormalAnnotation node) {
        return this.visitAnnotation((Annotation)node);
    }

    public void endVisit(MarkerAnnotation node) {
        this.m_inAnnotation = false;
    }

    public void endVisit(SingleMemberAnnotation node) {
        this.m_inAnnotation = false;
    }

    public void endVisit(NormalAnnotation node) {
        this.m_inAnnotation = false;
    }

    @Override
    public boolean visit(TypeDeclaration node) {
        ITypeBinding binding = node.resolveBinding();
        if (binding != null) {
            String curTypeFqn = ((IType)binding.getJavaElement()).getFullyQualifiedName();
            return this.m_declaringTypeFqn.startsWith(curTypeFqn);
        }
        return true;
    }
}

