/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.util.jdt;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IWorkspaceDescription;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jdt.core.IAnnotatable;
import org.eclipse.jdt.core.IAnnotation;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMemberValuePair;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.core.ToolFactory;
import org.eclipse.jdt.core.compiler.InvalidInputException;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.core.search.TypeNameRequestor;
import org.eclipse.jdt.internal.core.util.PublicScanner;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jdt.launching.environments.IExecutionEnvironment;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.service.resolver.State;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.sdk.util.internal.SdkUtilActivator;
import org.eclipse.scout.sdk.util.pde.LazyPluginModel;
import org.eclipse.scout.sdk.util.type.TypeUtility;
import org.osgi.framework.Bundle;
import org.osgi.framework.Version;

public final class JdtUtility {
    private static final String EXEC_ENV_PREFIX = "JavaSE-";
    private static final String MIN_JVM_VERSION = "1.7";

    private JdtUtility() {
    }

    public static IJavaElement findJavaElement(IFile javaFile, ITextSelection selection) throws JavaModelException {
        IJavaElement javaElement = JavaCore.create((IFile)javaFile);
        javaElement = JdtUtility.findJavaElement(javaElement, selection.getOffset(), selection.getLength());
        return javaElement;
    }

    public static boolean hasAnnotation(IAnnotatable element, String fullyQualifiedAnnotation) {
        return TypeUtility.exists((IJavaElement)JdtUtility.getAnnotation(element, fullyQualifiedAnnotation));
    }

    public static Double getAnnotationValueNumeric(IAnnotation annotation, String name) throws JavaModelException {
        if (TypeUtility.exists((IJavaElement)annotation)) {
            IMemberValuePair[] memberValues;
            IMemberValuePair[] iMemberValuePairArray = memberValues = annotation.getMemberValuePairs();
            int n = memberValues.length;
            int n2 = 0;
            while (n2 < n) {
                IMemberValuePair p = iMemberValuePairArray[n2];
                if (name.equals(p.getMemberName())) {
                    switch (p.getValueKind()) {
                        case 6: {
                            return (Double)p.getValue();
                        }
                        case 5: {
                            return ((Float)p.getValue()).doubleValue();
                        }
                        case 1: {
                            return ((Integer)p.getValue()).doubleValue();
                        }
                    }
                    break;
                }
                ++n2;
            }
        }
        return null;
    }

    public static String getDefaultJvmExecutionEnvironment() {
        String execEnv = "JavaSE-1.7";
        double execEnvVersion = JdtUtility.getExecEnvVersion(execEnv);
        IVMInstall defaultVm = JavaRuntime.getDefaultVMInstall();
        if (defaultVm != null) {
            IExecutionEnvironment[] iExecutionEnvironmentArray = JavaRuntime.getExecutionEnvironmentsManager().getExecutionEnvironments();
            int n = iExecutionEnvironmentArray.length;
            int n2 = 0;
            while (n2 < n) {
                double envVersion;
                IExecutionEnvironment env = iExecutionEnvironmentArray[n2];
                String executionEnvId = env.getId();
                if (env.isStrictlyCompatible(defaultVm) && (envVersion = JdtUtility.getExecEnvVersion(executionEnvId)) > execEnvVersion) {
                    execEnv = executionEnvId;
                }
                ++n2;
            }
        }
        return execEnv;
    }

    public static double getExecEnvVersion(String executionEnvId) {
        String numPart;
        if (executionEnvId != null && executionEnvId.startsWith(EXEC_ENV_PREFIX) && StringUtility.hasText((CharSequence)(numPart = executionEnvId.substring(EXEC_ENV_PREFIX.length())))) {
            try {
                double ret = Double.parseDouble(numPart);
                return ret;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return Double.parseDouble(MIN_JVM_VERSION);
    }

    public static String getAnnotationValueString(IAnnotation annotation, String name) throws JavaModelException {
        if (TypeUtility.exists((IJavaElement)annotation)) {
            IMemberValuePair[] memberValues;
            IMemberValuePair[] iMemberValuePairArray = memberValues = annotation.getMemberValuePairs();
            int n = memberValues.length;
            int n2 = 0;
            while (n2 < n) {
                Object val;
                IMemberValuePair p = iMemberValuePairArray[n2];
                if (name.equals(p.getMemberName()) && (val = p.getValue()) != null) {
                    return "" + val;
                }
                ++n2;
            }
        }
        return null;
    }

    private static String getAnnotationSourceFixed(IMember member, IAnnotation annotation, String startSimple) {
        try {
            String diff;
            int offset;
            String icuSource;
            ISourceRange annotSourceRange = annotation.getSourceRange();
            ISourceRange ownerSourceRange = member.getSourceRange();
            if (annotSourceRange != null && ownerSourceRange != null && annotSourceRange.getOffset() >= 0 && ownerSourceRange.getOffset() >= 0 && ownerSourceRange.getOffset() > annotSourceRange.getOffset() && (icuSource = member.getCompilationUnit().getSource()) != null && icuSource.length() >= ownerSourceRange.getOffset() && (offset = (diff = icuSource.substring(annotSourceRange.getOffset(), ownerSourceRange.getOffset())).lastIndexOf(startSimple)) >= 0) {
                int end = (offset += annotSourceRange.getOffset()) + annotSourceRange.getLength();
                if (icuSource.length() >= end) {
                    return icuSource.substring(offset, end);
                }
            }
        }
        catch (JavaModelException e) {
            SdkUtilActivator.logWarning("Unable to find source for annotation '" + annotation.getElementName() + "' in '" + member.getElementName() + "'.", e);
        }
        return null;
    }

    public static IAnnotation getAnnotation(IAnnotatable element, String fullyQualifiedAnnotation) {
        if (element == null) {
            return null;
        }
        String simpleName = Signature.getSimpleName((String)fullyQualifiedAnnotation);
        String startSimple = String.valueOf('@') + simpleName;
        String startFq = String.valueOf('@') + fullyQualifiedAnnotation;
        String annotSource = null;
        IAnnotation annotation = element.getAnnotation(simpleName);
        if (TypeUtility.exists((IJavaElement)annotation)) {
            try {
                annotSource = StringUtility.trim((String)annotation.getSource());
            }
            catch (Exception e) {
                SdkUtilActivator.logWarning("Could not get source of annotation '" + fullyQualifiedAnnotation + "' in element '" + element.toString() + "'.", e);
            }
            if (annotSource == null || annotSource.startsWith(startSimple) || annotSource.startsWith(startFq)) {
                return annotation;
            }
            if (element instanceof IMember && (annotSource = JdtUtility.getAnnotationSourceFixed((IMember)element, annotation, startSimple)) != null && (annotSource.startsWith(startSimple) || annotSource.startsWith(startFq))) {
                return annotation;
            }
        }
        if (TypeUtility.exists((IJavaElement)(annotation = element.getAnnotation(fullyQualifiedAnnotation)))) {
            try {
                annotSource = StringUtility.trim((String)annotation.getSource());
            }
            catch (Exception e) {
                SdkUtilActivator.logWarning("Could not get source of annotation '" + fullyQualifiedAnnotation + "' in element '" + element.toString() + "'.", e);
            }
            if (annotSource == null || annotSource.startsWith(startSimple) || annotSource.startsWith(startFq)) {
                return annotation;
            }
            if (element instanceof IMember && (annotSource = JdtUtility.getAnnotationSourceFixed((IMember)element, annotation, startSimple)) != null && (annotSource.startsWith(startSimple) || annotSource.startsWith(startFq))) {
                return annotation;
            }
        }
        return null;
    }

    public static String toStringLiteral(String s) {
        if (s == null) {
            return null;
        }
        int len = s.length();
        StringBuilder b = new StringBuilder(len + 2);
        b.append('\"');
        int i = 0;
        while (i < len) {
            char c = s.charAt(i);
            switch (c) {
                case '\b': {
                    b.append("\\b");
                    break;
                }
                case '\t': {
                    b.append("\\t");
                    break;
                }
                case '\n': {
                    b.append("\\n");
                    break;
                }
                case '\f': {
                    b.append("\\f");
                    break;
                }
                case '\r': {
                    b.append("\\r");
                    break;
                }
                case '\"': {
                    b.append("\\\"");
                    break;
                }
                case '\\': {
                    b.append("\\\\");
                    break;
                }
                case '\u0000': {
                    b.append("\\0");
                    break;
                }
                case '\u0001': {
                    b.append("\\1");
                    break;
                }
                case '\u0002': {
                    b.append("\\2");
                    break;
                }
                case '\u0003': {
                    b.append("\\3");
                    break;
                }
                case '\u0004': {
                    b.append("\\4");
                    break;
                }
                case '\u0005': {
                    b.append("\\5");
                    break;
                }
                case '\u0006': {
                    b.append("\\6");
                    break;
                }
                case '\u0007': {
                    b.append("\\7");
                    break;
                }
                default: {
                    b.append(c);
                }
            }
            ++i;
        }
        b.append('\"');
        return b.toString();
    }

    public static String fromStringLiteral(String s) {
        if (s == null) {
            return null;
        }
        int len = s.length();
        if (len < 2 || s.charAt(0) != '\"' || s.charAt(len - 1) != '\"') {
            return null;
        }
        PublicScanner scanner = (PublicScanner)ToolFactory.createScanner((boolean)true, (boolean)true, (boolean)false, (String)MIN_JVM_VERSION, (String)MIN_JVM_VERSION);
        char[] source = s.toCharArray();
        scanner.setSource(source);
        scanner.resetTo(0, source.length);
        try {
            int tokenType = scanner.getNextToken();
            if (tokenType == 45) {
                String literal = scanner.getCurrentStringLiteral();
                if (scanner.getNextChar() == -1) {
                    return literal;
                }
            }
        }
        catch (InvalidInputException e) {
            SdkUtilActivator.logWarning("String '" + s + "' is not a valid java string literal.", e);
        }
        return null;
    }

    public static Version getTargetPlatformVersion() {
        BundleDescription platform = JdtUtility.getNewestBundleInActiveTargetPlatform("org.eclipse.platform");
        if (platform != null) {
            return platform.getVersion();
        }
        return null;
    }

    private static IJavaElement findJavaElement(IJavaElement element, int offset, int lenght) throws JavaModelException {
        if (element == null) {
            return null;
        }
        switch (element.getElementType()) {
            case 5: {
                IType[] icuTypes;
                ICompilationUnit icu = (ICompilationUnit)element;
                IType[] iTypeArray = icuTypes = icu.getTypes();
                int n = icuTypes.length;
                int n2 = 0;
                while (n2 < n) {
                    IType t = iTypeArray[n2];
                    if (t.getSourceRange().getOffset() < offset && t.getSourceRange().getOffset() + t.getSourceRange().getLength() > offset + lenght) {
                        return JdtUtility.findJavaElement((IJavaElement)t, offset, lenght);
                    }
                    ++n2;
                }
                if (icuTypes.length <= 0) break;
                return icuTypes[0];
            }
            case 7: {
                IType[] iTypeArray = ((IType)element).getTypes();
                int n = iTypeArray.length;
                int n3 = 0;
                while (n3 < n) {
                    IType t = iTypeArray[n3];
                    if (t.getSourceRange().getOffset() < offset && t.getSourceRange().getOffset() + t.getSourceRange().getLength() > offset + lenght) {
                        return JdtUtility.findJavaElement((IJavaElement)t, offset, lenght);
                    }
                    ++n3;
                }
                iTypeArray = ((IType)element).getMethods();
                n = iTypeArray.length;
                n3 = 0;
                while (n3 < n) {
                    IType m = iTypeArray[n3];
                    if (m.getSourceRange().getOffset() < offset && m.getSourceRange().getOffset() + m.getSourceRange().getLength() > offset + lenght) {
                        return JdtUtility.findJavaElement((IJavaElement)m, offset, lenght);
                    }
                    ++n3;
                }
                break;
            }
        }
        return element;
    }

    public static IType findDeclaringType(IJavaElement element) {
        if (element == null) {
            return null;
        }
        if (element.getElementType() == 7) {
            return (IType)element;
        }
        return JdtUtility.findDeclaringType(element.getParent());
    }

    public static void waitForSilentWorkspace() {
        Job worker = new Job(""){

            protected IStatus run(IProgressMonitor monitor) {
                return Status.OK_STATUS;
            }
        };
        worker.setRule((ISchedulingRule)ResourcesPlugin.getWorkspace().getRoot());
        worker.schedule();
        try {
            worker.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        JdtUtility.waitForRefresh();
        JdtUtility.waitForBuild();
        JdtUtility.waitForIndexesReady();
    }

    public static void waitForBuild() {
        JdtUtility.waitForJobFamily(ResourcesPlugin.FAMILY_MANUAL_BUILD);
        JdtUtility.waitForJobFamily(ResourcesPlugin.FAMILY_AUTO_BUILD);
    }

    public static void waitForRefresh() {
        JdtUtility.waitForJobFamily(ResourcesPlugin.FAMILY_AUTO_REFRESH);
        JdtUtility.waitForJobFamily(ResourcesPlugin.FAMILY_MANUAL_REFRESH);
    }

    public static void waitForIndexesReady() {
        SearchEngine engine = new SearchEngine();
        IJavaSearchScope scope = SearchEngine.createWorkspaceScope();
        try {
            engine.searchAllTypeNames(null, 0, "!@$#!@".toCharArray(), 10, 5, scope, new TypeNameRequestor(){

                public void acceptType(int modifiers, char[] packageName, char[] simpleTypeName, char[][] enclosingTypeNames, String path) {
                }
            }, 3, null);
        }
        catch (JavaModelException e) {
            SdkUtilActivator.logInfo("unable to wait for JDT indexes", e);
        }
    }

    public static void waitForManualRefresh() {
        JdtUtility.waitForJobFamily(ResourcesPlugin.FAMILY_MANUAL_REFRESH);
    }

    public static void waitForJdt() {
        JdtUtility.waitForJobFamily("org.eclipse.jdt.ui");
    }

    public static void waitForJobFamily(Object family) {
        boolean wasInterrupted = false;
        do {
            try {
                Job.getJobManager().join(family, null);
                wasInterrupted = false;
            }
            catch (OperationCanceledException operationCanceledException) {
            }
            catch (InterruptedException e) {
                wasInterrupted = true;
            }
        } while (wasInterrupted);
    }

    public static boolean areAllPluginsInstalled(String ... pluginIds) {
        if (pluginIds == null) {
            return true;
        }
        String[] stringArray = pluginIds;
        int n = pluginIds.length;
        int n2 = 0;
        while (n2 < n) {
            String pluginId = stringArray[n2];
            Bundle b = Platform.getBundle((String)pluginId);
            if (b == null) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public static BundleDescription getNewestBundleInActiveTargetPlatform(String symbolicName) {
        State state = LazyPluginModel.getPdeState().getState();
        BundleDescription[] allBundleVersions = state.getBundles(symbolicName);
        Version v = null;
        BundleDescription newest = null;
        BundleDescription[] bundleDescriptionArray = allBundleVersions;
        int n = allBundleVersions.length;
        int n2 = 0;
        while (n2 < n) {
            BundleDescription d = bundleDescriptionArray[n2];
            if (d != null && (v == null || d.getVersion().compareTo(v) > 0)) {
                v = d.getVersion();
                newest = d;
            }
            ++n2;
        }
        return newest;
    }

    public static void setWorkspaceAutoBuilding(boolean autoBuild) throws CoreException {
        IWorkspaceDescription description = ResourcesPlugin.getWorkspace().getDescription();
        if (description.isAutoBuilding() != autoBuild) {
            description.setAutoBuilding(autoBuild);
            ResourcesPlugin.getWorkspace().setDescription(description);
        }
    }

    public static boolean isWorkspaceAutoBuilding() throws CoreException {
        return ResourcesPlugin.getWorkspace().getDescription().isAutoBuilding();
    }

    public static boolean isBatik17OrNewer() {
        BundleDescription batikUtil = JdtUtility.getNewestBundleInActiveTargetPlatform("org.apache.batik.util");
        return batikUtil != null && (batikUtil.getVersion().getMajor() == 1 && batikUtil.getVersion().getMinor() >= 7 || batikUtil.getVersion().getMajor() > 1);
    }
}

